import { type BaseParseContext, type BaseRoot, type Morph, type NodeSelector, type Predicate, type TypeMeta, type unwrapDefault } from "@ark/schema";
import { type array, type BuiltinObjectKind, type Constructor, type Domain, type show } from "@ark/util";
import type { defaultFor, distill, inferIntersection, inferMorphOut, inferPipe, inferPredicate, Out, withDefault } from "../attributes.ts";
import type { type } from "../keywords/keywords.ts";
import type { inferDefinition, validateDefinition } from "./definition.ts";
import { writeMissingRightOperandMessage } from "./shift/operand/unenclosed.ts";
import type { InfixToken } from "./shift/tokens.ts";
import type { BaseCompletions } from "./string.ts";
export declare const maybeParseTupleExpression: (def: array, ctx: BaseParseContext) => BaseRoot | null;
export type maybeValidateTupleExpression<def extends array, $, args> = def extends IndexZeroExpression ? validatePrefixExpression<def, $, args> : def extends IndexOneExpression ? validateIndexOneExpression<def, $, args> : def extends (readonly ["", ...unknown[]] | readonly [unknown, "", ...unknown[]]) ? readonly [
    def[0] extends "" ? BaseCompletions<$, args, IndexZeroOperator | "..."> : def[0],
    def[1] extends "" ? BaseCompletions<$, args, IndexOneOperator | "..."> : def[1]
] : null;
export type inferTupleExpression<def extends TupleExpression, $, args> = def[1] extends "[]" ? inferDefinition<def[0], $, args>[] : def[1] extends "?" ? inferDefinition<def[0], $, args> : def[1] extends "&" ? inferIntersection<inferDefinition<def[0], $, args>, inferDefinition<def[2], $, args>> : def[1] extends "|" ? inferDefinition<def[0], $, args> | inferDefinition<def[2], $, args> : def[1] extends ":" ? inferPredicate<inferDefinition<def[0], $, args>, def[2]> : def[1] extends "=>" ? parseMorph<def[0], def[2], $, args> : def[1] extends "|>" ? parseTo<def[0], def[2], $, args> : def[1] extends "=" ? withDefault<inferDefinition<def[0], $, args>, unwrapDefault<def[2]>> : def[1] extends "@" ? inferDefinition<def[0], $, args> : def extends readonly ["===", ...infer values] ? values[number] : def extends (readonly ["instanceof", ...infer constructors extends Constructor[]]) ? InstanceType<constructors[number]> : def[0] extends "keyof" ? inferKeyOfExpression<def[1], $, args> : never;
export type validatePrefixExpression<def extends IndexZeroExpression, $, args> = def["length"] extends 1 ? readonly [writeMissingRightOperandMessage<def[0]>] : def[0] extends "keyof" ? readonly [def[0], validateDefinition<def[1], $, args>] : def[0] extends "===" ? readonly [def[0], ...unknown[]] : def[0] extends "instanceof" ? readonly [def[0], ...Constructor[]] : never;
export type validateIndexOneExpression<def extends IndexOneExpression, $, args> = def[1] extends TuplePostfixOperator ? readonly [validateDefinition<def[0], $, args>, def[1]] : readonly [
    validateDefinition<def[0], $, args>,
    def["length"] extends 2 ? writeMissingRightOperandMessage<def[1]> : def[1],
    def[1] extends "|" ? validateDefinition<def[2], $, args> : def[1] extends "&" ? validateDefinition<def[2], $, args> : def[1] extends ":" ? Predicate<type.infer.Out<def[0], $, args>> : def[1] extends "=>" ? Morph<type.infer.Out<def[0], $, args>> : def[1] extends "|>" ? validateDefinition<def[2], $, args> : def[1] extends "=" ? defaultFor<type.infer.In<def[0], $, args>> : def[1] extends "@" ? TypeMeta.MappableInput : validateDefinition<def[2], $, args>,
    ...(def[1] extends "@" ? [NodeSelector?] : [])
];
export type UnparsedTupleExpressionInput = {
    instanceof: Constructor;
    "===": unknown;
};
export type UnparsedTupleOperator = show<keyof UnparsedTupleExpressionInput>;
export declare const parseKeyOfTuple: IndexZeroParser<"keyof">;
export type inferKeyOfExpression<operandDef, $, args> = show<keyof inferDefinition<operandDef, $, args>>;
export type TupleExpression = IndexZeroExpression | IndexOneExpression;
export type TupleExpressionOperator = IndexZeroOperator | IndexOneOperator;
export type ArgTwoOperator = Exclude<IndexOneOperator, "?" | "=">;
export declare const parseMorphTuple: IndexOneParser<"=>">;
export declare const writeMalformedFunctionalExpressionMessage: (operator: ":" | "=>", value: unknown) => string;
export type parseTo<inDef, outDef, $, args> = inferPipe<inferDefinition<inDef, $, args>, inferDefinition<outDef, $, args>>;
export type parseMorph<inDef, morph, $, args> = morph extends Morph ? inferMorphOut<morph> extends infer out ? (In: distill.In<inferDefinition<inDef, $, args>>) => Out<out> : never : never;
export declare const parseNarrowTuple: IndexOneParser<":">;
export type IndexOneExpression<token extends string = IndexOneOperator> = readonly [unknown, token, ...unknown[]];
type IndexOneParser<token extends string> = (def: IndexOneExpression<token>, ctx: BaseParseContext) => BaseRoot;
declare const postfixParsers: {
    "?": IndexOneParser<"?">;
    "[]": IndexOneParser<"[]">;
};
export type TuplePostfixOperator = keyof typeof postfixParsers;
declare const infixParsers: {
    "&": IndexOneParser<"&">;
    "|": IndexOneParser<"|">;
    "|>": IndexOneParser<"|>">;
    "=": IndexOneParser<"=">;
    ":": IndexOneParser<":">;
    "=>": IndexOneParser<"=>">;
    "@": IndexOneParser<"@">;
};
export type TupleInfixOperator = keyof typeof infixParsers;
declare const indexOneParsers: {
    "&": IndexOneParser<"&">;
    "|": IndexOneParser<"|">;
    "|>": IndexOneParser<"|>">;
    "=": IndexOneParser<"=">;
    ":": IndexOneParser<":">;
    "=>": IndexOneParser<"=>">;
    "@": IndexOneParser<"@">;
    "?": IndexOneParser<"?">;
    "[]": IndexOneParser<"[]">;
};
export type IndexOneOperator = keyof typeof indexOneParsers;
export type InfixExpression = readonly [unknown, InfixToken, ...unknown[]];
type IndexZeroParser<token extends string> = (def: IndexZeroExpression<token>, ctx: BaseParseContext) => BaseRoot;
type IndexZeroExpression<token extends string = IndexZeroOperator> = readonly [
    token,
    ...unknown[]
];
declare const indexZeroParsers: {
    keyof: IndexZeroParser<"keyof">;
    instanceof: IndexZeroParser<"instanceof">;
    "===": IndexZeroParser<"===">;
};
export type IndexZeroOperator = keyof typeof indexZeroParsers;
export declare const writeInvalidConstructorMessage: <actual extends Domain | BuiltinObjectKind>(actual: actual) => string;
export {};
