## 7.5.0 (20/05/2024)
* Add `AsSet()` accessor (#173)

## 7.4.2 (10/05/2024)
* Fix docstrings for positive/negative int/float validators (#172)

## 7.4.1 (29/08/2023)
* Fix 7.4.0 issues with `create-react-app` polyfill (#168)

## 7.4.0 (21/08/2023)
* Do not use `process.env` by default in non-Node.js environments (#155)

## 7.3.1 (24/04/2023)
* Fix parsing even floating point numbers (#166)

## 7.3.0 (06/09/2022)
* Add missing `asEmailString()` typings (#160)

## 7.2.0 (01/09/2022)
* Add `asEmailString()` accessor (#146)

## 7.1.1 (28/10/2021)
* Fix duplicate identifier error for TypeScript builds (#151)

## 7.1.0 (28/10/2021)
* Support type narrowed `process.env`/record and remove unused type (#148)
* Add support for `readonly T[]` generic use with `asEnum()`

## 7.0.1
* Fix loose float and int parsing (PR #144)

## 7.0.0 (11/11/2020)
* Drop support for Node.js 8 and 13 (support only current, active, and maintenance versions)
* Improve support for browser usage (#138)
* Fix documentation errors (#139)

## 6.3.0 (27/07/2020)
* Add `asRegExp` accessor (#136)
* Add better TypeScript example for custom accessors (#133)

## 6.2.0 (12/06/2020)
* Add `accessors` property to the public API for use in building `extraAccessors` (#121)
* Add support for logging with a built-in or custom logger (#112)
* Add Node.js v14 to CI builds
* Add single quote rule to `.editorconfig` (#129)
* Add JavaScript example for `extraAccesors` (#129)
* Fix `extraAccessors` args type error (#131)
* Fix types and docs for `asUrlString()` and `asUrlObject()` (#132)
* Update README for `asUrlString()` to mention WHATWG URL behaviour (#126, #129)

## 6.1.1 (22/04/2020)
* Fix TS error with *ExtenderTypeOptional* and *ExtenderType* typings (#119)

## 6.1.0 (20/04/2020)
* Fix TS error with *extraAccessor* typings (#114)
* Add support for generic types in *asEnum* (#116)

## 6.0.4 (04/03/2020)
* Fix compilation error caused by typings generic issue.

## 6.0.3 (03/03/2020)
* Fix typings to support `required()`, `convertFromBase64()`, etc. with `ExtensionFn`.

## 6.0.2 (29/02/2020)
* Fix `default()` so that it correctly returns an empty string value if provided.
* README improvement by @joh-klein for positive/negative number parsing rules.

## 6.0.1 (12/02/2020)
* Fix typings for the `default(value)` function.

## 6.0.0 (12/02/2020)
* Add support for setting an example value via the `example(string)` function.
* Passing default values is now performed using the `default(string)` function.
* Defer checks for `required()` until an accessor such as `asString()` is invoked.
* Fix typings issue where `required()` was undefined on a `IPresentVariable`.
* Improve error message output.

Migration from 5.x to 6.0.0 should be smooth. Change any instance of
`env.get(target, default)` to `env.get(target).default(default)`. For example:

```js
// Old 5.x code
const emailAddr = env.get('EMAIL_ADDR', 'admin@example.com').asString()

// New 6.x compatible code
const emailAddr = env.get('EMAIL_ADDR').default('admin@example.com').asString()
```

## 5.2.0 (22/11/2019)
* The `required()` function now verifies the variable is not an empty string

## 5.1.0 (09/09/2019)
* Ability to add custom accessors in PR #72 (thanks @todofixthis)
* Improved TypeScript tests
* Fixed warning generated by husky

## 5.0.0 (14/06/2019)
* Return values from `asArray()` are now more intuitive & consitent
* `asUrlString()` and `asUrlObject`now use the built-in `URL` class in Node.js
to perform validation
* README updated in accordance with changes listed above

## 4.1.0 (14/06/2019)
* Add `asPortNumber()` function
* Update documentation structure

## 4.0.1 (24/05/2019)
* Add node `process.env` typings to `env.from`

## 4.0.0 (09/04/2019)
* Rename `.env.mock()` to `env.from()`
* Change module internals per issue #39
* Update docs related to `env.mock`

## 3.5.0 (02/29/2019)
* Update `required()` to support boolean paramter to bypass the check

## 3.4.2 (06/11/2018)
* Fix README badge copy/paste error

## 3.4.1 (06/11/2018)
* Fix TypeScript definition for "asBoolStrict" function name

## 3.4.0 (24/10/2018)
* Add `convertFromBase64()` function
* Enable Greenkeeper

## 3.3.0 (26/06/2018)
* Add `asEnum` functionality

## 3.2.0 (15/06/2018)
* Remove @types/node dependency

## 3.1.0 (11/12/2017)
* Update typings to correctly handle default values for numeric types.
* Ensure an error is thrown when `asArray` does not detect at least a single non-empty value.

## 3.0.2 (19/10/2017)
* Restore support for use in browser based applications

## 3.0.1 (19/10/2017)
* Fix bug that caused default values to be ignored

## 3.0.0 (13/10/2017)
* Public API no longer is a function, instead exposes two functions, `mock` and `get`
* Drop support for Node.js versions less than 4.0
* Rename `asPositiveInt` to `asIntPositive`
* Rename `asNegativeInt` to `asIntNegative`
* Rename `asStrictBool` to `asBoolStrict`
* Add `asFloatPositive` and `asFloatNegative`
* Add `asUrlString` and `asUrlObject`
* Refactor code with consistent errors and structure
* Use `standard` for code quality and formatting

## 2.4.3 (5/04/2017)
* Update with build, coverage, and version information badges

## 2.4.2 (19/12/2016)
* Fix TypeScript definition file

## 2.4.1 (15/12/2016)
* Remove unnecessary code path

## 2.4.0 (15/12/2016)
* Add `asArray([delimeter])` to read environment variables as an array by splitting
the varible string on each instance of _delimeter_;
* Add `asJsonArray()` to read in an environment variable that contains a JSON
Array. Similar to `asJson()`, but ensures the variable is an Array.
* Add `asJsonObject()` to read in an environment variable that contains a JSON
Object. Similar to `asJson()`, but ensures the variable is an Object.

## 2.3.0 & 2.3.1 (12/12/2016)
* Add typings support for TypeScript

## 2.2.0 (28/10/2016)
* Thanks to @itavy for a patch for our _asBool_ parsing and adding the new
_asStrictBool_ function

## 2.1.0 (25/10/2016)
* Added _env.mock_ PR from @MikeyBurkman to improve testability

## 2.0.0 (27/07/2016)
* Add CI process for node 6, 5, 4, and 0.10
* Add chained functions for variable validations
* Add assertions for _required()_ and various type checks, e.g _asPositiveInt(_)
* Remove node 0.8.x support
* Remove old pattern of returning variables directly
* Continue support for defaults from 1.X

## <2.0.0
* Venture forth at thine own risk, for here be dragons
