/* @vitest-environment node */
import { beforeEach, describe, expect, it, vi } from 'vitest';
const readGlobalConfig = vi.fn();
const writeGlobalConfig = vi.fn();
const discoverRegistryFromSite = vi.fn();
vi.mock('../config.js', () => ({
    readGlobalConfig: (...args) => readGlobalConfig(...args),
    writeGlobalConfig: (...args) => writeGlobalConfig(...args),
}));
vi.mock('../discovery.js', () => ({
    discoverRegistryFromSite: (...args) => discoverRegistryFromSite(...args),
}));
const { DEFAULT_REGISTRY, getRegistry, resolveRegistry } = await import('./registry');
function makeOpts(overrides = {}) {
    return {
        workdir: '/work',
        dir: '/work/skills',
        site: 'https://clawdhub.com',
        registry: DEFAULT_REGISTRY,
        registrySource: 'default',
        ...overrides,
    };
}
beforeEach(() => {
    readGlobalConfig.mockReset();
    writeGlobalConfig.mockReset();
    discoverRegistryFromSite.mockReset();
});
describe('registry resolution', () => {
    it('prefers explicit registry over discovery/cache', async () => {
        readGlobalConfig.mockResolvedValue({ registry: 'https://auth.clawdhub.com' });
        discoverRegistryFromSite.mockResolvedValue({ apiBase: 'https://clawdhub.com' });
        const registry = await resolveRegistry(makeOpts({ registry: 'https://custom.example', registrySource: 'cli' }));
        expect(registry).toBe('https://custom.example');
        expect(discoverRegistryFromSite).not.toHaveBeenCalled();
    });
    it('ignores legacy registry and updates cache from discovery', async () => {
        readGlobalConfig.mockResolvedValue({ registry: 'https://auth.clawdhub.com', token: 'tkn' });
        discoverRegistryFromSite.mockResolvedValue({ apiBase: 'https://clawdhub.com' });
        const registry = await getRegistry(makeOpts(), { cache: true });
        expect(registry).toBe('https://clawdhub.com');
        expect(writeGlobalConfig).toHaveBeenCalledWith({
            registry: 'https://clawdhub.com',
            token: 'tkn',
        });
    });
});
//# sourceMappingURL=registry.test.js.map