import type { ErrorMessage, Scanner, WhitespaceChar } from "@ark/util";
import type { Control, ReferenceNode, s, State } from "./state.ts";
export type parseEscape<s extends State, unscanned extends string> = unscanned extends Scanner.shift<infer char, infer nextUnscanned> ? char extends NonZeroDigit ? parseNumericBackreference<s, unscanned> : char extends "k" ? parseNamedBackreference<s, nextUnscanned> : char extends UnicodePropertyChar ? parseUnicodeProperty<s, char, nextUnscanned> : parseSingleEscapedCharacter<s, char, nextUnscanned> : s.error<trailingBackslashMessage>;
type parseNumericBackreference<s extends State, fullUnscanned extends string> = Scanner.shiftUntilNot<fullUnscanned, StringDigit> extends (Scanner.shiftResult<infer ref, infer remaining>) ? s.shiftQuantifiable<s, ReferenceNode<ref>, remaining> : never;
type parseNamedBackreference<s extends State, unscanned extends string> = unscanned extends `<${infer ref}>${infer following}` ? s.shiftQuantifiable<s, ReferenceNode<ref>, following> : s.error<missingBackreferenceNameMessage>;
type parseUnicodeProperty<s extends State, char extends UnicodePropertyChar, unscanned extends string> = unscanned extends `{${string}}${infer following}` ? s.shiftQuantifiable<s, string, following> : s.error<writeInvalidUnicodePropertyMessage<char>>;
type parseSingleEscapedCharacter<s extends State, char extends string, remaining extends string> = parseEscapedChar<char> extends infer result extends string ? result extends ErrorMessage ? s.error<result> : s.shiftQuantifiable<s, result, remaining> : never;
export type parseEscapedChar<char extends string> = char extends RegexClassChar ? string : char extends "d" ? `${number}` : char extends "s" ? WhitespaceChar : char extends BoundaryChar ? "" : char extends Control ? char : char extends "c" ? ErrorMessage<caretNotationMessage> : char extends StringEscapableChar ? ErrorMessage<writeStringEscapableMessage<char>> : ErrorMessage<writeUnnecessaryEscapeMessage<char>>;
export declare const trailingBackslashMessage = "A regex cannot end with \\";
export type trailingBackslashMessage = typeof trailingBackslashMessage;
export declare const writeUnresolvableBackreferenceMessage: <ref extends string | number>(ref: ref) => writeUnresolvableBackreferenceMessage<ref>;
export type writeUnresolvableBackreferenceMessage<ref extends string | number> = `Group ${ref} does not exist`;
export declare const missingBackreferenceNameMessage = "\\k must be followed by a named reference like <name>";
export type missingBackreferenceNameMessage = typeof missingBackreferenceNameMessage;
export declare const writeInvalidUnicodePropertyMessage: <char extends UnicodePropertyChar>(char: char) => writeInvalidUnicodePropertyMessage<char>;
export type writeInvalidUnicodePropertyMessage<char extends UnicodePropertyChar> = `\\${char} must be followed by a property like \\${char}{Emoji_Presentation}`;
export declare const writeUnnecessaryEscapeMessage: <char extends string>(char: char) => writeUnnecessaryEscapeMessage<char>;
export type writeUnnecessaryEscapeMessage<char extends string> = `Escape preceding ${char} is unnecessary and should be removed.`;
export declare const writeStringEscapableMessage: (char: StringEscapableChar) => "\\v should be specified with a single backslash like regex('\\n')" | "\\u should be specified with a single backslash like regex('\\n')" | "\\0 should be specified with a single backslash like regex('\\n')" | "\\t should be specified with a single backslash like regex('\\n')" | "\\n should be specified with a single backslash like regex('\\n')" | "\\r should be specified with a single backslash like regex('\\n')" | "\\f should be specified with a single backslash like regex('\\n')" | "\\x should be specified with a single backslash like regex('\\n')";
export type writeStringEscapableMessage<char extends StringEscapableChar> = `\\${char} should be specified with a single backslash like regex('\n')`;
export declare const caretNotationMessage = "\\\\cX notation is not supported. Use hex (\\\\x) or unicode (\\\\u) instead.";
export type caretNotationMessage = "\\cX notation is not supported. Use hex (\\x) or unicode (\\u) instead.";
export type StringEscapableChar = "t" | "n" | "r" | "f" | "v" | "0" | "x" | "u";
export type RegexClassChar = "w" | "W" | "D" | "S";
export type BoundaryChar = "b" | "B";
export type UnicodePropertyChar = "p" | "P";
export type NonZeroDigit = "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9";
export type StringDigit = "0" | NonZeroDigit;
export {};
