import type { ErrorMessage, Scanner, writeUnclosedGroupMessage } from "@ark/util";
import type { State, s } from "./state.ts";
type LookaroundChar = "=" | "!";
export type ModifiableFlag = "i" | "m" | "s";
export type parseGroup<s extends State, unscanned extends string> = unscanned extends Scanner.shift<infer lookahead, infer next> ? lookahead extends "?" ? parseNonCapturingGroup<s, next> : s.pushGroup<s, State.UnnamedCaptureKind.indexed, unscanned, undefined> : s.error<writeUnclosedGroupMessage<")">>;
type parseNonCapturingGroup<s extends State, unscanned extends string> = unscanned extends Scanner.shift<infer lookahead, infer next> ? lookahead extends ":" ? s.pushGroup<s, State.UnnamedCaptureKind.noncapturing, next, undefined> : lookahead extends LookaroundChar ? s.pushGroup<s, State.UnnamedCaptureKind.lookaround, next, undefined> : lookahead extends "<" ? parseNamedGroupOrLookbehind<s, next> : shiftModifiers<unscanned> extends (ShiftedModifiers<infer flags, infer negated, infer following>) ? following extends ErrorMessage<infer message> ? s.error<message> : s.pushGroup<s, State.UnnamedCaptureKind.noncapturing, following, "i" extends flags ? true : "i" extends negated ? false : undefined> : never : s.error<writeUnclosedGroupMessage<")">>;
type ShiftedModifiers<flags extends ModifiableFlag = ModifiableFlag, negated extends ModifiableFlag = ModifiableFlag, unscanned extends string = string> = [ParsedModifiers<flags, negated>, unscanned];
type ParsedModifiers<flags extends ModifiableFlag = ModifiableFlag, negated extends ModifiableFlag = ModifiableFlag> = {
    flags: flags;
    negated: negated;
};
type shiftModifiers<unscanned extends string> = Scanner.shiftUntil<unscanned, ":" | ")"> extends (Scanner.shiftResult<infer scanned, infer next>) ? next extends Scanner.shift<infer terminator, infer following> ? terminator extends ":" ? parseModifiers<scanned> extends (ParsedModifiers<infer flags, infer negated>) ? ShiftedModifiers<flags, negated, following> : ShiftedModifiers<never, never, ErrorMessage<parseModifiers<scanned> & string>> : ShiftedModifiers<never, never, ErrorMessage<unescapedLiteralQuestionMarkMessage>> : ShiftedModifiers<never, never, ErrorMessage<writeUnclosedGroupMessage<")">>> : never;
type parseModifiers<unscanned extends string> = _parseModifiers<unscanned, never, never>;
type _parseModifiers<unscanned extends string, flags extends ModifiableFlag, negated extends ModifiableFlag> = unscanned extends Scanner.shift<infer lookahead, infer next> ? lookahead extends "-" ? [
    negated
] extends [never] ? next extends Scanner.shift<infer modifier, infer next> ? modifier extends ModifiableFlag ? modifier extends flags | negated ? writeDuplicateModifierMessage<modifier> : _parseModifiers<next, flags, negated | modifier> : writeInvalidModifierMessage<modifier> : missingNegatedModifierMessage : multipleModifierDashesMessage : lookahead extends ModifiableFlag ? lookahead extends flags | negated ? writeDuplicateModifierMessage<lookahead> : [
    negated
] extends [never] ? _parseModifiers<next, flags | lookahead, negated> : _parseModifiers<next, flags, negated | lookahead> : writeInvalidModifierMessage<lookahead> : ParsedModifiers<flags, negated>;
export declare const writeDuplicateModifierMessage: <modifier extends ModifiableFlag>(modifier: modifier) => writeDuplicateModifierMessage<modifier>;
type writeDuplicateModifierMessage<modifier extends ModifiableFlag> = `Modifier ${modifier} cannot appear multiple times in a single group`;
export declare const multipleModifierDashesMessage = "Modifiers can include at most one '-' to negate subsequent flags";
type multipleModifierDashesMessage = typeof multipleModifierDashesMessage;
export declare const missingNegatedModifierMessage = "- must be followed by the modifier flag to negate ('i', 'm' or 's')";
type missingNegatedModifierMessage = typeof missingNegatedModifierMessage;
export declare const writeInvalidModifierMessage: <char extends string>(char: char) => writeInvalidModifierMessage<char>;
type writeInvalidModifierMessage<char extends string> = `Modifier flag ${char} must be 'i', 'm' or 's'`;
type parseNamedGroupOrLookbehind<s extends State, unscanned extends string> = unscanned extends Scanner.shift<LookaroundChar, infer next> ? s.pushGroup<s, State.UnnamedCaptureKind.lookaround, next, undefined> : shiftNamedGroup<unscanned> extends (Scanner.shiftResult<infer name, infer following>) ? s.pushGroup<s, name, following, undefined> : s.error<writeUnclosedGroupMessage<")">>;
type shiftNamedGroup<unscanned extends string> = unscanned extends `${infer name}>${infer next}` ? name extends "" ? Scanner.shiftResult<"", ErrorMessage<unnamedCaptureGroupMessage>> : Scanner.shiftResult<name, next> : Scanner.shiftResult<"", ErrorMessage<writeUnclosedGroupMessage<">">>>;
export declare const unnamedCaptureGroupMessage = "Capture group <> requires a name";
export type unnamedCaptureGroupMessage = typeof unnamedCaptureGroupMessage;
export declare const unescapedLiteralQuestionMarkMessage = "literal ? must be escaped at the start of a group";
export type unescapedLiteralQuestionMarkMessage = typeof unescapedLiteralQuestionMarkMessage;
export {};
