"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.audioTranscriptionsStream = audioTranscriptionsStream;
const z = __importStar(require("zod"));
const encodings_js_1 = require("../lib/encodings.js");
const event_streams_js_1 = require("../lib/event-streams.js");
const files_js_1 = require("../lib/files.js");
const M = __importStar(require("../lib/matchers.js"));
const primitives_js_1 = require("../lib/primitives.js");
const schemas_js_1 = require("../lib/schemas.js");
const security_js_1 = require("../lib/security.js");
const url_js_1 = require("../lib/url.js");
const components = __importStar(require("../models/components/index.js"));
const async_js_1 = require("../types/async.js");
const blobs_js_1 = require("../types/blobs.js");
const streams_js_1 = require("../types/streams.js");
/**
 * Create streaming transcription (SSE)
 */
function audioTranscriptionsStream(client, request, options) {
    return new async_js_1.APIPromise($do(client, request, options));
}
async function $do(client, request, options) {
    const parsed = (0, schemas_js_1.safeParse)(request, (value) => components.AudioTranscriptionRequestStream$outboundSchema.parse(value), "Input validation failed");
    if (!parsed.ok) {
        return [parsed, { status: "invalid" }];
    }
    const payload = parsed.value;
    const body = new FormData();
    (0, encodings_js_1.appendForm)(body, "model", payload.model);
    if (payload.file !== undefined) {
        if ((0, blobs_js_1.isBlobLike)(payload.file)) {
            (0, encodings_js_1.appendForm)(body, "file", payload.file);
        }
        else if ((0, streams_js_1.isReadableStream)(payload.file.content)) {
            const buffer = await (0, files_js_1.readableStreamToArrayBuffer)(payload.file.content);
            const contentType = (0, files_js_1.getContentTypeFromFileName)(payload.file.fileName)
                || "application/octet-stream";
            const blob = new Blob([buffer], { type: contentType });
            (0, encodings_js_1.appendForm)(body, "file", blob, payload.file.fileName);
        }
        else {
            const contentType = (0, files_js_1.getContentTypeFromFileName)(payload.file.fileName)
                || "application/octet-stream";
            (0, encodings_js_1.appendForm)(body, "file", new Blob([payload.file.content], { type: contentType }), payload.file.fileName);
        }
    }
    if (payload.file_id !== undefined) {
        (0, encodings_js_1.appendForm)(body, "file_id", payload.file_id);
    }
    if (payload.file_url !== undefined) {
        (0, encodings_js_1.appendForm)(body, "file_url", payload.file_url);
    }
    if (payload.language !== undefined) {
        (0, encodings_js_1.appendForm)(body, "language", payload.language);
    }
    if (payload.stream !== undefined) {
        (0, encodings_js_1.appendForm)(body, "stream", payload.stream);
    }
    if (payload.temperature !== undefined) {
        (0, encodings_js_1.appendForm)(body, "temperature", payload.temperature);
    }
    if (payload.timestamp_granularities !== undefined) {
        (0, encodings_js_1.appendForm)(body, "timestamp_granularities", payload.timestamp_granularities);
    }
    const path = (0, url_js_1.pathToFunc)("/v1/audio/transcriptions#stream")();
    const headers = new Headers((0, primitives_js_1.compactMap)({
        Accept: "text/event-stream",
    }));
    const secConfig = await (0, security_js_1.extractSecurity)(client._options.apiKey);
    const securityInput = secConfig == null ? {} : { apiKey: secConfig };
    const requestSecurity = (0, security_js_1.resolveGlobalSecurity)(securityInput);
    const context = {
        options: client._options,
        baseURL: options?.serverURL ?? client._baseURL ?? "",
        operationID: "audio_api_v1_transcriptions_post_stream",
        oAuth2Scopes: [],
        resolvedSecurity: requestSecurity,
        securitySource: client._options.apiKey,
        retryConfig: options?.retries
            || client._options.retryConfig
            || { strategy: "none" },
        retryCodes: options?.retryCodes || ["429", "500", "502", "503", "504"],
    };
    const requestRes = client._createRequest(context, {
        security: requestSecurity,
        method: "POST",
        baseURL: options?.serverURL,
        path: path,
        headers: headers,
        body: body,
        userAgent: client._options.userAgent,
        timeoutMs: options?.timeoutMs || client._options.timeoutMs || -1,
    }, options);
    if (!requestRes.ok) {
        return [requestRes, { status: "invalid" }];
    }
    const req = requestRes.value;
    const doResult = await client._do(req, {
        context,
        errorCodes: ["4XX", "5XX"],
        retryConfig: context.retryConfig,
        retryCodes: context.retryCodes,
    });
    if (!doResult.ok) {
        return [doResult, { status: "request-error", request: req }];
    }
    const response = doResult.value;
    const [result] = await M.match(M.sse(200, z.instanceof((ReadableStream)).transform(stream => {
        return new event_streams_js_1.EventStream(stream, rawEvent => {
            return {
                value: components.TranscriptionStreamEvents$inboundSchema.parse(rawEvent),
            };
        });
    })), M.fail("4XX"), M.fail("5XX"))(response, req);
    if (!result.ok) {
        return [result, { status: "complete", request: req, response }];
    }
    return [result, { status: "complete", request: req, response }];
}
//# sourceMappingURL=audioTranscriptionsStream.js.map