"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentOut$ = exports.DocumentOut$outboundSchema = exports.DocumentOut$inboundSchema = void 0;
exports.documentOutToJSON = documentOutToJSON;
exports.documentOutFromJSON = documentOutFromJSON;
const z = __importStar(require("zod"));
const primitives_js_1 = require("../../lib/primitives.js");
const schemas_js_1 = require("../../lib/schemas.js");
/** @internal */
exports.DocumentOut$inboundSchema = z.object({
    id: z.string(),
    library_id: z.string(),
    hash: z.string(),
    mime_type: z.string(),
    extension: z.string(),
    size: z.number().int(),
    name: z.string(),
    summary: z.nullable(z.string()).optional(),
    created_at: z.string().datetime({ offset: true }).transform(v => new Date(v)),
    last_processed_at: z.nullable(z.string().datetime({ offset: true }).transform(v => new Date(v))).optional(),
    number_of_pages: z.nullable(z.number().int()).optional(),
    processing_status: z.string(),
    uploaded_by_id: z.string(),
    uploaded_by_type: z.string(),
    tokens_processing_main_content: z.nullable(z.number().int()).optional(),
    tokens_processing_summary: z.nullable(z.number().int()).optional(),
    tokens_processing_total: z.number().int(),
}).transform((v) => {
    return (0, primitives_js_1.remap)(v, {
        "library_id": "libraryId",
        "mime_type": "mimeType",
        "created_at": "createdAt",
        "last_processed_at": "lastProcessedAt",
        "number_of_pages": "numberOfPages",
        "processing_status": "processingStatus",
        "uploaded_by_id": "uploadedById",
        "uploaded_by_type": "uploadedByType",
        "tokens_processing_main_content": "tokensProcessingMainContent",
        "tokens_processing_summary": "tokensProcessingSummary",
        "tokens_processing_total": "tokensProcessingTotal",
    });
});
/** @internal */
exports.DocumentOut$outboundSchema = z.object({
    id: z.string(),
    libraryId: z.string(),
    hash: z.string(),
    mimeType: z.string(),
    extension: z.string(),
    size: z.number().int(),
    name: z.string(),
    summary: z.nullable(z.string()).optional(),
    createdAt: z.date().transform(v => v.toISOString()),
    lastProcessedAt: z.nullable(z.date().transform(v => v.toISOString()))
        .optional(),
    numberOfPages: z.nullable(z.number().int()).optional(),
    processingStatus: z.string(),
    uploadedById: z.string(),
    uploadedByType: z.string(),
    tokensProcessingMainContent: z.nullable(z.number().int()).optional(),
    tokensProcessingSummary: z.nullable(z.number().int()).optional(),
    tokensProcessingTotal: z.number().int(),
}).transform((v) => {
    return (0, primitives_js_1.remap)(v, {
        libraryId: "library_id",
        mimeType: "mime_type",
        createdAt: "created_at",
        lastProcessedAt: "last_processed_at",
        numberOfPages: "number_of_pages",
        processingStatus: "processing_status",
        uploadedById: "uploaded_by_id",
        uploadedByType: "uploaded_by_type",
        tokensProcessingMainContent: "tokens_processing_main_content",
        tokensProcessingSummary: "tokens_processing_summary",
        tokensProcessingTotal: "tokens_processing_total",
    });
});
/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
var DocumentOut$;
(function (DocumentOut$) {
    /** @deprecated use `DocumentOut$inboundSchema` instead. */
    DocumentOut$.inboundSchema = exports.DocumentOut$inboundSchema;
    /** @deprecated use `DocumentOut$outboundSchema` instead. */
    DocumentOut$.outboundSchema = exports.DocumentOut$outboundSchema;
})(DocumentOut$ || (exports.DocumentOut$ = DocumentOut$ = {}));
function documentOutToJSON(documentOut) {
    return JSON.stringify(exports.DocumentOut$outboundSchema.parse(documentOut));
}
function documentOutFromJSON(jsonString) {
    return (0, schemas_js_1.safeParse)(jsonString, (x) => exports.DocumentOut$inboundSchema.parse(JSON.parse(x)), `Failed to parse 'DocumentOut' from JSON`);
}
//# sourceMappingURL=documentout.js.map