/** The base class for all HTTP error responses */
export declare class MistralError extends Error {
    /** HTTP status code */
    readonly statusCode: number;
    /** HTTP body */
    readonly body: string;
    /** HTTP headers */
    readonly headers: Headers;
    /** HTTP content type */
    readonly contentType: string;
    /** Raw response */
    readonly rawResponse: Response;
    constructor(message: string, httpMeta: {
        response: Response;
        request: Request;
        body: string;
    });
}
//# sourceMappingURL=mistralerror.d.ts.map