"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Conversations = void 0;
const betaConversationsAppend_js_1 = require("../funcs/betaConversationsAppend.js");
const betaConversationsAppendStream_js_1 = require("../funcs/betaConversationsAppendStream.js");
const betaConversationsGet_js_1 = require("../funcs/betaConversationsGet.js");
const betaConversationsGetHistory_js_1 = require("../funcs/betaConversationsGetHistory.js");
const betaConversationsGetMessages_js_1 = require("../funcs/betaConversationsGetMessages.js");
const betaConversationsList_js_1 = require("../funcs/betaConversationsList.js");
const betaConversationsRestart_js_1 = require("../funcs/betaConversationsRestart.js");
const betaConversationsRestartStream_js_1 = require("../funcs/betaConversationsRestartStream.js");
const betaConversationsStart_js_1 = require("../funcs/betaConversationsStart.js");
const betaConversationsStartStream_js_1 = require("../funcs/betaConversationsStartStream.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
class Conversations extends sdks_js_1.ClientSDK {
    /**
     * Create a conversation and append entries to it.
     *
     * @remarks
     * Create a new conversation, using a base model or an agent and append entries. Completion and tool executions are run and the response is appended to the conversation.Use the returned conversation_id to continue the conversation.
     */
    async start(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsStart_js_1.betaConversationsStart)(this, request, options));
    }
    /**
     * List all created conversations.
     *
     * @remarks
     * Retrieve a list of conversation entities sorted by creation time.
     */
    async list(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsList_js_1.betaConversationsList)(this, request, options));
    }
    /**
     * Retrieve a conversation information.
     *
     * @remarks
     * Given a conversation_id retrieve a conversation entity with its attributes.
     */
    async get(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsGet_js_1.betaConversationsGet)(this, request, options));
    }
    /**
     * Append new entries to an existing conversation.
     *
     * @remarks
     * Run completion on the history of the conversation and the user entries. Return the new created entries.
     */
    async append(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsAppend_js_1.betaConversationsAppend)(this, request, options));
    }
    /**
     * Retrieve all entries in a conversation.
     *
     * @remarks
     * Given a conversation_id retrieve all the entries belonging to that conversation. The entries are sorted in the order they were appended, those can be messages, connectors or function_call.
     */
    async getHistory(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsGetHistory_js_1.betaConversationsGetHistory)(this, request, options));
    }
    /**
     * Retrieve all messages in a conversation.
     *
     * @remarks
     * Given a conversation_id retrieve all the messages belonging to that conversation. This is similar to retrieving all entries except we filter the messages only.
     */
    async getMessages(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsGetMessages_js_1.betaConversationsGetMessages)(this, request, options));
    }
    /**
     * Restart a conversation starting from a given entry.
     *
     * @remarks
     * Given a conversation_id and an id, recreate a conversation from this point and run completion. A new conversation is returned with the new entries returned.
     */
    async restart(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsRestart_js_1.betaConversationsRestart)(this, request, options));
    }
    /**
     * Create a conversation and append entries to it.
     *
     * @remarks
     * Create a new conversation, using a base model or an agent and append entries. Completion and tool executions are run and the response is appended to the conversation.Use the returned conversation_id to continue the conversation.
     */
    async startStream(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsStartStream_js_1.betaConversationsStartStream)(this, request, options));
    }
    /**
     * Append new entries to an existing conversation.
     *
     * @remarks
     * Run completion on the history of the conversation and the user entries. Return the new created entries.
     */
    async appendStream(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsAppendStream_js_1.betaConversationsAppendStream)(this, request, options));
    }
    /**
     * Restart a conversation starting from a given entry.
     *
     * @remarks
     * Given a conversation_id and an id, recreate a conversation from this point and run completion. A new conversation is returned with the new entries returned.
     */
    async restartStream(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, betaConversationsRestartStream_js_1.betaConversationsRestartStream)(this, request, options));
    }
}
exports.Conversations = Conversations;
//# sourceMappingURL=conversations.js.map