/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CodeInterpreterTool,
  CodeInterpreterTool$inboundSchema,
  CodeInterpreterTool$Outbound,
  CodeInterpreterTool$outboundSchema,
} from "./codeinterpretertool.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  DocumentLibraryTool,
  DocumentLibraryTool$inboundSchema,
  DocumentLibraryTool$Outbound,
  DocumentLibraryTool$outboundSchema,
} from "./documentlibrarytool.js";
import {
  FunctionTool,
  FunctionTool$inboundSchema,
  FunctionTool$Outbound,
  FunctionTool$outboundSchema,
} from "./functiontool.js";
import {
  ImageGenerationTool,
  ImageGenerationTool$inboundSchema,
  ImageGenerationTool$Outbound,
  ImageGenerationTool$outboundSchema,
} from "./imagegenerationtool.js";
import {
  WebSearchPremiumTool,
  WebSearchPremiumTool$inboundSchema,
  WebSearchPremiumTool$Outbound,
  WebSearchPremiumTool$outboundSchema,
} from "./websearchpremiumtool.js";
import {
  WebSearchTool,
  WebSearchTool$inboundSchema,
  WebSearchTool$Outbound,
  WebSearchTool$outboundSchema,
} from "./websearchtool.js";

export type AgentTools =
  | (DocumentLibraryTool & { type: "document_library" })
  | (FunctionTool & { type: "function" })
  | (CodeInterpreterTool & { type: "code_interpreter" })
  | (ImageGenerationTool & { type: "image_generation" })
  | (WebSearchTool & { type: "web_search" })
  | (WebSearchPremiumTool & { type: "web_search_premium" });

export const AgentObject = {
  Agent: "agent",
} as const;
export type AgentObject = ClosedEnum<typeof AgentObject>;

export type Agent = {
  /**
   * Instruction prompt the model will follow during the conversation.
   */
  instructions?: string | null | undefined;
  /**
   * List of tools which are available to the model during the conversation.
   */
  tools?:
    | Array<
      | (DocumentLibraryTool & { type: "document_library" })
      | (FunctionTool & { type: "function" })
      | (CodeInterpreterTool & { type: "code_interpreter" })
      | (ImageGenerationTool & { type: "image_generation" })
      | (WebSearchTool & { type: "web_search" })
      | (WebSearchPremiumTool & { type: "web_search_premium" })
    >
    | undefined;
  /**
   * White-listed arguments from the completion API
   */
  completionArgs?: CompletionArgs | undefined;
  model: string;
  name: string;
  description?: string | null | undefined;
  handoffs?: Array<string> | null | undefined;
  object?: AgentObject | undefined;
  id: string;
  version: number;
  createdAt: Date;
  updatedAt: Date;
};

/** @internal */
export const AgentTools$inboundSchema: z.ZodType<
  AgentTools,
  z.ZodTypeDef,
  unknown
> = z.union([
  DocumentLibraryTool$inboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$inboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$inboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$inboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$inboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$inboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/** @internal */
export type AgentTools$Outbound =
  | (DocumentLibraryTool$Outbound & { type: "document_library" })
  | (FunctionTool$Outbound & { type: "function" })
  | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
  | (ImageGenerationTool$Outbound & { type: "image_generation" })
  | (WebSearchTool$Outbound & { type: "web_search" })
  | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" });

/** @internal */
export const AgentTools$outboundSchema: z.ZodType<
  AgentTools$Outbound,
  z.ZodTypeDef,
  AgentTools
> = z.union([
  DocumentLibraryTool$outboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$outboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$outboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$outboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$outboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$outboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentTools$ {
  /** @deprecated use `AgentTools$inboundSchema` instead. */
  export const inboundSchema = AgentTools$inboundSchema;
  /** @deprecated use `AgentTools$outboundSchema` instead. */
  export const outboundSchema = AgentTools$outboundSchema;
  /** @deprecated use `AgentTools$Outbound` instead. */
  export type Outbound = AgentTools$Outbound;
}

export function agentToolsToJSON(agentTools: AgentTools): string {
  return JSON.stringify(AgentTools$outboundSchema.parse(agentTools));
}

export function agentToolsFromJSON(
  jsonString: string,
): SafeParseResult<AgentTools, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentTools$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentTools' from JSON`,
  );
}

/** @internal */
export const AgentObject$inboundSchema: z.ZodNativeEnum<typeof AgentObject> = z
  .nativeEnum(AgentObject);

/** @internal */
export const AgentObject$outboundSchema: z.ZodNativeEnum<typeof AgentObject> =
  AgentObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentObject$ {
  /** @deprecated use `AgentObject$inboundSchema` instead. */
  export const inboundSchema = AgentObject$inboundSchema;
  /** @deprecated use `AgentObject$outboundSchema` instead. */
  export const outboundSchema = AgentObject$outboundSchema;
}

/** @internal */
export const Agent$inboundSchema: z.ZodType<Agent, z.ZodTypeDef, unknown> = z
  .object({
    instructions: z.nullable(z.string()).optional(),
    tools: z.array(
      z.union([
        DocumentLibraryTool$inboundSchema.and(
          z.object({ type: z.literal("document_library") }).transform((v) => ({
            type: v.type,
          })),
        ),
        FunctionTool$inboundSchema.and(
          z.object({ type: z.literal("function") }).transform((v) => ({
            type: v.type,
          })),
        ),
        CodeInterpreterTool$inboundSchema.and(
          z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
            type: v.type,
          })),
        ),
        ImageGenerationTool$inboundSchema.and(
          z.object({ type: z.literal("image_generation") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchTool$inboundSchema.and(
          z.object({ type: z.literal("web_search") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchPremiumTool$inboundSchema.and(
          z.object({ type: z.literal("web_search_premium") }).transform((
            v,
          ) => ({ type: v.type })),
        ),
      ]),
    ).optional(),
    completion_args: CompletionArgs$inboundSchema.optional(),
    model: z.string(),
    name: z.string(),
    description: z.nullable(z.string()).optional(),
    handoffs: z.nullable(z.array(z.string())).optional(),
    object: AgentObject$inboundSchema.default("agent"),
    id: z.string(),
    version: z.number().int(),
    created_at: z.string().datetime({ offset: true }).transform(v =>
      new Date(v)
    ),
    updated_at: z.string().datetime({ offset: true }).transform(v =>
      new Date(v)
    ),
  }).transform((v) => {
    return remap$(v, {
      "completion_args": "completionArgs",
      "created_at": "createdAt",
      "updated_at": "updatedAt",
    });
  });

/** @internal */
export type Agent$Outbound = {
  instructions?: string | null | undefined;
  tools?:
    | Array<
      | (DocumentLibraryTool$Outbound & { type: "document_library" })
      | (FunctionTool$Outbound & { type: "function" })
      | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
      | (ImageGenerationTool$Outbound & { type: "image_generation" })
      | (WebSearchTool$Outbound & { type: "web_search" })
      | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" })
    >
    | undefined;
  completion_args?: CompletionArgs$Outbound | undefined;
  model: string;
  name: string;
  description?: string | null | undefined;
  handoffs?: Array<string> | null | undefined;
  object: string;
  id: string;
  version: number;
  created_at: string;
  updated_at: string;
};

/** @internal */
export const Agent$outboundSchema: z.ZodType<
  Agent$Outbound,
  z.ZodTypeDef,
  Agent
> = z.object({
  instructions: z.nullable(z.string()).optional(),
  tools: z.array(
    z.union([
      DocumentLibraryTool$outboundSchema.and(
        z.object({ type: z.literal("document_library") }).transform((v) => ({
          type: v.type,
        })),
      ),
      FunctionTool$outboundSchema.and(
        z.object({ type: z.literal("function") }).transform((v) => ({
          type: v.type,
        })),
      ),
      CodeInterpreterTool$outboundSchema.and(
        z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
          type: v.type,
        })),
      ),
      ImageGenerationTool$outboundSchema.and(
        z.object({ type: z.literal("image_generation") }).transform((v) => ({
          type: v.type,
        })),
      ),
      WebSearchTool$outboundSchema.and(
        z.object({ type: z.literal("web_search") }).transform((v) => ({
          type: v.type,
        })),
      ),
      WebSearchPremiumTool$outboundSchema.and(
        z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
          type: v.type,
        })),
      ),
    ]),
  ).optional(),
  completionArgs: CompletionArgs$outboundSchema.optional(),
  model: z.string(),
  name: z.string(),
  description: z.nullable(z.string()).optional(),
  handoffs: z.nullable(z.array(z.string())).optional(),
  object: AgentObject$outboundSchema.default("agent"),
  id: z.string(),
  version: z.number().int(),
  createdAt: z.date().transform(v => v.toISOString()),
  updatedAt: z.date().transform(v => v.toISOString()),
}).transform((v) => {
  return remap$(v, {
    completionArgs: "completion_args",
    createdAt: "created_at",
    updatedAt: "updated_at",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Agent$ {
  /** @deprecated use `Agent$inboundSchema` instead. */
  export const inboundSchema = Agent$inboundSchema;
  /** @deprecated use `Agent$outboundSchema` instead. */
  export const outboundSchema = Agent$outboundSchema;
  /** @deprecated use `Agent$Outbound` instead. */
  export type Outbound = Agent$Outbound;
}

export function agentToJSON(agent: Agent): string {
  return JSON.stringify(Agent$outboundSchema.parse(agent));
}

export function agentFromJSON(
  jsonString: string,
): SafeParseResult<Agent, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Agent$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Agent' from JSON`,
  );
}
