/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export const AgentHandoffStartedEventType = {
  AgentHandoffStarted: "agent.handoff.started",
} as const;
export type AgentHandoffStartedEventType = ClosedEnum<
  typeof AgentHandoffStartedEventType
>;

export type AgentHandoffStartedEvent = {
  type?: AgentHandoffStartedEventType | undefined;
  createdAt?: Date | undefined;
  outputIndex?: number | undefined;
  id: string;
  previousAgentId: string;
  previousAgentName: string;
};

/** @internal */
export const AgentHandoffStartedEventType$inboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffStartedEventType
> = z.nativeEnum(AgentHandoffStartedEventType);

/** @internal */
export const AgentHandoffStartedEventType$outboundSchema: z.ZodNativeEnum<
  typeof AgentHandoffStartedEventType
> = AgentHandoffStartedEventType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffStartedEventType$ {
  /** @deprecated use `AgentHandoffStartedEventType$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffStartedEventType$inboundSchema;
  /** @deprecated use `AgentHandoffStartedEventType$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffStartedEventType$outboundSchema;
}

/** @internal */
export const AgentHandoffStartedEvent$inboundSchema: z.ZodType<
  AgentHandoffStartedEvent,
  z.ZodTypeDef,
  unknown
> = z.object({
  type: AgentHandoffStartedEventType$inboundSchema.default(
    "agent.handoff.started",
  ),
  created_at: z.string().datetime({ offset: true }).transform(v => new Date(v))
    .optional(),
  output_index: z.number().int().default(0),
  id: z.string(),
  previous_agent_id: z.string(),
  previous_agent_name: z.string(),
}).transform((v) => {
  return remap$(v, {
    "created_at": "createdAt",
    "output_index": "outputIndex",
    "previous_agent_id": "previousAgentId",
    "previous_agent_name": "previousAgentName",
  });
});

/** @internal */
export type AgentHandoffStartedEvent$Outbound = {
  type: string;
  created_at?: string | undefined;
  output_index: number;
  id: string;
  previous_agent_id: string;
  previous_agent_name: string;
};

/** @internal */
export const AgentHandoffStartedEvent$outboundSchema: z.ZodType<
  AgentHandoffStartedEvent$Outbound,
  z.ZodTypeDef,
  AgentHandoffStartedEvent
> = z.object({
  type: AgentHandoffStartedEventType$outboundSchema.default(
    "agent.handoff.started",
  ),
  createdAt: z.date().transform(v => v.toISOString()).optional(),
  outputIndex: z.number().int().default(0),
  id: z.string(),
  previousAgentId: z.string(),
  previousAgentName: z.string(),
}).transform((v) => {
  return remap$(v, {
    createdAt: "created_at",
    outputIndex: "output_index",
    previousAgentId: "previous_agent_id",
    previousAgentName: "previous_agent_name",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentHandoffStartedEvent$ {
  /** @deprecated use `AgentHandoffStartedEvent$inboundSchema` instead. */
  export const inboundSchema = AgentHandoffStartedEvent$inboundSchema;
  /** @deprecated use `AgentHandoffStartedEvent$outboundSchema` instead. */
  export const outboundSchema = AgentHandoffStartedEvent$outboundSchema;
  /** @deprecated use `AgentHandoffStartedEvent$Outbound` instead. */
  export type Outbound = AgentHandoffStartedEvent$Outbound;
}

export function agentHandoffStartedEventToJSON(
  agentHandoffStartedEvent: AgentHandoffStartedEvent,
): string {
  return JSON.stringify(
    AgentHandoffStartedEvent$outboundSchema.parse(agentHandoffStartedEvent),
  );
}

export function agentHandoffStartedEventFromJSON(
  jsonString: string,
): SafeParseResult<AgentHandoffStartedEvent, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentHandoffStartedEvent$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentHandoffStartedEvent' from JSON`,
  );
}
