/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  AssistantMessage,
  AssistantMessage$inboundSchema,
  AssistantMessage$Outbound,
  AssistantMessage$outboundSchema,
} from "./assistantmessage.js";
import {
  MistralPromptMode,
  MistralPromptMode$inboundSchema,
  MistralPromptMode$outboundSchema,
} from "./mistralpromptmode.js";
import {
  Prediction,
  Prediction$inboundSchema,
  Prediction$Outbound,
  Prediction$outboundSchema,
} from "./prediction.js";
import {
  ResponseFormat,
  ResponseFormat$inboundSchema,
  ResponseFormat$Outbound,
  ResponseFormat$outboundSchema,
} from "./responseformat.js";
import {
  SystemMessage,
  SystemMessage$inboundSchema,
  SystemMessage$Outbound,
  SystemMessage$outboundSchema,
} from "./systemmessage.js";
import {
  Tool,
  Tool$inboundSchema,
  Tool$Outbound,
  Tool$outboundSchema,
} from "./tool.js";
import {
  ToolChoice,
  ToolChoice$inboundSchema,
  ToolChoice$Outbound,
  ToolChoice$outboundSchema,
} from "./toolchoice.js";
import {
  ToolChoiceEnum,
  ToolChoiceEnum$inboundSchema,
  ToolChoiceEnum$outboundSchema,
} from "./toolchoiceenum.js";
import {
  ToolMessage,
  ToolMessage$inboundSchema,
  ToolMessage$Outbound,
  ToolMessage$outboundSchema,
} from "./toolmessage.js";
import {
  UserMessage,
  UserMessage$inboundSchema,
  UserMessage$Outbound,
  UserMessage$outboundSchema,
} from "./usermessage.js";

/**
 * Stop generation if this token is detected. Or if one of these tokens is detected when providing an array
 */
export type AgentsCompletionStreamRequestStop = string | Array<string>;

export type AgentsCompletionStreamRequestMessages =
  | (SystemMessage & { role: "system" })
  | (ToolMessage & { role: "tool" })
  | (UserMessage & { role: "user" })
  | (AssistantMessage & { role: "assistant" });

export type AgentsCompletionStreamRequestToolChoice =
  | ToolChoice
  | ToolChoiceEnum;

export type AgentsCompletionStreamRequest = {
  /**
   * The maximum number of tokens to generate in the completion. The token count of your prompt plus `max_tokens` cannot exceed the model's context length.
   */
  maxTokens?: number | null | undefined;
  stream?: boolean | undefined;
  /**
   * Stop generation if this token is detected. Or if one of these tokens is detected when providing an array
   */
  stop?: string | Array<string> | undefined;
  /**
   * The seed to use for random sampling. If set, different calls will generate deterministic results.
   */
  randomSeed?: number | null | undefined;
  /**
   * The prompt(s) to generate completions for, encoded as a list of dict with role and content.
   */
  messages: Array<
    | (SystemMessage & { role: "system" })
    | (ToolMessage & { role: "tool" })
    | (UserMessage & { role: "user" })
    | (AssistantMessage & { role: "assistant" })
  >;
  responseFormat?: ResponseFormat | undefined;
  tools?: Array<Tool> | null | undefined;
  toolChoice?: ToolChoice | ToolChoiceEnum | undefined;
  /**
   * presence_penalty determines how much the model penalizes the repetition of words or phrases. A higher presence penalty encourages the model to use a wider variety of words and phrases, making the output more diverse and creative.
   */
  presencePenalty?: number | undefined;
  /**
   * frequency_penalty penalizes the repetition of words based on their frequency in the generated text. A higher frequency penalty discourages the model from repeating words that have already appeared frequently in the output, promoting diversity and reducing repetition.
   */
  frequencyPenalty?: number | undefined;
  /**
   * Number of completions to return for each request, input tokens are only billed once.
   */
  n?: number | null | undefined;
  prediction?: Prediction | undefined;
  parallelToolCalls?: boolean | undefined;
  /**
   * Allows toggling between the reasoning mode and no system prompt. When set to `reasoning` the system prompt for reasoning models will be used.
   */
  promptMode?: MistralPromptMode | null | undefined;
  /**
   * The ID of the agent to use for this completion.
   */
  agentId: string;
};

/** @internal */
export const AgentsCompletionStreamRequestStop$inboundSchema: z.ZodType<
  AgentsCompletionStreamRequestStop,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.array(z.string())]);

/** @internal */
export type AgentsCompletionStreamRequestStop$Outbound = string | Array<string>;

/** @internal */
export const AgentsCompletionStreamRequestStop$outboundSchema: z.ZodType<
  AgentsCompletionStreamRequestStop$Outbound,
  z.ZodTypeDef,
  AgentsCompletionStreamRequestStop
> = z.union([z.string(), z.array(z.string())]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsCompletionStreamRequestStop$ {
  /** @deprecated use `AgentsCompletionStreamRequestStop$inboundSchema` instead. */
  export const inboundSchema = AgentsCompletionStreamRequestStop$inboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequestStop$outboundSchema` instead. */
  export const outboundSchema =
    AgentsCompletionStreamRequestStop$outboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequestStop$Outbound` instead. */
  export type Outbound = AgentsCompletionStreamRequestStop$Outbound;
}

export function agentsCompletionStreamRequestStopToJSON(
  agentsCompletionStreamRequestStop: AgentsCompletionStreamRequestStop,
): string {
  return JSON.stringify(
    AgentsCompletionStreamRequestStop$outboundSchema.parse(
      agentsCompletionStreamRequestStop,
    ),
  );
}

export function agentsCompletionStreamRequestStopFromJSON(
  jsonString: string,
): SafeParseResult<AgentsCompletionStreamRequestStop, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentsCompletionStreamRequestStop$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsCompletionStreamRequestStop' from JSON`,
  );
}

/** @internal */
export const AgentsCompletionStreamRequestMessages$inboundSchema: z.ZodType<
  AgentsCompletionStreamRequestMessages,
  z.ZodTypeDef,
  unknown
> = z.union([
  SystemMessage$inboundSchema.and(
    z.object({ role: z.literal("system") }).transform((v) => ({
      role: v.role,
    })),
  ),
  ToolMessage$inboundSchema.and(
    z.object({ role: z.literal("tool") }).transform((v) => ({ role: v.role })),
  ),
  UserMessage$inboundSchema.and(
    z.object({ role: z.literal("user") }).transform((v) => ({ role: v.role })),
  ),
  AssistantMessage$inboundSchema.and(
    z.object({ role: z.literal("assistant") }).transform((v) => ({
      role: v.role,
    })),
  ),
]);

/** @internal */
export type AgentsCompletionStreamRequestMessages$Outbound =
  | (SystemMessage$Outbound & { role: "system" })
  | (ToolMessage$Outbound & { role: "tool" })
  | (UserMessage$Outbound & { role: "user" })
  | (AssistantMessage$Outbound & { role: "assistant" });

/** @internal */
export const AgentsCompletionStreamRequestMessages$outboundSchema: z.ZodType<
  AgentsCompletionStreamRequestMessages$Outbound,
  z.ZodTypeDef,
  AgentsCompletionStreamRequestMessages
> = z.union([
  SystemMessage$outboundSchema.and(
    z.object({ role: z.literal("system") }).transform((v) => ({
      role: v.role,
    })),
  ),
  ToolMessage$outboundSchema.and(
    z.object({ role: z.literal("tool") }).transform((v) => ({ role: v.role })),
  ),
  UserMessage$outboundSchema.and(
    z.object({ role: z.literal("user") }).transform((v) => ({ role: v.role })),
  ),
  AssistantMessage$outboundSchema.and(
    z.object({ role: z.literal("assistant") }).transform((v) => ({
      role: v.role,
    })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsCompletionStreamRequestMessages$ {
  /** @deprecated use `AgentsCompletionStreamRequestMessages$inboundSchema` instead. */
  export const inboundSchema =
    AgentsCompletionStreamRequestMessages$inboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequestMessages$outboundSchema` instead. */
  export const outboundSchema =
    AgentsCompletionStreamRequestMessages$outboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequestMessages$Outbound` instead. */
  export type Outbound = AgentsCompletionStreamRequestMessages$Outbound;
}

export function agentsCompletionStreamRequestMessagesToJSON(
  agentsCompletionStreamRequestMessages: AgentsCompletionStreamRequestMessages,
): string {
  return JSON.stringify(
    AgentsCompletionStreamRequestMessages$outboundSchema.parse(
      agentsCompletionStreamRequestMessages,
    ),
  );
}

export function agentsCompletionStreamRequestMessagesFromJSON(
  jsonString: string,
): SafeParseResult<AgentsCompletionStreamRequestMessages, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsCompletionStreamRequestMessages$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsCompletionStreamRequestMessages' from JSON`,
  );
}

/** @internal */
export const AgentsCompletionStreamRequestToolChoice$inboundSchema: z.ZodType<
  AgentsCompletionStreamRequestToolChoice,
  z.ZodTypeDef,
  unknown
> = z.union([ToolChoice$inboundSchema, ToolChoiceEnum$inboundSchema]);

/** @internal */
export type AgentsCompletionStreamRequestToolChoice$Outbound =
  | ToolChoice$Outbound
  | string;

/** @internal */
export const AgentsCompletionStreamRequestToolChoice$outboundSchema: z.ZodType<
  AgentsCompletionStreamRequestToolChoice$Outbound,
  z.ZodTypeDef,
  AgentsCompletionStreamRequestToolChoice
> = z.union([ToolChoice$outboundSchema, ToolChoiceEnum$outboundSchema]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsCompletionStreamRequestToolChoice$ {
  /** @deprecated use `AgentsCompletionStreamRequestToolChoice$inboundSchema` instead. */
  export const inboundSchema =
    AgentsCompletionStreamRequestToolChoice$inboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequestToolChoice$outboundSchema` instead. */
  export const outboundSchema =
    AgentsCompletionStreamRequestToolChoice$outboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequestToolChoice$Outbound` instead. */
  export type Outbound = AgentsCompletionStreamRequestToolChoice$Outbound;
}

export function agentsCompletionStreamRequestToolChoiceToJSON(
  agentsCompletionStreamRequestToolChoice:
    AgentsCompletionStreamRequestToolChoice,
): string {
  return JSON.stringify(
    AgentsCompletionStreamRequestToolChoice$outboundSchema.parse(
      agentsCompletionStreamRequestToolChoice,
    ),
  );
}

export function agentsCompletionStreamRequestToolChoiceFromJSON(
  jsonString: string,
): SafeParseResult<
  AgentsCompletionStreamRequestToolChoice,
  SDKValidationError
> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsCompletionStreamRequestToolChoice$inboundSchema.parse(
        JSON.parse(x),
      ),
    `Failed to parse 'AgentsCompletionStreamRequestToolChoice' from JSON`,
  );
}

/** @internal */
export const AgentsCompletionStreamRequest$inboundSchema: z.ZodType<
  AgentsCompletionStreamRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  max_tokens: z.nullable(z.number().int()).optional(),
  stream: z.boolean().default(true),
  stop: z.union([z.string(), z.array(z.string())]).optional(),
  random_seed: z.nullable(z.number().int()).optional(),
  messages: z.array(
    z.union([
      SystemMessage$inboundSchema.and(
        z.object({ role: z.literal("system") }).transform((v) => ({
          role: v.role,
        })),
      ),
      ToolMessage$inboundSchema.and(
        z.object({ role: z.literal("tool") }).transform((v) => ({
          role: v.role,
        })),
      ),
      UserMessage$inboundSchema.and(
        z.object({ role: z.literal("user") }).transform((v) => ({
          role: v.role,
        })),
      ),
      AssistantMessage$inboundSchema.and(
        z.object({ role: z.literal("assistant") }).transform((v) => ({
          role: v.role,
        })),
      ),
    ]),
  ),
  response_format: ResponseFormat$inboundSchema.optional(),
  tools: z.nullable(z.array(Tool$inboundSchema)).optional(),
  tool_choice: z.union([ToolChoice$inboundSchema, ToolChoiceEnum$inboundSchema])
    .optional(),
  presence_penalty: z.number().optional(),
  frequency_penalty: z.number().optional(),
  n: z.nullable(z.number().int()).optional(),
  prediction: Prediction$inboundSchema.optional(),
  parallel_tool_calls: z.boolean().optional(),
  prompt_mode: z.nullable(MistralPromptMode$inboundSchema).optional(),
  agent_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "max_tokens": "maxTokens",
    "random_seed": "randomSeed",
    "response_format": "responseFormat",
    "tool_choice": "toolChoice",
    "presence_penalty": "presencePenalty",
    "frequency_penalty": "frequencyPenalty",
    "parallel_tool_calls": "parallelToolCalls",
    "prompt_mode": "promptMode",
    "agent_id": "agentId",
  });
});

/** @internal */
export type AgentsCompletionStreamRequest$Outbound = {
  max_tokens?: number | null | undefined;
  stream: boolean;
  stop?: string | Array<string> | undefined;
  random_seed?: number | null | undefined;
  messages: Array<
    | (SystemMessage$Outbound & { role: "system" })
    | (ToolMessage$Outbound & { role: "tool" })
    | (UserMessage$Outbound & { role: "user" })
    | (AssistantMessage$Outbound & { role: "assistant" })
  >;
  response_format?: ResponseFormat$Outbound | undefined;
  tools?: Array<Tool$Outbound> | null | undefined;
  tool_choice?: ToolChoice$Outbound | string | undefined;
  presence_penalty?: number | undefined;
  frequency_penalty?: number | undefined;
  n?: number | null | undefined;
  prediction?: Prediction$Outbound | undefined;
  parallel_tool_calls?: boolean | undefined;
  prompt_mode?: string | null | undefined;
  agent_id: string;
};

/** @internal */
export const AgentsCompletionStreamRequest$outboundSchema: z.ZodType<
  AgentsCompletionStreamRequest$Outbound,
  z.ZodTypeDef,
  AgentsCompletionStreamRequest
> = z.object({
  maxTokens: z.nullable(z.number().int()).optional(),
  stream: z.boolean().default(true),
  stop: z.union([z.string(), z.array(z.string())]).optional(),
  randomSeed: z.nullable(z.number().int()).optional(),
  messages: z.array(
    z.union([
      SystemMessage$outboundSchema.and(
        z.object({ role: z.literal("system") }).transform((v) => ({
          role: v.role,
        })),
      ),
      ToolMessage$outboundSchema.and(
        z.object({ role: z.literal("tool") }).transform((v) => ({
          role: v.role,
        })),
      ),
      UserMessage$outboundSchema.and(
        z.object({ role: z.literal("user") }).transform((v) => ({
          role: v.role,
        })),
      ),
      AssistantMessage$outboundSchema.and(
        z.object({ role: z.literal("assistant") }).transform((v) => ({
          role: v.role,
        })),
      ),
    ]),
  ),
  responseFormat: ResponseFormat$outboundSchema.optional(),
  tools: z.nullable(z.array(Tool$outboundSchema)).optional(),
  toolChoice: z.union([
    ToolChoice$outboundSchema,
    ToolChoiceEnum$outboundSchema,
  ]).optional(),
  presencePenalty: z.number().optional(),
  frequencyPenalty: z.number().optional(),
  n: z.nullable(z.number().int()).optional(),
  prediction: Prediction$outboundSchema.optional(),
  parallelToolCalls: z.boolean().optional(),
  promptMode: z.nullable(MistralPromptMode$outboundSchema).optional(),
  agentId: z.string(),
}).transform((v) => {
  return remap$(v, {
    maxTokens: "max_tokens",
    randomSeed: "random_seed",
    responseFormat: "response_format",
    toolChoice: "tool_choice",
    presencePenalty: "presence_penalty",
    frequencyPenalty: "frequency_penalty",
    parallelToolCalls: "parallel_tool_calls",
    promptMode: "prompt_mode",
    agentId: "agent_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsCompletionStreamRequest$ {
  /** @deprecated use `AgentsCompletionStreamRequest$inboundSchema` instead. */
  export const inboundSchema = AgentsCompletionStreamRequest$inboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequest$outboundSchema` instead. */
  export const outboundSchema = AgentsCompletionStreamRequest$outboundSchema;
  /** @deprecated use `AgentsCompletionStreamRequest$Outbound` instead. */
  export type Outbound = AgentsCompletionStreamRequest$Outbound;
}

export function agentsCompletionStreamRequestToJSON(
  agentsCompletionStreamRequest: AgentsCompletionStreamRequest,
): string {
  return JSON.stringify(
    AgentsCompletionStreamRequest$outboundSchema.parse(
      agentsCompletionStreamRequest,
    ),
  );
}

export function agentsCompletionStreamRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsCompletionStreamRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AgentsCompletionStreamRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsCompletionStreamRequest' from JSON`,
  );
}
