/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export const AudioChunkType = {
  InputAudio: "input_audio",
} as const;
export type AudioChunkType = ClosedEnum<typeof AudioChunkType>;

export type AudioChunk = {
  inputAudio: string;
  type?: AudioChunkType | undefined;
};

/** @internal */
export const AudioChunkType$inboundSchema: z.ZodNativeEnum<
  typeof AudioChunkType
> = z.nativeEnum(AudioChunkType);

/** @internal */
export const AudioChunkType$outboundSchema: z.ZodNativeEnum<
  typeof AudioChunkType
> = AudioChunkType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AudioChunkType$ {
  /** @deprecated use `AudioChunkType$inboundSchema` instead. */
  export const inboundSchema = AudioChunkType$inboundSchema;
  /** @deprecated use `AudioChunkType$outboundSchema` instead. */
  export const outboundSchema = AudioChunkType$outboundSchema;
}

/** @internal */
export const AudioChunk$inboundSchema: z.ZodType<
  AudioChunk,
  z.ZodTypeDef,
  unknown
> = z.object({
  input_audio: z.string(),
  type: AudioChunkType$inboundSchema.default("input_audio"),
}).transform((v) => {
  return remap$(v, {
    "input_audio": "inputAudio",
  });
});

/** @internal */
export type AudioChunk$Outbound = {
  input_audio: string;
  type: string;
};

/** @internal */
export const AudioChunk$outboundSchema: z.ZodType<
  AudioChunk$Outbound,
  z.ZodTypeDef,
  AudioChunk
> = z.object({
  inputAudio: z.string(),
  type: AudioChunkType$outboundSchema.default("input_audio"),
}).transform((v) => {
  return remap$(v, {
    inputAudio: "input_audio",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AudioChunk$ {
  /** @deprecated use `AudioChunk$inboundSchema` instead. */
  export const inboundSchema = AudioChunk$inboundSchema;
  /** @deprecated use `AudioChunk$outboundSchema` instead. */
  export const outboundSchema = AudioChunk$outboundSchema;
  /** @deprecated use `AudioChunk$Outbound` instead. */
  export type Outbound = AudioChunk$Outbound;
}

export function audioChunkToJSON(audioChunk: AudioChunk): string {
  return JSON.stringify(AudioChunk$outboundSchema.parse(audioChunk));
}

export function audioChunkFromJSON(
  jsonString: string,
): SafeParseResult<AudioChunk, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AudioChunk$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AudioChunk' from JSON`,
  );
}
