/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { blobLikeSchema } from "../../types/blobs.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  FileT,
  FileT$inboundSchema,
  FileT$Outbound,
  FileT$outboundSchema,
} from "./file.js";
import {
  TimestampGranularity,
  TimestampGranularity$inboundSchema,
  TimestampGranularity$outboundSchema,
} from "./timestampgranularity.js";

export type AudioTranscriptionRequest = {
  model: string;
  file?: FileT | Blob | undefined;
  /**
   * Url of a file to be transcribed
   */
  fileUrl?: string | null | undefined;
  /**
   * ID of a file uploaded to /v1/files
   */
  fileId?: string | null | undefined;
  /**
   * Language of the audio, e.g. 'en'. Providing the language can boost accuracy.
   */
  language?: string | null | undefined;
  temperature?: number | null | undefined;
  stream?: false | undefined;
  /**
   * Granularities of timestamps to include in the response.
   */
  timestampGranularities?: Array<TimestampGranularity> | undefined;
};

/** @internal */
export const AudioTranscriptionRequest$inboundSchema: z.ZodType<
  AudioTranscriptionRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  model: z.string(),
  file: FileT$inboundSchema.optional(),
  file_url: z.nullable(z.string()).optional(),
  file_id: z.nullable(z.string()).optional(),
  language: z.nullable(z.string()).optional(),
  temperature: z.nullable(z.number()).optional(),
  stream: z.literal(false).default(false),
  timestamp_granularities: z.array(TimestampGranularity$inboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    "file_url": "fileUrl",
    "file_id": "fileId",
    "timestamp_granularities": "timestampGranularities",
  });
});

/** @internal */
export type AudioTranscriptionRequest$Outbound = {
  model: string;
  file?: FileT$Outbound | Blob | undefined;
  file_url?: string | null | undefined;
  file_id?: string | null | undefined;
  language?: string | null | undefined;
  temperature?: number | null | undefined;
  stream: false;
  timestamp_granularities?: Array<string> | undefined;
};

/** @internal */
export const AudioTranscriptionRequest$outboundSchema: z.ZodType<
  AudioTranscriptionRequest$Outbound,
  z.ZodTypeDef,
  AudioTranscriptionRequest
> = z.object({
  model: z.string(),
  file: FileT$outboundSchema.or(blobLikeSchema).optional(),
  fileUrl: z.nullable(z.string()).optional(),
  fileId: z.nullable(z.string()).optional(),
  language: z.nullable(z.string()).optional(),
  temperature: z.nullable(z.number()).optional(),
  stream: z.literal(false).default(false as const),
  timestampGranularities: z.array(TimestampGranularity$outboundSchema)
    .optional(),
}).transform((v) => {
  return remap$(v, {
    fileUrl: "file_url",
    fileId: "file_id",
    timestampGranularities: "timestamp_granularities",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AudioTranscriptionRequest$ {
  /** @deprecated use `AudioTranscriptionRequest$inboundSchema` instead. */
  export const inboundSchema = AudioTranscriptionRequest$inboundSchema;
  /** @deprecated use `AudioTranscriptionRequest$outboundSchema` instead. */
  export const outboundSchema = AudioTranscriptionRequest$outboundSchema;
  /** @deprecated use `AudioTranscriptionRequest$Outbound` instead. */
  export type Outbound = AudioTranscriptionRequest$Outbound;
}

export function audioTranscriptionRequestToJSON(
  audioTranscriptionRequest: AudioTranscriptionRequest,
): string {
  return JSON.stringify(
    AudioTranscriptionRequest$outboundSchema.parse(audioTranscriptionRequest),
  );
}

export function audioTranscriptionRequestFromJSON(
  jsonString: string,
): SafeParseResult<AudioTranscriptionRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => AudioTranscriptionRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AudioTranscriptionRequest' from JSON`,
  );
}
