/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  ModelCapabilities,
  ModelCapabilities$inboundSchema,
  ModelCapabilities$Outbound,
  ModelCapabilities$outboundSchema,
} from "./modelcapabilities.js";

export const BaseModelCardType = {
  Base: "base",
} as const;
export type BaseModelCardType = ClosedEnum<typeof BaseModelCardType>;

export type BaseModelCard = {
  id: string;
  object?: string | undefined;
  created?: number | undefined;
  ownedBy?: string | undefined;
  capabilities: ModelCapabilities;
  name?: string | null | undefined;
  description?: string | null | undefined;
  maxContextLength?: number | undefined;
  aliases?: Array<string> | undefined;
  deprecation?: Date | null | undefined;
  deprecationReplacementModel?: string | null | undefined;
  defaultModelTemperature?: number | null | undefined;
  type?: "base" | undefined;
};

/** @internal */
export const BaseModelCardType$inboundSchema: z.ZodNativeEnum<
  typeof BaseModelCardType
> = z.nativeEnum(BaseModelCardType);

/** @internal */
export const BaseModelCardType$outboundSchema: z.ZodNativeEnum<
  typeof BaseModelCardType
> = BaseModelCardType$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BaseModelCardType$ {
  /** @deprecated use `BaseModelCardType$inboundSchema` instead. */
  export const inboundSchema = BaseModelCardType$inboundSchema;
  /** @deprecated use `BaseModelCardType$outboundSchema` instead. */
  export const outboundSchema = BaseModelCardType$outboundSchema;
}

/** @internal */
export const BaseModelCard$inboundSchema: z.ZodType<
  BaseModelCard,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  object: z.string().default("model"),
  created: z.number().int().optional(),
  owned_by: z.string().default("mistralai"),
  capabilities: ModelCapabilities$inboundSchema,
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  max_context_length: z.number().int().default(32768),
  aliases: z.array(z.string()).optional(),
  deprecation: z.nullable(
    z.string().datetime({ offset: true }).transform(v => new Date(v)),
  ).optional(),
  deprecation_replacement_model: z.nullable(z.string()).optional(),
  default_model_temperature: z.nullable(z.number()).optional(),
  type: z.literal("base").default("base"),
}).transform((v) => {
  return remap$(v, {
    "owned_by": "ownedBy",
    "max_context_length": "maxContextLength",
    "deprecation_replacement_model": "deprecationReplacementModel",
    "default_model_temperature": "defaultModelTemperature",
  });
});

/** @internal */
export type BaseModelCard$Outbound = {
  id: string;
  object: string;
  created?: number | undefined;
  owned_by: string;
  capabilities: ModelCapabilities$Outbound;
  name?: string | null | undefined;
  description?: string | null | undefined;
  max_context_length: number;
  aliases?: Array<string> | undefined;
  deprecation?: string | null | undefined;
  deprecation_replacement_model?: string | null | undefined;
  default_model_temperature?: number | null | undefined;
  type: "base";
};

/** @internal */
export const BaseModelCard$outboundSchema: z.ZodType<
  BaseModelCard$Outbound,
  z.ZodTypeDef,
  BaseModelCard
> = z.object({
  id: z.string(),
  object: z.string().default("model"),
  created: z.number().int().optional(),
  ownedBy: z.string().default("mistralai"),
  capabilities: ModelCapabilities$outboundSchema,
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  maxContextLength: z.number().int().default(32768),
  aliases: z.array(z.string()).optional(),
  deprecation: z.nullable(z.date().transform(v => v.toISOString())).optional(),
  deprecationReplacementModel: z.nullable(z.string()).optional(),
  defaultModelTemperature: z.nullable(z.number()).optional(),
  type: z.literal("base").default("base"),
}).transform((v) => {
  return remap$(v, {
    ownedBy: "owned_by",
    maxContextLength: "max_context_length",
    deprecationReplacementModel: "deprecation_replacement_model",
    defaultModelTemperature: "default_model_temperature",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BaseModelCard$ {
  /** @deprecated use `BaseModelCard$inboundSchema` instead. */
  export const inboundSchema = BaseModelCard$inboundSchema;
  /** @deprecated use `BaseModelCard$outboundSchema` instead. */
  export const outboundSchema = BaseModelCard$outboundSchema;
  /** @deprecated use `BaseModelCard$Outbound` instead. */
  export type Outbound = BaseModelCard$Outbound;
}

export function baseModelCardToJSON(baseModelCard: BaseModelCard): string {
  return JSON.stringify(BaseModelCard$outboundSchema.parse(baseModelCard));
}

export function baseModelCardFromJSON(
  jsonString: string,
): SafeParseResult<BaseModelCard, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => BaseModelCard$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'BaseModelCard' from JSON`,
  );
}
