/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  BatchError,
  BatchError$inboundSchema,
  BatchError$Outbound,
  BatchError$outboundSchema,
} from "./batcherror.js";
import {
  BatchJobStatus,
  BatchJobStatus$inboundSchema,
  BatchJobStatus$outboundSchema,
} from "./batchjobstatus.js";

export const BatchJobOutObject = {
  Batch: "batch",
} as const;
export type BatchJobOutObject = ClosedEnum<typeof BatchJobOutObject>;

export type BatchJobOut = {
  id: string;
  object?: BatchJobOutObject | undefined;
  inputFiles: Array<string>;
  metadata?: { [k: string]: any } | null | undefined;
  endpoint: string;
  model?: string | null | undefined;
  agentId?: string | null | undefined;
  outputFile?: string | null | undefined;
  errorFile?: string | null | undefined;
  errors: Array<BatchError>;
  status: BatchJobStatus;
  createdAt: number;
  totalRequests: number;
  completedRequests: number;
  succeededRequests: number;
  failedRequests: number;
  startedAt?: number | null | undefined;
  completedAt?: number | null | undefined;
};

/** @internal */
export const BatchJobOutObject$inboundSchema: z.ZodNativeEnum<
  typeof BatchJobOutObject
> = z.nativeEnum(BatchJobOutObject);

/** @internal */
export const BatchJobOutObject$outboundSchema: z.ZodNativeEnum<
  typeof BatchJobOutObject
> = BatchJobOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BatchJobOutObject$ {
  /** @deprecated use `BatchJobOutObject$inboundSchema` instead. */
  export const inboundSchema = BatchJobOutObject$inboundSchema;
  /** @deprecated use `BatchJobOutObject$outboundSchema` instead. */
  export const outboundSchema = BatchJobOutObject$outboundSchema;
}

/** @internal */
export const BatchJobOut$inboundSchema: z.ZodType<
  BatchJobOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  id: z.string(),
  object: BatchJobOutObject$inboundSchema.default("batch"),
  input_files: z.array(z.string()),
  metadata: z.nullable(z.record(z.any())).optional(),
  endpoint: z.string(),
  model: z.nullable(z.string()).optional(),
  agent_id: z.nullable(z.string()).optional(),
  output_file: z.nullable(z.string()).optional(),
  error_file: z.nullable(z.string()).optional(),
  errors: z.array(BatchError$inboundSchema),
  status: BatchJobStatus$inboundSchema,
  created_at: z.number().int(),
  total_requests: z.number().int(),
  completed_requests: z.number().int(),
  succeeded_requests: z.number().int(),
  failed_requests: z.number().int(),
  started_at: z.nullable(z.number().int()).optional(),
  completed_at: z.nullable(z.number().int()).optional(),
}).transform((v) => {
  return remap$(v, {
    "input_files": "inputFiles",
    "agent_id": "agentId",
    "output_file": "outputFile",
    "error_file": "errorFile",
    "created_at": "createdAt",
    "total_requests": "totalRequests",
    "completed_requests": "completedRequests",
    "succeeded_requests": "succeededRequests",
    "failed_requests": "failedRequests",
    "started_at": "startedAt",
    "completed_at": "completedAt",
  });
});

/** @internal */
export type BatchJobOut$Outbound = {
  id: string;
  object: string;
  input_files: Array<string>;
  metadata?: { [k: string]: any } | null | undefined;
  endpoint: string;
  model?: string | null | undefined;
  agent_id?: string | null | undefined;
  output_file?: string | null | undefined;
  error_file?: string | null | undefined;
  errors: Array<BatchError$Outbound>;
  status: string;
  created_at: number;
  total_requests: number;
  completed_requests: number;
  succeeded_requests: number;
  failed_requests: number;
  started_at?: number | null | undefined;
  completed_at?: number | null | undefined;
};

/** @internal */
export const BatchJobOut$outboundSchema: z.ZodType<
  BatchJobOut$Outbound,
  z.ZodTypeDef,
  BatchJobOut
> = z.object({
  id: z.string(),
  object: BatchJobOutObject$outboundSchema.default("batch"),
  inputFiles: z.array(z.string()),
  metadata: z.nullable(z.record(z.any())).optional(),
  endpoint: z.string(),
  model: z.nullable(z.string()).optional(),
  agentId: z.nullable(z.string()).optional(),
  outputFile: z.nullable(z.string()).optional(),
  errorFile: z.nullable(z.string()).optional(),
  errors: z.array(BatchError$outboundSchema),
  status: BatchJobStatus$outboundSchema,
  createdAt: z.number().int(),
  totalRequests: z.number().int(),
  completedRequests: z.number().int(),
  succeededRequests: z.number().int(),
  failedRequests: z.number().int(),
  startedAt: z.nullable(z.number().int()).optional(),
  completedAt: z.nullable(z.number().int()).optional(),
}).transform((v) => {
  return remap$(v, {
    inputFiles: "input_files",
    agentId: "agent_id",
    outputFile: "output_file",
    errorFile: "error_file",
    createdAt: "created_at",
    totalRequests: "total_requests",
    completedRequests: "completed_requests",
    succeededRequests: "succeeded_requests",
    failedRequests: "failed_requests",
    startedAt: "started_at",
    completedAt: "completed_at",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BatchJobOut$ {
  /** @deprecated use `BatchJobOut$inboundSchema` instead. */
  export const inboundSchema = BatchJobOut$inboundSchema;
  /** @deprecated use `BatchJobOut$outboundSchema` instead. */
  export const outboundSchema = BatchJobOut$outboundSchema;
  /** @deprecated use `BatchJobOut$Outbound` instead. */
  export type Outbound = BatchJobOut$Outbound;
}

export function batchJobOutToJSON(batchJobOut: BatchJobOut): string {
  return JSON.stringify(BatchJobOut$outboundSchema.parse(batchJobOut));
}

export function batchJobOutFromJSON(
  jsonString: string,
): SafeParseResult<BatchJobOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => BatchJobOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'BatchJobOut' from JSON`,
  );
}
