/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  BatchJobOut,
  BatchJobOut$inboundSchema,
  BatchJobOut$Outbound,
  BatchJobOut$outboundSchema,
} from "./batchjobout.js";

export const BatchJobsOutObject = {
  List: "list",
} as const;
export type BatchJobsOutObject = ClosedEnum<typeof BatchJobsOutObject>;

export type BatchJobsOut = {
  data?: Array<BatchJobOut> | undefined;
  object?: BatchJobsOutObject | undefined;
  total: number;
};

/** @internal */
export const BatchJobsOutObject$inboundSchema: z.ZodNativeEnum<
  typeof BatchJobsOutObject
> = z.nativeEnum(BatchJobsOutObject);

/** @internal */
export const BatchJobsOutObject$outboundSchema: z.ZodNativeEnum<
  typeof BatchJobsOutObject
> = BatchJobsOutObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BatchJobsOutObject$ {
  /** @deprecated use `BatchJobsOutObject$inboundSchema` instead. */
  export const inboundSchema = BatchJobsOutObject$inboundSchema;
  /** @deprecated use `BatchJobsOutObject$outboundSchema` instead. */
  export const outboundSchema = BatchJobsOutObject$outboundSchema;
}

/** @internal */
export const BatchJobsOut$inboundSchema: z.ZodType<
  BatchJobsOut,
  z.ZodTypeDef,
  unknown
> = z.object({
  data: z.array(BatchJobOut$inboundSchema).optional(),
  object: BatchJobsOutObject$inboundSchema.default("list"),
  total: z.number().int(),
});

/** @internal */
export type BatchJobsOut$Outbound = {
  data?: Array<BatchJobOut$Outbound> | undefined;
  object: string;
  total: number;
};

/** @internal */
export const BatchJobsOut$outboundSchema: z.ZodType<
  BatchJobsOut$Outbound,
  z.ZodTypeDef,
  BatchJobsOut
> = z.object({
  data: z.array(BatchJobOut$outboundSchema).optional(),
  object: BatchJobsOutObject$outboundSchema.default("list"),
  total: z.number().int(),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace BatchJobsOut$ {
  /** @deprecated use `BatchJobsOut$inboundSchema` instead. */
  export const inboundSchema = BatchJobsOut$inboundSchema;
  /** @deprecated use `BatchJobsOut$outboundSchema` instead. */
  export const outboundSchema = BatchJobsOut$outboundSchema;
  /** @deprecated use `BatchJobsOut$Outbound` instead. */
  export type Outbound = BatchJobsOut$Outbound;
}

export function batchJobsOutToJSON(batchJobsOut: BatchJobsOut): string {
  return JSON.stringify(BatchJobsOut$outboundSchema.parse(batchJobsOut));
}

export function batchJobsOutFromJSON(
  jsonString: string,
): SafeParseResult<BatchJobsOut, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => BatchJobsOut$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'BatchJobsOut' from JSON`,
  );
}
