/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type ClassificationTargetResult = {
  scores: { [k: string]: number };
};

/** @internal */
export const ClassificationTargetResult$inboundSchema: z.ZodType<
  ClassificationTargetResult,
  z.ZodTypeDef,
  unknown
> = z.object({
  scores: z.record(z.number()),
});

/** @internal */
export type ClassificationTargetResult$Outbound = {
  scores: { [k: string]: number };
};

/** @internal */
export const ClassificationTargetResult$outboundSchema: z.ZodType<
  ClassificationTargetResult$Outbound,
  z.ZodTypeDef,
  ClassificationTargetResult
> = z.object({
  scores: z.record(z.number()),
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassificationTargetResult$ {
  /** @deprecated use `ClassificationTargetResult$inboundSchema` instead. */
  export const inboundSchema = ClassificationTargetResult$inboundSchema;
  /** @deprecated use `ClassificationTargetResult$outboundSchema` instead. */
  export const outboundSchema = ClassificationTargetResult$outboundSchema;
  /** @deprecated use `ClassificationTargetResult$Outbound` instead. */
  export type Outbound = ClassificationTargetResult$Outbound;
}

export function classificationTargetResultToJSON(
  classificationTargetResult: ClassificationTargetResult,
): string {
  return JSON.stringify(
    ClassificationTargetResult$outboundSchema.parse(classificationTargetResult),
  );
}

export function classificationTargetResultFromJSON(
  jsonString: string,
): SafeParseResult<ClassificationTargetResult, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassificationTargetResult$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassificationTargetResult' from JSON`,
  );
}
