/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  FTClassifierLossFunction,
  FTClassifierLossFunction$inboundSchema,
  FTClassifierLossFunction$outboundSchema,
} from "./ftclassifierlossfunction.js";

export type ClassifierTargetIn = {
  name: string;
  labels: Array<string>;
  weight?: number | undefined;
  lossFunction?: FTClassifierLossFunction | null | undefined;
};

/** @internal */
export const ClassifierTargetIn$inboundSchema: z.ZodType<
  ClassifierTargetIn,
  z.ZodTypeDef,
  unknown
> = z.object({
  name: z.string(),
  labels: z.array(z.string()),
  weight: z.number().default(1),
  loss_function: z.nullable(FTClassifierLossFunction$inboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    "loss_function": "lossFunction",
  });
});

/** @internal */
export type ClassifierTargetIn$Outbound = {
  name: string;
  labels: Array<string>;
  weight: number;
  loss_function?: string | null | undefined;
};

/** @internal */
export const ClassifierTargetIn$outboundSchema: z.ZodType<
  ClassifierTargetIn$Outbound,
  z.ZodTypeDef,
  ClassifierTargetIn
> = z.object({
  name: z.string(),
  labels: z.array(z.string()),
  weight: z.number().default(1),
  lossFunction: z.nullable(FTClassifierLossFunction$outboundSchema).optional(),
}).transform((v) => {
  return remap$(v, {
    lossFunction: "loss_function",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierTargetIn$ {
  /** @deprecated use `ClassifierTargetIn$inboundSchema` instead. */
  export const inboundSchema = ClassifierTargetIn$inboundSchema;
  /** @deprecated use `ClassifierTargetIn$outboundSchema` instead. */
  export const outboundSchema = ClassifierTargetIn$outboundSchema;
  /** @deprecated use `ClassifierTargetIn$Outbound` instead. */
  export type Outbound = ClassifierTargetIn$Outbound;
}

export function classifierTargetInToJSON(
  classifierTargetIn: ClassifierTargetIn,
): string {
  return JSON.stringify(
    ClassifierTargetIn$outboundSchema.parse(classifierTargetIn),
  );
}

export function classifierTargetInFromJSON(
  jsonString: string,
): SafeParseResult<ClassifierTargetIn, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassifierTargetIn$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassifierTargetIn' from JSON`,
  );
}
