/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type ClassifierTrainingParameters = {
  trainingSteps?: number | null | undefined;
  learningRate?: number | undefined;
  weightDecay?: number | null | undefined;
  warmupFraction?: number | null | undefined;
  epochs?: number | null | undefined;
  seqLen?: number | null | undefined;
};

/** @internal */
export const ClassifierTrainingParameters$inboundSchema: z.ZodType<
  ClassifierTrainingParameters,
  z.ZodTypeDef,
  unknown
> = z.object({
  training_steps: z.nullable(z.number().int()).optional(),
  learning_rate: z.number().default(0.0001),
  weight_decay: z.nullable(z.number()).optional(),
  warmup_fraction: z.nullable(z.number()).optional(),
  epochs: z.nullable(z.number()).optional(),
  seq_len: z.nullable(z.number().int()).optional(),
}).transform((v) => {
  return remap$(v, {
    "training_steps": "trainingSteps",
    "learning_rate": "learningRate",
    "weight_decay": "weightDecay",
    "warmup_fraction": "warmupFraction",
    "seq_len": "seqLen",
  });
});

/** @internal */
export type ClassifierTrainingParameters$Outbound = {
  training_steps?: number | null | undefined;
  learning_rate: number;
  weight_decay?: number | null | undefined;
  warmup_fraction?: number | null | undefined;
  epochs?: number | null | undefined;
  seq_len?: number | null | undefined;
};

/** @internal */
export const ClassifierTrainingParameters$outboundSchema: z.ZodType<
  ClassifierTrainingParameters$Outbound,
  z.ZodTypeDef,
  ClassifierTrainingParameters
> = z.object({
  trainingSteps: z.nullable(z.number().int()).optional(),
  learningRate: z.number().default(0.0001),
  weightDecay: z.nullable(z.number()).optional(),
  warmupFraction: z.nullable(z.number()).optional(),
  epochs: z.nullable(z.number()).optional(),
  seqLen: z.nullable(z.number().int()).optional(),
}).transform((v) => {
  return remap$(v, {
    trainingSteps: "training_steps",
    learningRate: "learning_rate",
    weightDecay: "weight_decay",
    warmupFraction: "warmup_fraction",
    seqLen: "seq_len",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ClassifierTrainingParameters$ {
  /** @deprecated use `ClassifierTrainingParameters$inboundSchema` instead. */
  export const inboundSchema = ClassifierTrainingParameters$inboundSchema;
  /** @deprecated use `ClassifierTrainingParameters$outboundSchema` instead. */
  export const outboundSchema = ClassifierTrainingParameters$outboundSchema;
  /** @deprecated use `ClassifierTrainingParameters$Outbound` instead. */
  export type Outbound = ClassifierTrainingParameters$Outbound;
}

export function classifierTrainingParametersToJSON(
  classifierTrainingParameters: ClassifierTrainingParameters,
): string {
  return JSON.stringify(
    ClassifierTrainingParameters$outboundSchema.parse(
      classifierTrainingParameters,
    ),
  );
}

export function classifierTrainingParametersFromJSON(
  jsonString: string,
): SafeParseResult<ClassifierTrainingParameters, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ClassifierTrainingParameters$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ClassifierTrainingParameters' from JSON`,
  );
}
