/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CompletionArgsStop,
  CompletionArgsStop$inboundSchema,
  CompletionArgsStop$Outbound,
  CompletionArgsStop$outboundSchema,
} from "./completionargsstop.js";
import {
  Prediction,
  Prediction$inboundSchema,
  Prediction$Outbound,
  Prediction$outboundSchema,
} from "./prediction.js";
import {
  ResponseFormat,
  ResponseFormat$inboundSchema,
  ResponseFormat$Outbound,
  ResponseFormat$outboundSchema,
} from "./responseformat.js";
import {
  ToolChoiceEnum,
  ToolChoiceEnum$inboundSchema,
  ToolChoiceEnum$outboundSchema,
} from "./toolchoiceenum.js";

/**
 * White-listed arguments from the completion API
 */
export type CompletionArgs = {
  stop?: CompletionArgsStop | null | undefined;
  presencePenalty?: number | null | undefined;
  frequencyPenalty?: number | null | undefined;
  temperature?: number | null | undefined;
  topP?: number | null | undefined;
  maxTokens?: number | null | undefined;
  randomSeed?: number | null | undefined;
  prediction?: Prediction | null | undefined;
  responseFormat?: ResponseFormat | null | undefined;
  toolChoice?: ToolChoiceEnum | undefined;
};

/** @internal */
export const CompletionArgs$inboundSchema: z.ZodType<
  CompletionArgs,
  z.ZodTypeDef,
  unknown
> = z.object({
  stop: z.nullable(CompletionArgsStop$inboundSchema).optional(),
  presence_penalty: z.nullable(z.number()).optional(),
  frequency_penalty: z.nullable(z.number()).optional(),
  temperature: z.nullable(z.number()).optional(),
  top_p: z.nullable(z.number()).optional(),
  max_tokens: z.nullable(z.number().int()).optional(),
  random_seed: z.nullable(z.number().int()).optional(),
  prediction: z.nullable(Prediction$inboundSchema).optional(),
  response_format: z.nullable(ResponseFormat$inboundSchema).optional(),
  tool_choice: ToolChoiceEnum$inboundSchema.optional(),
}).transform((v) => {
  return remap$(v, {
    "presence_penalty": "presencePenalty",
    "frequency_penalty": "frequencyPenalty",
    "top_p": "topP",
    "max_tokens": "maxTokens",
    "random_seed": "randomSeed",
    "response_format": "responseFormat",
    "tool_choice": "toolChoice",
  });
});

/** @internal */
export type CompletionArgs$Outbound = {
  stop?: CompletionArgsStop$Outbound | null | undefined;
  presence_penalty?: number | null | undefined;
  frequency_penalty?: number | null | undefined;
  temperature?: number | null | undefined;
  top_p?: number | null | undefined;
  max_tokens?: number | null | undefined;
  random_seed?: number | null | undefined;
  prediction?: Prediction$Outbound | null | undefined;
  response_format?: ResponseFormat$Outbound | null | undefined;
  tool_choice?: string | undefined;
};

/** @internal */
export const CompletionArgs$outboundSchema: z.ZodType<
  CompletionArgs$Outbound,
  z.ZodTypeDef,
  CompletionArgs
> = z.object({
  stop: z.nullable(CompletionArgsStop$outboundSchema).optional(),
  presencePenalty: z.nullable(z.number()).optional(),
  frequencyPenalty: z.nullable(z.number()).optional(),
  temperature: z.nullable(z.number()).optional(),
  topP: z.nullable(z.number()).optional(),
  maxTokens: z.nullable(z.number().int()).optional(),
  randomSeed: z.nullable(z.number().int()).optional(),
  prediction: z.nullable(Prediction$outboundSchema).optional(),
  responseFormat: z.nullable(ResponseFormat$outboundSchema).optional(),
  toolChoice: ToolChoiceEnum$outboundSchema.optional(),
}).transform((v) => {
  return remap$(v, {
    presencePenalty: "presence_penalty",
    frequencyPenalty: "frequency_penalty",
    topP: "top_p",
    maxTokens: "max_tokens",
    randomSeed: "random_seed",
    responseFormat: "response_format",
    toolChoice: "tool_choice",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace CompletionArgs$ {
  /** @deprecated use `CompletionArgs$inboundSchema` instead. */
  export const inboundSchema = CompletionArgs$inboundSchema;
  /** @deprecated use `CompletionArgs$outboundSchema` instead. */
  export const outboundSchema = CompletionArgs$outboundSchema;
  /** @deprecated use `CompletionArgs$Outbound` instead. */
  export type Outbound = CompletionArgs$Outbound;
}

export function completionArgsToJSON(completionArgs: CompletionArgs): string {
  return JSON.stringify(CompletionArgs$outboundSchema.parse(completionArgs));
}

export function completionArgsFromJSON(
  jsonString: string,
): SafeParseResult<CompletionArgs, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => CompletionArgs$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'CompletionArgs' from JSON`,
  );
}
