/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  ConversationInputs,
  ConversationInputs$inboundSchema,
  ConversationInputs$Outbound,
  ConversationInputs$outboundSchema,
} from "./conversationinputs.js";

export const ConversationAppendStreamRequestHandoffExecution = {
  Client: "client",
  Server: "server",
} as const;
export type ConversationAppendStreamRequestHandoffExecution = ClosedEnum<
  typeof ConversationAppendStreamRequestHandoffExecution
>;

export type ConversationAppendStreamRequest = {
  inputs: ConversationInputs;
  stream?: boolean | undefined;
  /**
   * Whether to store the results into our servers or not.
   */
  store?: boolean | undefined;
  handoffExecution?:
    | ConversationAppendStreamRequestHandoffExecution
    | undefined;
  /**
   * White-listed arguments from the completion API
   */
  completionArgs?: CompletionArgs | undefined;
};

/** @internal */
export const ConversationAppendStreamRequestHandoffExecution$inboundSchema:
  z.ZodNativeEnum<typeof ConversationAppendStreamRequestHandoffExecution> = z
    .nativeEnum(ConversationAppendStreamRequestHandoffExecution);

/** @internal */
export const ConversationAppendStreamRequestHandoffExecution$outboundSchema:
  z.ZodNativeEnum<typeof ConversationAppendStreamRequestHandoffExecution> =
    ConversationAppendStreamRequestHandoffExecution$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationAppendStreamRequestHandoffExecution$ {
  /** @deprecated use `ConversationAppendStreamRequestHandoffExecution$inboundSchema` instead. */
  export const inboundSchema =
    ConversationAppendStreamRequestHandoffExecution$inboundSchema;
  /** @deprecated use `ConversationAppendStreamRequestHandoffExecution$outboundSchema` instead. */
  export const outboundSchema =
    ConversationAppendStreamRequestHandoffExecution$outboundSchema;
}

/** @internal */
export const ConversationAppendStreamRequest$inboundSchema: z.ZodType<
  ConversationAppendStreamRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  inputs: ConversationInputs$inboundSchema,
  stream: z.boolean().default(true),
  store: z.boolean().default(true),
  handoff_execution:
    ConversationAppendStreamRequestHandoffExecution$inboundSchema.default(
      "server",
    ),
  completion_args: CompletionArgs$inboundSchema.optional(),
}).transform((v) => {
  return remap$(v, {
    "handoff_execution": "handoffExecution",
    "completion_args": "completionArgs",
  });
});

/** @internal */
export type ConversationAppendStreamRequest$Outbound = {
  inputs: ConversationInputs$Outbound;
  stream: boolean;
  store: boolean;
  handoff_execution: string;
  completion_args?: CompletionArgs$Outbound | undefined;
};

/** @internal */
export const ConversationAppendStreamRequest$outboundSchema: z.ZodType<
  ConversationAppendStreamRequest$Outbound,
  z.ZodTypeDef,
  ConversationAppendStreamRequest
> = z.object({
  inputs: ConversationInputs$outboundSchema,
  stream: z.boolean().default(true),
  store: z.boolean().default(true),
  handoffExecution:
    ConversationAppendStreamRequestHandoffExecution$outboundSchema.default(
      "server",
    ),
  completionArgs: CompletionArgs$outboundSchema.optional(),
}).transform((v) => {
  return remap$(v, {
    handoffExecution: "handoff_execution",
    completionArgs: "completion_args",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationAppendStreamRequest$ {
  /** @deprecated use `ConversationAppendStreamRequest$inboundSchema` instead. */
  export const inboundSchema = ConversationAppendStreamRequest$inboundSchema;
  /** @deprecated use `ConversationAppendStreamRequest$outboundSchema` instead. */
  export const outboundSchema = ConversationAppendStreamRequest$outboundSchema;
  /** @deprecated use `ConversationAppendStreamRequest$Outbound` instead. */
  export type Outbound = ConversationAppendStreamRequest$Outbound;
}

export function conversationAppendStreamRequestToJSON(
  conversationAppendStreamRequest: ConversationAppendStreamRequest,
): string {
  return JSON.stringify(
    ConversationAppendStreamRequest$outboundSchema.parse(
      conversationAppendStreamRequest,
    ),
  );
}

export function conversationAppendStreamRequestFromJSON(
  jsonString: string,
): SafeParseResult<ConversationAppendStreamRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationAppendStreamRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationAppendStreamRequest' from JSON`,
  );
}
