/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  InputEntries,
  InputEntries$inboundSchema,
  InputEntries$Outbound,
  InputEntries$outboundSchema,
} from "./inputentries.js";

export type ConversationInputs = string | Array<InputEntries>;

/** @internal */
export const ConversationInputs$inboundSchema: z.ZodType<
  ConversationInputs,
  z.ZodTypeDef,
  unknown
> = z.union([z.string(), z.array(InputEntries$inboundSchema)]);

/** @internal */
export type ConversationInputs$Outbound = string | Array<InputEntries$Outbound>;

/** @internal */
export const ConversationInputs$outboundSchema: z.ZodType<
  ConversationInputs$Outbound,
  z.ZodTypeDef,
  ConversationInputs
> = z.union([z.string(), z.array(InputEntries$outboundSchema)]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationInputs$ {
  /** @deprecated use `ConversationInputs$inboundSchema` instead. */
  export const inboundSchema = ConversationInputs$inboundSchema;
  /** @deprecated use `ConversationInputs$outboundSchema` instead. */
  export const outboundSchema = ConversationInputs$outboundSchema;
  /** @deprecated use `ConversationInputs$Outbound` instead. */
  export type Outbound = ConversationInputs$Outbound;
}

export function conversationInputsToJSON(
  conversationInputs: ConversationInputs,
): string {
  return JSON.stringify(
    ConversationInputs$outboundSchema.parse(conversationInputs),
  );
}

export function conversationInputsFromJSON(
  jsonString: string,
): SafeParseResult<ConversationInputs, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationInputs$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationInputs' from JSON`,
  );
}
