/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  MessageEntries,
  MessageEntries$inboundSchema,
  MessageEntries$Outbound,
  MessageEntries$outboundSchema,
} from "./messageentries.js";

export const ConversationMessagesObject = {
  ConversationMessages: "conversation.messages",
} as const;
export type ConversationMessagesObject = ClosedEnum<
  typeof ConversationMessagesObject
>;

/**
 * Similar to the conversation history but only keep the messages
 */
export type ConversationMessages = {
  object?: ConversationMessagesObject | undefined;
  conversationId: string;
  messages: Array<MessageEntries>;
};

/** @internal */
export const ConversationMessagesObject$inboundSchema: z.ZodNativeEnum<
  typeof ConversationMessagesObject
> = z.nativeEnum(ConversationMessagesObject);

/** @internal */
export const ConversationMessagesObject$outboundSchema: z.ZodNativeEnum<
  typeof ConversationMessagesObject
> = ConversationMessagesObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationMessagesObject$ {
  /** @deprecated use `ConversationMessagesObject$inboundSchema` instead. */
  export const inboundSchema = ConversationMessagesObject$inboundSchema;
  /** @deprecated use `ConversationMessagesObject$outboundSchema` instead. */
  export const outboundSchema = ConversationMessagesObject$outboundSchema;
}

/** @internal */
export const ConversationMessages$inboundSchema: z.ZodType<
  ConversationMessages,
  z.ZodTypeDef,
  unknown
> = z.object({
  object: ConversationMessagesObject$inboundSchema.default(
    "conversation.messages",
  ),
  conversation_id: z.string(),
  messages: z.array(MessageEntries$inboundSchema),
}).transform((v) => {
  return remap$(v, {
    "conversation_id": "conversationId",
  });
});

/** @internal */
export type ConversationMessages$Outbound = {
  object: string;
  conversation_id: string;
  messages: Array<MessageEntries$Outbound>;
};

/** @internal */
export const ConversationMessages$outboundSchema: z.ZodType<
  ConversationMessages$Outbound,
  z.ZodTypeDef,
  ConversationMessages
> = z.object({
  object: ConversationMessagesObject$outboundSchema.default(
    "conversation.messages",
  ),
  conversationId: z.string(),
  messages: z.array(MessageEntries$outboundSchema),
}).transform((v) => {
  return remap$(v, {
    conversationId: "conversation_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationMessages$ {
  /** @deprecated use `ConversationMessages$inboundSchema` instead. */
  export const inboundSchema = ConversationMessages$inboundSchema;
  /** @deprecated use `ConversationMessages$outboundSchema` instead. */
  export const outboundSchema = ConversationMessages$outboundSchema;
  /** @deprecated use `ConversationMessages$Outbound` instead. */
  export type Outbound = ConversationMessages$Outbound;
}

export function conversationMessagesToJSON(
  conversationMessages: ConversationMessages,
): string {
  return JSON.stringify(
    ConversationMessages$outboundSchema.parse(conversationMessages),
  );
}

export function conversationMessagesFromJSON(
  jsonString: string,
): SafeParseResult<ConversationMessages, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationMessages$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationMessages' from JSON`,
  );
}
