/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  CodeInterpreterTool,
  CodeInterpreterTool$inboundSchema,
  CodeInterpreterTool$Outbound,
  CodeInterpreterTool$outboundSchema,
} from "./codeinterpretertool.js";
import {
  CompletionArgs,
  CompletionArgs$inboundSchema,
  CompletionArgs$Outbound,
  CompletionArgs$outboundSchema,
} from "./completionargs.js";
import {
  ConversationInputs,
  ConversationInputs$inboundSchema,
  ConversationInputs$Outbound,
  ConversationInputs$outboundSchema,
} from "./conversationinputs.js";
import {
  DocumentLibraryTool,
  DocumentLibraryTool$inboundSchema,
  DocumentLibraryTool$Outbound,
  DocumentLibraryTool$outboundSchema,
} from "./documentlibrarytool.js";
import {
  FunctionTool,
  FunctionTool$inboundSchema,
  FunctionTool$Outbound,
  FunctionTool$outboundSchema,
} from "./functiontool.js";
import {
  ImageGenerationTool,
  ImageGenerationTool$inboundSchema,
  ImageGenerationTool$Outbound,
  ImageGenerationTool$outboundSchema,
} from "./imagegenerationtool.js";
import {
  WebSearchPremiumTool,
  WebSearchPremiumTool$inboundSchema,
  WebSearchPremiumTool$Outbound,
  WebSearchPremiumTool$outboundSchema,
} from "./websearchpremiumtool.js";
import {
  WebSearchTool,
  WebSearchTool$inboundSchema,
  WebSearchTool$Outbound,
  WebSearchTool$outboundSchema,
} from "./websearchtool.js";

export const HandoffExecution = {
  Client: "client",
  Server: "server",
} as const;
export type HandoffExecution = ClosedEnum<typeof HandoffExecution>;

export type Tools =
  | (DocumentLibraryTool & { type: "document_library" })
  | (FunctionTool & { type: "function" })
  | (CodeInterpreterTool & { type: "code_interpreter" })
  | (ImageGenerationTool & { type: "image_generation" })
  | (WebSearchTool & { type: "web_search" })
  | (WebSearchPremiumTool & { type: "web_search_premium" });

export type ConversationRequest = {
  inputs: ConversationInputs;
  stream?: boolean | undefined;
  store?: boolean | null | undefined;
  handoffExecution?: HandoffExecution | null | undefined;
  instructions?: string | null | undefined;
  tools?:
    | Array<
      | (DocumentLibraryTool & { type: "document_library" })
      | (FunctionTool & { type: "function" })
      | (CodeInterpreterTool & { type: "code_interpreter" })
      | (ImageGenerationTool & { type: "image_generation" })
      | (WebSearchTool & { type: "web_search" })
      | (WebSearchPremiumTool & { type: "web_search_premium" })
    >
    | null
    | undefined;
  completionArgs?: CompletionArgs | null | undefined;
  name?: string | null | undefined;
  description?: string | null | undefined;
  agentId?: string | null | undefined;
  model?: string | null | undefined;
};

/** @internal */
export const HandoffExecution$inboundSchema: z.ZodNativeEnum<
  typeof HandoffExecution
> = z.nativeEnum(HandoffExecution);

/** @internal */
export const HandoffExecution$outboundSchema: z.ZodNativeEnum<
  typeof HandoffExecution
> = HandoffExecution$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace HandoffExecution$ {
  /** @deprecated use `HandoffExecution$inboundSchema` instead. */
  export const inboundSchema = HandoffExecution$inboundSchema;
  /** @deprecated use `HandoffExecution$outboundSchema` instead. */
  export const outboundSchema = HandoffExecution$outboundSchema;
}

/** @internal */
export const Tools$inboundSchema: z.ZodType<Tools, z.ZodTypeDef, unknown> = z
  .union([
    DocumentLibraryTool$inboundSchema.and(
      z.object({ type: z.literal("document_library") }).transform((v) => ({
        type: v.type,
      })),
    ),
    FunctionTool$inboundSchema.and(
      z.object({ type: z.literal("function") }).transform((v) => ({
        type: v.type,
      })),
    ),
    CodeInterpreterTool$inboundSchema.and(
      z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
        type: v.type,
      })),
    ),
    ImageGenerationTool$inboundSchema.and(
      z.object({ type: z.literal("image_generation") }).transform((v) => ({
        type: v.type,
      })),
    ),
    WebSearchTool$inboundSchema.and(
      z.object({ type: z.literal("web_search") }).transform((v) => ({
        type: v.type,
      })),
    ),
    WebSearchPremiumTool$inboundSchema.and(
      z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
        type: v.type,
      })),
    ),
  ]);

/** @internal */
export type Tools$Outbound =
  | (DocumentLibraryTool$Outbound & { type: "document_library" })
  | (FunctionTool$Outbound & { type: "function" })
  | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
  | (ImageGenerationTool$Outbound & { type: "image_generation" })
  | (WebSearchTool$Outbound & { type: "web_search" })
  | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" });

/** @internal */
export const Tools$outboundSchema: z.ZodType<
  Tools$Outbound,
  z.ZodTypeDef,
  Tools
> = z.union([
  DocumentLibraryTool$outboundSchema.and(
    z.object({ type: z.literal("document_library") }).transform((v) => ({
      type: v.type,
    })),
  ),
  FunctionTool$outboundSchema.and(
    z.object({ type: z.literal("function") }).transform((v) => ({
      type: v.type,
    })),
  ),
  CodeInterpreterTool$outboundSchema.and(
    z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
      type: v.type,
    })),
  ),
  ImageGenerationTool$outboundSchema.and(
    z.object({ type: z.literal("image_generation") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchTool$outboundSchema.and(
    z.object({ type: z.literal("web_search") }).transform((v) => ({
      type: v.type,
    })),
  ),
  WebSearchPremiumTool$outboundSchema.and(
    z.object({ type: z.literal("web_search_premium") }).transform((v) => ({
      type: v.type,
    })),
  ),
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Tools$ {
  /** @deprecated use `Tools$inboundSchema` instead. */
  export const inboundSchema = Tools$inboundSchema;
  /** @deprecated use `Tools$outboundSchema` instead. */
  export const outboundSchema = Tools$outboundSchema;
  /** @deprecated use `Tools$Outbound` instead. */
  export type Outbound = Tools$Outbound;
}

export function toolsToJSON(tools: Tools): string {
  return JSON.stringify(Tools$outboundSchema.parse(tools));
}

export function toolsFromJSON(
  jsonString: string,
): SafeParseResult<Tools, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Tools$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Tools' from JSON`,
  );
}

/** @internal */
export const ConversationRequest$inboundSchema: z.ZodType<
  ConversationRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  inputs: ConversationInputs$inboundSchema,
  stream: z.boolean().default(false),
  store: z.nullable(z.boolean()).optional(),
  handoff_execution: z.nullable(HandoffExecution$inboundSchema).optional(),
  instructions: z.nullable(z.string()).optional(),
  tools: z.nullable(
    z.array(
      z.union([
        DocumentLibraryTool$inboundSchema.and(
          z.object({ type: z.literal("document_library") }).transform((v) => ({
            type: v.type,
          })),
        ),
        FunctionTool$inboundSchema.and(
          z.object({ type: z.literal("function") }).transform((v) => ({
            type: v.type,
          })),
        ),
        CodeInterpreterTool$inboundSchema.and(
          z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
            type: v.type,
          })),
        ),
        ImageGenerationTool$inboundSchema.and(
          z.object({ type: z.literal("image_generation") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchTool$inboundSchema.and(
          z.object({ type: z.literal("web_search") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchPremiumTool$inboundSchema.and(
          z.object({ type: z.literal("web_search_premium") }).transform((
            v,
          ) => ({ type: v.type })),
        ),
      ]),
    ),
  ).optional(),
  completion_args: z.nullable(CompletionArgs$inboundSchema).optional(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  agent_id: z.nullable(z.string()).optional(),
  model: z.nullable(z.string()).optional(),
}).transform((v) => {
  return remap$(v, {
    "handoff_execution": "handoffExecution",
    "completion_args": "completionArgs",
    "agent_id": "agentId",
  });
});

/** @internal */
export type ConversationRequest$Outbound = {
  inputs: ConversationInputs$Outbound;
  stream: boolean;
  store?: boolean | null | undefined;
  handoff_execution?: string | null | undefined;
  instructions?: string | null | undefined;
  tools?:
    | Array<
      | (DocumentLibraryTool$Outbound & { type: "document_library" })
      | (FunctionTool$Outbound & { type: "function" })
      | (CodeInterpreterTool$Outbound & { type: "code_interpreter" })
      | (ImageGenerationTool$Outbound & { type: "image_generation" })
      | (WebSearchTool$Outbound & { type: "web_search" })
      | (WebSearchPremiumTool$Outbound & { type: "web_search_premium" })
    >
    | null
    | undefined;
  completion_args?: CompletionArgs$Outbound | null | undefined;
  name?: string | null | undefined;
  description?: string | null | undefined;
  agent_id?: string | null | undefined;
  model?: string | null | undefined;
};

/** @internal */
export const ConversationRequest$outboundSchema: z.ZodType<
  ConversationRequest$Outbound,
  z.ZodTypeDef,
  ConversationRequest
> = z.object({
  inputs: ConversationInputs$outboundSchema,
  stream: z.boolean().default(false),
  store: z.nullable(z.boolean()).optional(),
  handoffExecution: z.nullable(HandoffExecution$outboundSchema).optional(),
  instructions: z.nullable(z.string()).optional(),
  tools: z.nullable(
    z.array(
      z.union([
        DocumentLibraryTool$outboundSchema.and(
          z.object({ type: z.literal("document_library") }).transform((v) => ({
            type: v.type,
          })),
        ),
        FunctionTool$outboundSchema.and(
          z.object({ type: z.literal("function") }).transform((v) => ({
            type: v.type,
          })),
        ),
        CodeInterpreterTool$outboundSchema.and(
          z.object({ type: z.literal("code_interpreter") }).transform((v) => ({
            type: v.type,
          })),
        ),
        ImageGenerationTool$outboundSchema.and(
          z.object({ type: z.literal("image_generation") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchTool$outboundSchema.and(
          z.object({ type: z.literal("web_search") }).transform((v) => ({
            type: v.type,
          })),
        ),
        WebSearchPremiumTool$outboundSchema.and(
          z.object({ type: z.literal("web_search_premium") }).transform((
            v,
          ) => ({ type: v.type })),
        ),
      ]),
    ),
  ).optional(),
  completionArgs: z.nullable(CompletionArgs$outboundSchema).optional(),
  name: z.nullable(z.string()).optional(),
  description: z.nullable(z.string()).optional(),
  agentId: z.nullable(z.string()).optional(),
  model: z.nullable(z.string()).optional(),
}).transform((v) => {
  return remap$(v, {
    handoffExecution: "handoff_execution",
    completionArgs: "completion_args",
    agentId: "agent_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationRequest$ {
  /** @deprecated use `ConversationRequest$inboundSchema` instead. */
  export const inboundSchema = ConversationRequest$inboundSchema;
  /** @deprecated use `ConversationRequest$outboundSchema` instead. */
  export const outboundSchema = ConversationRequest$outboundSchema;
  /** @deprecated use `ConversationRequest$Outbound` instead. */
  export type Outbound = ConversationRequest$Outbound;
}

export function conversationRequestToJSON(
  conversationRequest: ConversationRequest,
): string {
  return JSON.stringify(
    ConversationRequest$outboundSchema.parse(conversationRequest),
  );
}

export function conversationRequestFromJSON(
  jsonString: string,
): SafeParseResult<ConversationRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationRequest' from JSON`,
  );
}
