/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { ClosedEnum } from "../../types/enums.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";
import {
  AgentHandoffEntry,
  AgentHandoffEntry$inboundSchema,
  AgentHandoffEntry$Outbound,
  AgentHandoffEntry$outboundSchema,
} from "./agenthandoffentry.js";
import {
  ConversationUsageInfo,
  ConversationUsageInfo$inboundSchema,
  ConversationUsageInfo$Outbound,
  ConversationUsageInfo$outboundSchema,
} from "./conversationusageinfo.js";
import {
  FunctionCallEntry,
  FunctionCallEntry$inboundSchema,
  FunctionCallEntry$Outbound,
  FunctionCallEntry$outboundSchema,
} from "./functioncallentry.js";
import {
  MessageOutputEntry,
  MessageOutputEntry$inboundSchema,
  MessageOutputEntry$Outbound,
  MessageOutputEntry$outboundSchema,
} from "./messageoutputentry.js";
import {
  ToolExecutionEntry,
  ToolExecutionEntry$inboundSchema,
  ToolExecutionEntry$Outbound,
  ToolExecutionEntry$outboundSchema,
} from "./toolexecutionentry.js";

export const ConversationResponseObject = {
  ConversationResponse: "conversation.response",
} as const;
export type ConversationResponseObject = ClosedEnum<
  typeof ConversationResponseObject
>;

export type Outputs =
  | AgentHandoffEntry
  | FunctionCallEntry
  | ToolExecutionEntry
  | MessageOutputEntry;

/**
 * The response after appending new entries to the conversation.
 */
export type ConversationResponse = {
  object?: ConversationResponseObject | undefined;
  conversationId: string;
  outputs: Array<
    | AgentHandoffEntry
    | FunctionCallEntry
    | ToolExecutionEntry
    | MessageOutputEntry
  >;
  usage: ConversationUsageInfo;
};

/** @internal */
export const ConversationResponseObject$inboundSchema: z.ZodNativeEnum<
  typeof ConversationResponseObject
> = z.nativeEnum(ConversationResponseObject);

/** @internal */
export const ConversationResponseObject$outboundSchema: z.ZodNativeEnum<
  typeof ConversationResponseObject
> = ConversationResponseObject$inboundSchema;

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationResponseObject$ {
  /** @deprecated use `ConversationResponseObject$inboundSchema` instead. */
  export const inboundSchema = ConversationResponseObject$inboundSchema;
  /** @deprecated use `ConversationResponseObject$outboundSchema` instead. */
  export const outboundSchema = ConversationResponseObject$outboundSchema;
}

/** @internal */
export const Outputs$inboundSchema: z.ZodType<Outputs, z.ZodTypeDef, unknown> =
  z.union([
    AgentHandoffEntry$inboundSchema,
    FunctionCallEntry$inboundSchema,
    ToolExecutionEntry$inboundSchema,
    MessageOutputEntry$inboundSchema,
  ]);

/** @internal */
export type Outputs$Outbound =
  | AgentHandoffEntry$Outbound
  | FunctionCallEntry$Outbound
  | ToolExecutionEntry$Outbound
  | MessageOutputEntry$Outbound;

/** @internal */
export const Outputs$outboundSchema: z.ZodType<
  Outputs$Outbound,
  z.ZodTypeDef,
  Outputs
> = z.union([
  AgentHandoffEntry$outboundSchema,
  FunctionCallEntry$outboundSchema,
  ToolExecutionEntry$outboundSchema,
  MessageOutputEntry$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace Outputs$ {
  /** @deprecated use `Outputs$inboundSchema` instead. */
  export const inboundSchema = Outputs$inboundSchema;
  /** @deprecated use `Outputs$outboundSchema` instead. */
  export const outboundSchema = Outputs$outboundSchema;
  /** @deprecated use `Outputs$Outbound` instead. */
  export type Outbound = Outputs$Outbound;
}

export function outputsToJSON(outputs: Outputs): string {
  return JSON.stringify(Outputs$outboundSchema.parse(outputs));
}

export function outputsFromJSON(
  jsonString: string,
): SafeParseResult<Outputs, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => Outputs$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'Outputs' from JSON`,
  );
}

/** @internal */
export const ConversationResponse$inboundSchema: z.ZodType<
  ConversationResponse,
  z.ZodTypeDef,
  unknown
> = z.object({
  object: ConversationResponseObject$inboundSchema.default(
    "conversation.response",
  ),
  conversation_id: z.string(),
  outputs: z.array(
    z.union([
      AgentHandoffEntry$inboundSchema,
      FunctionCallEntry$inboundSchema,
      ToolExecutionEntry$inboundSchema,
      MessageOutputEntry$inboundSchema,
    ]),
  ),
  usage: ConversationUsageInfo$inboundSchema,
}).transform((v) => {
  return remap$(v, {
    "conversation_id": "conversationId",
  });
});

/** @internal */
export type ConversationResponse$Outbound = {
  object: string;
  conversation_id: string;
  outputs: Array<
    | AgentHandoffEntry$Outbound
    | FunctionCallEntry$Outbound
    | ToolExecutionEntry$Outbound
    | MessageOutputEntry$Outbound
  >;
  usage: ConversationUsageInfo$Outbound;
};

/** @internal */
export const ConversationResponse$outboundSchema: z.ZodType<
  ConversationResponse$Outbound,
  z.ZodTypeDef,
  ConversationResponse
> = z.object({
  object: ConversationResponseObject$outboundSchema.default(
    "conversation.response",
  ),
  conversationId: z.string(),
  outputs: z.array(
    z.union([
      AgentHandoffEntry$outboundSchema,
      FunctionCallEntry$outboundSchema,
      ToolExecutionEntry$outboundSchema,
      MessageOutputEntry$outboundSchema,
    ]),
  ),
  usage: ConversationUsageInfo$outboundSchema,
}).transform((v) => {
  return remap$(v, {
    conversationId: "conversation_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ConversationResponse$ {
  /** @deprecated use `ConversationResponse$inboundSchema` instead. */
  export const inboundSchema = ConversationResponse$inboundSchema;
  /** @deprecated use `ConversationResponse$outboundSchema` instead. */
  export const outboundSchema = ConversationResponse$outboundSchema;
  /** @deprecated use `ConversationResponse$Outbound` instead. */
  export type Outbound = ConversationResponse$Outbound;
}

export function conversationResponseToJSON(
  conversationResponse: ConversationResponse,
): string {
  return JSON.stringify(
    ConversationResponse$outboundSchema.parse(conversationResponse),
  );
}

export function conversationResponseFromJSON(
  jsonString: string,
): SafeParseResult<ConversationResponse, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ConversationResponse$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ConversationResponse' from JSON`,
  );
}
