/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1ConversationsAppendStreamRequest = {
  /**
   * ID of the conversation to which we append entries.
   */
  conversationId: string;
  conversationAppendStreamRequest: components.ConversationAppendStreamRequest;
};

/** @internal */
export const AgentsApiV1ConversationsAppendStreamRequest$inboundSchema:
  z.ZodType<
    AgentsApiV1ConversationsAppendStreamRequest,
    z.ZodTypeDef,
    unknown
  > = z.object({
    conversation_id: z.string(),
    ConversationAppendStreamRequest:
      components.ConversationAppendStreamRequest$inboundSchema,
  }).transform((v) => {
    return remap$(v, {
      "conversation_id": "conversationId",
      "ConversationAppendStreamRequest": "conversationAppendStreamRequest",
    });
  });

/** @internal */
export type AgentsApiV1ConversationsAppendStreamRequest$Outbound = {
  conversation_id: string;
  ConversationAppendStreamRequest:
    components.ConversationAppendStreamRequest$Outbound;
};

/** @internal */
export const AgentsApiV1ConversationsAppendStreamRequest$outboundSchema:
  z.ZodType<
    AgentsApiV1ConversationsAppendStreamRequest$Outbound,
    z.ZodTypeDef,
    AgentsApiV1ConversationsAppendStreamRequest
  > = z.object({
    conversationId: z.string(),
    conversationAppendStreamRequest:
      components.ConversationAppendStreamRequest$outboundSchema,
  }).transform((v) => {
    return remap$(v, {
      conversationId: "conversation_id",
      conversationAppendStreamRequest: "ConversationAppendStreamRequest",
    });
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsAppendStreamRequest$ {
  /** @deprecated use `AgentsApiV1ConversationsAppendStreamRequest$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1ConversationsAppendStreamRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsAppendStreamRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsAppendStreamRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsAppendStreamRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1ConversationsAppendStreamRequest$Outbound;
}

export function agentsApiV1ConversationsAppendStreamRequestToJSON(
  agentsApiV1ConversationsAppendStreamRequest:
    AgentsApiV1ConversationsAppendStreamRequest,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsAppendStreamRequest$outboundSchema.parse(
      agentsApiV1ConversationsAppendStreamRequest,
    ),
  );
}

export function agentsApiV1ConversationsAppendStreamRequestFromJSON(
  jsonString: string,
): SafeParseResult<
  AgentsApiV1ConversationsAppendStreamRequest,
  SDKValidationError
> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsAppendStreamRequest$inboundSchema.parse(
        JSON.parse(x),
      ),
    `Failed to parse 'AgentsApiV1ConversationsAppendStreamRequest' from JSON`,
  );
}
