/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1ConversationsGetRequest = {
  /**
   * ID of the conversation from which we are fetching metadata.
   */
  conversationId: string;
};

/**
 * Successful Response
 */
export type AgentsApiV1ConversationsGetResponseV1ConversationsGet =
  | components.ModelConversation
  | components.AgentConversation;

/** @internal */
export const AgentsApiV1ConversationsGetRequest$inboundSchema: z.ZodType<
  AgentsApiV1ConversationsGetRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  conversation_id: z.string(),
}).transform((v) => {
  return remap$(v, {
    "conversation_id": "conversationId",
  });
});

/** @internal */
export type AgentsApiV1ConversationsGetRequest$Outbound = {
  conversation_id: string;
};

/** @internal */
export const AgentsApiV1ConversationsGetRequest$outboundSchema: z.ZodType<
  AgentsApiV1ConversationsGetRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1ConversationsGetRequest
> = z.object({
  conversationId: z.string(),
}).transform((v) => {
  return remap$(v, {
    conversationId: "conversation_id",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsGetRequest$ {
  /** @deprecated use `AgentsApiV1ConversationsGetRequest$inboundSchema` instead. */
  export const inboundSchema = AgentsApiV1ConversationsGetRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsGetRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsGetRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsGetRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1ConversationsGetRequest$Outbound;
}

export function agentsApiV1ConversationsGetRequestToJSON(
  agentsApiV1ConversationsGetRequest: AgentsApiV1ConversationsGetRequest,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsGetRequest$outboundSchema.parse(
      agentsApiV1ConversationsGetRequest,
    ),
  );
}

export function agentsApiV1ConversationsGetRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1ConversationsGetRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsGetRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1ConversationsGetRequest' from JSON`,
  );
}

/** @internal */
export const AgentsApiV1ConversationsGetResponseV1ConversationsGet$inboundSchema:
  z.ZodType<
    AgentsApiV1ConversationsGetResponseV1ConversationsGet,
    z.ZodTypeDef,
    unknown
  > = z.union([
    components.ModelConversation$inboundSchema,
    components.AgentConversation$inboundSchema,
  ]);

/** @internal */
export type AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound =
  | components.ModelConversation$Outbound
  | components.AgentConversation$Outbound;

/** @internal */
export const AgentsApiV1ConversationsGetResponseV1ConversationsGet$outboundSchema:
  z.ZodType<
    AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound,
    z.ZodTypeDef,
    AgentsApiV1ConversationsGetResponseV1ConversationsGet
  > = z.union([
    components.ModelConversation$outboundSchema,
    components.AgentConversation$outboundSchema,
  ]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsGetResponseV1ConversationsGet$ {
  /** @deprecated use `AgentsApiV1ConversationsGetResponseV1ConversationsGet$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1ConversationsGetResponseV1ConversationsGet$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsGetResponseV1ConversationsGet$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsGetResponseV1ConversationsGet$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound` instead. */
  export type Outbound =
    AgentsApiV1ConversationsGetResponseV1ConversationsGet$Outbound;
}

export function agentsApiV1ConversationsGetResponseV1ConversationsGetToJSON(
  agentsApiV1ConversationsGetResponseV1ConversationsGet:
    AgentsApiV1ConversationsGetResponseV1ConversationsGet,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsGetResponseV1ConversationsGet$outboundSchema.parse(
      agentsApiV1ConversationsGetResponseV1ConversationsGet,
    ),
  );
}

export function agentsApiV1ConversationsGetResponseV1ConversationsGetFromJSON(
  jsonString: string,
): SafeParseResult<
  AgentsApiV1ConversationsGetResponseV1ConversationsGet,
  SDKValidationError
> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsGetResponseV1ConversationsGet$inboundSchema.parse(
        JSON.parse(x),
      ),
    `Failed to parse 'AgentsApiV1ConversationsGetResponseV1ConversationsGet' from JSON`,
  );
}
