/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1ConversationsListRequest = {
  page?: number | undefined;
  pageSize?: number | undefined;
};

export type ResponseBody =
  | components.ModelConversation
  | components.AgentConversation;

/** @internal */
export const AgentsApiV1ConversationsListRequest$inboundSchema: z.ZodType<
  AgentsApiV1ConversationsListRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  page: z.number().int().default(0),
  page_size: z.number().int().default(100),
}).transform((v) => {
  return remap$(v, {
    "page_size": "pageSize",
  });
});

/** @internal */
export type AgentsApiV1ConversationsListRequest$Outbound = {
  page: number;
  page_size: number;
};

/** @internal */
export const AgentsApiV1ConversationsListRequest$outboundSchema: z.ZodType<
  AgentsApiV1ConversationsListRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1ConversationsListRequest
> = z.object({
  page: z.number().int().default(0),
  pageSize: z.number().int().default(100),
}).transform((v) => {
  return remap$(v, {
    pageSize: "page_size",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsListRequest$ {
  /** @deprecated use `AgentsApiV1ConversationsListRequest$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1ConversationsListRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsListRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsListRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsListRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1ConversationsListRequest$Outbound;
}

export function agentsApiV1ConversationsListRequestToJSON(
  agentsApiV1ConversationsListRequest: AgentsApiV1ConversationsListRequest,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsListRequest$outboundSchema.parse(
      agentsApiV1ConversationsListRequest,
    ),
  );
}

export function agentsApiV1ConversationsListRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1ConversationsListRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsListRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1ConversationsListRequest' from JSON`,
  );
}

/** @internal */
export const ResponseBody$inboundSchema: z.ZodType<
  ResponseBody,
  z.ZodTypeDef,
  unknown
> = z.union([
  components.ModelConversation$inboundSchema,
  components.AgentConversation$inboundSchema,
]);

/** @internal */
export type ResponseBody$Outbound =
  | components.ModelConversation$Outbound
  | components.AgentConversation$Outbound;

/** @internal */
export const ResponseBody$outboundSchema: z.ZodType<
  ResponseBody$Outbound,
  z.ZodTypeDef,
  ResponseBody
> = z.union([
  components.ModelConversation$outboundSchema,
  components.AgentConversation$outboundSchema,
]);

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace ResponseBody$ {
  /** @deprecated use `ResponseBody$inboundSchema` instead. */
  export const inboundSchema = ResponseBody$inboundSchema;
  /** @deprecated use `ResponseBody$outboundSchema` instead. */
  export const outboundSchema = ResponseBody$outboundSchema;
  /** @deprecated use `ResponseBody$Outbound` instead. */
  export type Outbound = ResponseBody$Outbound;
}

export function responseBodyToJSON(responseBody: ResponseBody): string {
  return JSON.stringify(ResponseBody$outboundSchema.parse(responseBody));
}

export function responseBodyFromJSON(
  jsonString: string,
): SafeParseResult<ResponseBody, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) => ResponseBody$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'ResponseBody' from JSON`,
  );
}
