/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1ConversationsRestartRequest = {
  /**
   * ID of the original conversation which is being restarted.
   */
  conversationId: string;
  conversationRestartRequest: components.ConversationRestartRequest;
};

/** @internal */
export const AgentsApiV1ConversationsRestartRequest$inboundSchema: z.ZodType<
  AgentsApiV1ConversationsRestartRequest,
  z.ZodTypeDef,
  unknown
> = z.object({
  conversation_id: z.string(),
  ConversationRestartRequest:
    components.ConversationRestartRequest$inboundSchema,
}).transform((v) => {
  return remap$(v, {
    "conversation_id": "conversationId",
    "ConversationRestartRequest": "conversationRestartRequest",
  });
});

/** @internal */
export type AgentsApiV1ConversationsRestartRequest$Outbound = {
  conversation_id: string;
  ConversationRestartRequest: components.ConversationRestartRequest$Outbound;
};

/** @internal */
export const AgentsApiV1ConversationsRestartRequest$outboundSchema: z.ZodType<
  AgentsApiV1ConversationsRestartRequest$Outbound,
  z.ZodTypeDef,
  AgentsApiV1ConversationsRestartRequest
> = z.object({
  conversationId: z.string(),
  conversationRestartRequest:
    components.ConversationRestartRequest$outboundSchema,
}).transform((v) => {
  return remap$(v, {
    conversationId: "conversation_id",
    conversationRestartRequest: "ConversationRestartRequest",
  });
});

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsRestartRequest$ {
  /** @deprecated use `AgentsApiV1ConversationsRestartRequest$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1ConversationsRestartRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsRestartRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsRestartRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsRestartRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1ConversationsRestartRequest$Outbound;
}

export function agentsApiV1ConversationsRestartRequestToJSON(
  agentsApiV1ConversationsRestartRequest:
    AgentsApiV1ConversationsRestartRequest,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsRestartRequest$outboundSchema.parse(
      agentsApiV1ConversationsRestartRequest,
    ),
  );
}

export function agentsApiV1ConversationsRestartRequestFromJSON(
  jsonString: string,
): SafeParseResult<AgentsApiV1ConversationsRestartRequest, SDKValidationError> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsRestartRequest$inboundSchema.parse(JSON.parse(x)),
    `Failed to parse 'AgentsApiV1ConversationsRestartRequest' from JSON`,
  );
}
