/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */

import * as z from "zod";
import { remap as remap$ } from "../../lib/primitives.js";
import { safeParse } from "../../lib/schemas.js";
import { Result as SafeParseResult } from "../../types/fp.js";
import * as components from "../components/index.js";
import { SDKValidationError } from "../errors/sdkvalidationerror.js";

export type AgentsApiV1ConversationsRestartStreamRequest = {
  /**
   * ID of the original conversation which is being restarted.
   */
  conversationId: string;
  conversationRestartStreamRequest: components.ConversationRestartStreamRequest;
};

/** @internal */
export const AgentsApiV1ConversationsRestartStreamRequest$inboundSchema:
  z.ZodType<
    AgentsApiV1ConversationsRestartStreamRequest,
    z.ZodTypeDef,
    unknown
  > = z.object({
    conversation_id: z.string(),
    ConversationRestartStreamRequest:
      components.ConversationRestartStreamRequest$inboundSchema,
  }).transform((v) => {
    return remap$(v, {
      "conversation_id": "conversationId",
      "ConversationRestartStreamRequest": "conversationRestartStreamRequest",
    });
  });

/** @internal */
export type AgentsApiV1ConversationsRestartStreamRequest$Outbound = {
  conversation_id: string;
  ConversationRestartStreamRequest:
    components.ConversationRestartStreamRequest$Outbound;
};

/** @internal */
export const AgentsApiV1ConversationsRestartStreamRequest$outboundSchema:
  z.ZodType<
    AgentsApiV1ConversationsRestartStreamRequest$Outbound,
    z.ZodTypeDef,
    AgentsApiV1ConversationsRestartStreamRequest
  > = z.object({
    conversationId: z.string(),
    conversationRestartStreamRequest:
      components.ConversationRestartStreamRequest$outboundSchema,
  }).transform((v) => {
    return remap$(v, {
      conversationId: "conversation_id",
      conversationRestartStreamRequest: "ConversationRestartStreamRequest",
    });
  });

/**
 * @internal
 * @deprecated This namespace will be removed in future versions. Use schemas and types that are exported directly from this module.
 */
export namespace AgentsApiV1ConversationsRestartStreamRequest$ {
  /** @deprecated use `AgentsApiV1ConversationsRestartStreamRequest$inboundSchema` instead. */
  export const inboundSchema =
    AgentsApiV1ConversationsRestartStreamRequest$inboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsRestartStreamRequest$outboundSchema` instead. */
  export const outboundSchema =
    AgentsApiV1ConversationsRestartStreamRequest$outboundSchema;
  /** @deprecated use `AgentsApiV1ConversationsRestartStreamRequest$Outbound` instead. */
  export type Outbound = AgentsApiV1ConversationsRestartStreamRequest$Outbound;
}

export function agentsApiV1ConversationsRestartStreamRequestToJSON(
  agentsApiV1ConversationsRestartStreamRequest:
    AgentsApiV1ConversationsRestartStreamRequest,
): string {
  return JSON.stringify(
    AgentsApiV1ConversationsRestartStreamRequest$outboundSchema.parse(
      agentsApiV1ConversationsRestartStreamRequest,
    ),
  );
}

export function agentsApiV1ConversationsRestartStreamRequestFromJSON(
  jsonString: string,
): SafeParseResult<
  AgentsApiV1ConversationsRestartStreamRequest,
  SDKValidationError
> {
  return safeParse(
    jsonString,
    (x) =>
      AgentsApiV1ConversationsRestartStreamRequest$inboundSchema.parse(
        JSON.parse(x),
      ),
    `Failed to parse 'AgentsApiV1ConversationsRestartStreamRequest' from JSON`,
  );
}
