import type { Logger } from '@slack/logger';
import type { WebClient } from '@slack/web-api';
import type { SlackActionMiddlewareArgs } from './actions';
import type { SlackCommandMiddlewareArgs } from './command';
import type { FunctionInputs, SlackEventMiddlewareArgs } from './events';
import type { SlackOptionsMiddlewareArgs } from './options';
import type { SlackShortcutMiddlewareArgs } from './shortcuts';
import type { StringIndexed } from './utilities';
import type { SlackViewMiddlewareArgs } from './view';
export type AnyMiddlewareArgs = SlackEventMiddlewareArgs | SlackActionMiddlewareArgs | SlackCommandMiddlewareArgs | SlackOptionsMiddlewareArgs | SlackViewMiddlewareArgs | SlackShortcutMiddlewareArgs;
export interface AllMiddlewareArgs<CustomContext = StringIndexed> {
    context: Context & CustomContext;
    logger: Logger;
    client: WebClient;
    next: NextFn;
}
export type Middleware<Args, CustomContext = StringIndexed> = (args: Args & AllMiddlewareArgs<CustomContext>) => Promise<void>;
/**
 * Context object, which provides contextual information associated with an incoming requests.
 * You can set any other custom attributes in global middleware as long as the key does not conflict with others.
 */
export interface Context extends StringIndexed {
    /**
     * A bot token, which starts with `xoxb-`.
     * This value can be used by `say` (preferred over userToken),
     */
    botToken?: string;
    /**
     * A bot token, which starts with `xoxp-`.
     * This value can be used by `say` (overridden by botToken),
     */
    userToken?: string;
    /**
     * This app's bot ID in the installed workspace.
     * This is required for `ignoreSelf` global middleware.
     * see also: https://github.com/slackapi/bolt-js/issues/874
     */
    botId?: string;
    /**
     * This app's bot user ID in the installed workspace.
     * This value is optional but allows `ignoreSelf` global middleware be more filter more than just message events.
     */
    botUserId?: string;
    /**
     * User ID.
     */
    userId?: string;
    /**
     * Workspace ID.
     */
    teamId?: string;
    /**
     * Enterprise Grid Organization ID.
     */
    enterpriseId?: string;
    /**
     * Is the app installed at an Enterprise level?
     */
    isEnterpriseInstall: boolean;
    /**
     * A JIT and function-specific token that, when used to make API calls,
     * creates an association between a function's execution and subsequent actions
     * (e.g., buttons and other interactivity)
     */
    functionBotAccessToken?: string;
    /**
     * Function execution ID associated with the event
     */
    functionExecutionId?: string;
    /**
     * Inputs that were provided to a function when it was executed
     */
    functionInputs?: FunctionInputs;
    /**
     * Retry count of an Events API request (this property does not exist for other requests)
     */
    retryNum?: number;
    /**
     * Retry reason of an Events API request (this property does not exist for other requests)
     */
    retryReason?: string;
}
export declare const contextBuiltinKeys: string[];
export type NextFn = () => Promise<void>;
//# sourceMappingURL=middleware.d.ts.map