# LINE Messaging API SDK for nodejs

[![Github Action](https://github.com/line/line-bot-sdk-nodejs/actions/workflows/test.yml/badge.svg)](https://github.com/line/line-bot-sdk-nodejs/actions/workflows/test.yml)
[![npmjs](https://badge.fury.io/js/%40line%2Fbot-sdk.svg)](https://www.npmjs.com/package/@line/bot-sdk)


## Introduction
The LINE Messaging API SDK for nodejs makes it easy to develop bots using LINE Messaging API, and you can create a sample bot within minutes.

## Documentation

See the official API documentation for more information

- English: https://developers.line.biz/en/docs/messaging-api/overview/
- Japanese: https://developers.line.biz/ja/docs/messaging-api/overview/

line-bot-sdk-nodejs documentation
- https://line.github.io/line-bot-sdk-nodejs/#getting-started

## Requirements

* **Node.js** 20 or higher

## Installation

Using [npm](https://www.npmjs.com/):

``` bash
$ npm install @line/bot-sdk

$ yarn add @line/bot-sdk

$ pnpm add @line/bot-sdk
```

## Help and media
FAQ: https://developers.line.biz/en/faq/

News: https://developers.line.biz/en/news/

## Versioning

This project respects semantic versioning.
- See https://semver.org/

However, if a feature that was publicly released is discontinued for business reasons and becomes completely unusable, we will release changes as a patch release.

## Contributing

Please check [CONTRIBUTING](CONTRIBUTING.md) before making a contribution.

## License
```
Copyright (C) 2016 LINE Corp.
 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
 
   http://www.apache.org/licenses/LICENSE-2.0
 
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
