/**
 * Channel Access Token API
 * This document describes Channel Access Token API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import HTTPFetchClient, { mergeHeaders, } from "../../http-fetch.js";
export class ChannelAccessTokenClient {
    httpClient;
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = mergeHeaders(config.defaultHeaders, {});
        this.httpClient = new HTTPFetchClient({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Gets all valid channel access token key IDs.
     * @param clientAssertionType `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-all-valid-channel-access-token-key-ids-v2-1"> Documentation</a>
     */
    async getsAllValidChannelAccessTokenKeyIds(clientAssertionType, clientAssertion) {
        return (await this.getsAllValidChannelAccessTokenKeyIdsWithHttpInfo(clientAssertionType, clientAssertion)).body;
    }
    /**
     * Gets all valid channel access token key IDs..
     * This method includes HttpInfo object to return additional information.
     * @param clientAssertionType `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-all-valid-channel-access-token-key-ids-v2-1"> Documentation</a>
     */
    async getsAllValidChannelAccessTokenKeyIdsWithHttpInfo(clientAssertionType, clientAssertion) {
        const queryParams = {
            clientAssertionType: clientAssertionType,
            clientAssertion: clientAssertion,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/oauth2/v2.1/tokens/kid", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Issue short-lived channel access token
     * @param grantType `client_credentials`
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-shortlived-channel-access-token"> Documentation</a>
     */
    async issueChannelToken(grantType, clientId, clientSecret) {
        return (await this.issueChannelTokenWithHttpInfo(grantType, clientId, clientSecret)).body;
    }
    /**
     * Issue short-lived channel access token.
     * This method includes HttpInfo object to return additional information.
     * @param grantType `client_credentials`
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-shortlived-channel-access-token"> Documentation</a>
     */
    async issueChannelTokenWithHttpInfo(grantType, clientId, clientSecret) {
        const formParams = {
            grant_type: grantType,
            client_id: clientId,
            client_secret: clientSecret,
        };
        Object.keys(formParams).forEach((key) => {
            if (formParams[key] === undefined) {
                delete formParams[key];
            }
        });
        const res = await this.httpClient.postForm("/v2/oauth/accessToken", formParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Issues a channel access token that allows you to specify a desired expiration date. This method lets you use JWT assertion for authentication.
     * @param grantType client_credentials
     * @param clientAssertionType urn:ietf:params:oauth:client-assertion-type:jwt-bearer
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-channel-access-token-v2-1"> Documentation</a>
     */
    async issueChannelTokenByJWT(grantType, clientAssertionType, clientAssertion) {
        return (await this.issueChannelTokenByJWTWithHttpInfo(grantType, clientAssertionType, clientAssertion)).body;
    }
    /**
     * Issues a channel access token that allows you to specify a desired expiration date. This method lets you use JWT assertion for authentication..
     * This method includes HttpInfo object to return additional information.
     * @param grantType client_credentials
     * @param clientAssertionType urn:ietf:params:oauth:client-assertion-type:jwt-bearer
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-channel-access-token-v2-1"> Documentation</a>
     */
    async issueChannelTokenByJWTWithHttpInfo(grantType, clientAssertionType, clientAssertion) {
        const formParams = {
            grant_type: grantType,
            client_assertion_type: clientAssertionType,
            client_assertion: clientAssertion,
        };
        Object.keys(formParams).forEach((key) => {
            if (formParams[key] === undefined) {
                delete formParams[key];
            }
        });
        const res = await this.httpClient.postForm("/oauth2/v2.1/token", formParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Issues a new stateless channel access token, which doesn\'t have max active token limit unlike the other token types. The newly issued token is only valid for 15 minutes but can not be revoked until it naturally expires.
     * @param grantType `client_credentials`
     * @param clientAssertionType URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-stateless-channel-access-token"> Documentation</a>
     */
    async issueStatelessChannelToken(grantType, clientAssertionType, clientAssertion, clientId, clientSecret) {
        return (await this.issueStatelessChannelTokenWithHttpInfo(grantType, clientAssertionType, clientAssertion, clientId, clientSecret)).body;
    }
    /**
     * Issues a new stateless channel access token, which doesn\'t have max active token limit unlike the other token types. The newly issued token is only valid for 15 minutes but can not be revoked until it naturally expires. .
     * This method includes HttpInfo object to return additional information.
     * @param grantType `client_credentials`
     * @param clientAssertionType URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-stateless-channel-access-token"> Documentation</a>
     */
    async issueStatelessChannelTokenWithHttpInfo(grantType, clientAssertionType, clientAssertion, clientId, clientSecret) {
        const formParams = {
            grant_type: grantType,
            client_assertion_type: clientAssertionType,
            client_assertion: clientAssertion,
            client_id: clientId,
            client_secret: clientSecret,
        };
        Object.keys(formParams).forEach((key) => {
            if (formParams[key] === undefined) {
                delete formParams[key];
            }
        });
        const res = await this.httpClient.postForm("/oauth2/v3/token", formParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Revoke short-lived or long-lived channel access token
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-longlived-or-shortlived-channel-access-token"> Documentation</a>
     */
    async revokeChannelToken(accessToken) {
        return (await this.revokeChannelTokenWithHttpInfo(accessToken)).body;
    }
    /**
     * Revoke short-lived or long-lived channel access token.
     * This method includes HttpInfo object to return additional information.
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-longlived-or-shortlived-channel-access-token"> Documentation</a>
     */
    async revokeChannelTokenWithHttpInfo(accessToken) {
        const formParams = {
            access_token: accessToken,
        };
        Object.keys(formParams).forEach((key) => {
            if (formParams[key] === undefined) {
                delete formParams[key];
            }
        });
        const res = await this.httpClient.postForm("/v2/oauth/revoke", formParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Revoke channel access token v2.1
     * @param clientId Channel ID
     * @param clientSecret Channel Secret
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-channel-access-token-v2-1"> Documentation</a>
     */
    async revokeChannelTokenByJWT(clientId, clientSecret, accessToken) {
        return (await this.revokeChannelTokenByJWTWithHttpInfo(clientId, clientSecret, accessToken)).body;
    }
    /**
     * Revoke channel access token v2.1.
     * This method includes HttpInfo object to return additional information.
     * @param clientId Channel ID
     * @param clientSecret Channel Secret
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-channel-access-token-v2-1"> Documentation</a>
     */
    async revokeChannelTokenByJWTWithHttpInfo(clientId, clientSecret, accessToken) {
        const formParams = {
            client_id: clientId,
            client_secret: clientSecret,
            access_token: accessToken,
        };
        Object.keys(formParams).forEach((key) => {
            if (formParams[key] === undefined) {
                delete formParams[key];
            }
        });
        const res = await this.httpClient.postForm("/oauth2/v2.1/revoke", formParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Verify the validity of short-lived and long-lived channel access tokens
     * @param accessToken A short-lived or long-lived channel access token.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token"> Documentation</a>
     */
    async verifyChannelToken(accessToken) {
        return (await this.verifyChannelTokenWithHttpInfo(accessToken)).body;
    }
    /**
     * Verify the validity of short-lived and long-lived channel access tokens.
     * This method includes HttpInfo object to return additional information.
     * @param accessToken A short-lived or long-lived channel access token.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token"> Documentation</a>
     */
    async verifyChannelTokenWithHttpInfo(accessToken) {
        const formParams = {
            access_token: accessToken,
        };
        Object.keys(formParams).forEach((key) => {
            if (formParams[key] === undefined) {
                delete formParams[key];
            }
        });
        const res = await this.httpClient.postForm("/v2/oauth/verify", formParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * You can verify whether a Channel access token with a user-specified expiration (Channel Access Token v2.1) is valid.
     * @param accessToken Channel access token with a user-specified expiration (Channel Access Token v2.1).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token-v2-1"> Documentation</a>
     */
    async verifyChannelTokenByJWT(accessToken) {
        return (await this.verifyChannelTokenByJWTWithHttpInfo(accessToken)).body;
    }
    /**
     * You can verify whether a Channel access token with a user-specified expiration (Channel Access Token v2.1) is valid..
     * This method includes HttpInfo object to return additional information.
     * @param accessToken Channel access token with a user-specified expiration (Channel Access Token v2.1).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token-v2-1"> Documentation</a>
     */
    async verifyChannelTokenByJWTWithHttpInfo(accessToken) {
        const queryParams = {
            accessToken: accessToken,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/oauth2/v2.1/verify", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
//# sourceMappingURL=channelAccessTokenClient.js.map