/**
 * Channel Access Token API
 * This document describes Channel Access Token API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { ChannelAccessTokenKeyIdsResponse } from "../model/channelAccessTokenKeyIdsResponse.js";
import { IssueChannelAccessTokenResponse } from "../model/issueChannelAccessTokenResponse.js";
import { IssueShortLivedChannelAccessTokenResponse } from "../model/issueShortLivedChannelAccessTokenResponse.js";
import { IssueStatelessChannelAccessTokenResponse } from "../model/issueStatelessChannelAccessTokenResponse.js";
import { VerifyChannelAccessTokenResponse } from "../model/verifyChannelAccessTokenResponse.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    defaultHeaders?: Record<string, string>;
}
export declare class ChannelAccessTokenClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Gets all valid channel access token key IDs.
     * @param clientAssertionType `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-all-valid-channel-access-token-key-ids-v2-1"> Documentation</a>
     */
    getsAllValidChannelAccessTokenKeyIds(clientAssertionType: string, clientAssertion: string): Promise<ChannelAccessTokenKeyIdsResponse>;
    /**
     * Gets all valid channel access token key IDs..
     * This method includes HttpInfo object to return additional information.
     * @param clientAssertionType `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token (JWT) (opens new window)the client needs to create and sign with the private key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-all-valid-channel-access-token-key-ids-v2-1"> Documentation</a>
     */
    getsAllValidChannelAccessTokenKeyIdsWithHttpInfo(clientAssertionType: string, clientAssertion: string): Promise<Types.ApiResponseType<ChannelAccessTokenKeyIdsResponse>>;
    /**
     * Issue short-lived channel access token
     * @param grantType `client_credentials`
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-shortlived-channel-access-token"> Documentation</a>
     */
    issueChannelToken(grantType: string, clientId: string, clientSecret: string): Promise<IssueShortLivedChannelAccessTokenResponse>;
    /**
     * Issue short-lived channel access token.
     * This method includes HttpInfo object to return additional information.
     * @param grantType `client_credentials`
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-shortlived-channel-access-token"> Documentation</a>
     */
    issueChannelTokenWithHttpInfo(grantType: string, clientId: string, clientSecret: string): Promise<Types.ApiResponseType<IssueShortLivedChannelAccessTokenResponse>>;
    /**
     * Issues a channel access token that allows you to specify a desired expiration date. This method lets you use JWT assertion for authentication.
     * @param grantType client_credentials
     * @param clientAssertionType urn:ietf:params:oauth:client-assertion-type:jwt-bearer
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-channel-access-token-v2-1"> Documentation</a>
     */
    issueChannelTokenByJWT(grantType: string, clientAssertionType: string, clientAssertion: string): Promise<IssueChannelAccessTokenResponse>;
    /**
     * Issues a channel access token that allows you to specify a desired expiration date. This method lets you use JWT assertion for authentication..
     * This method includes HttpInfo object to return additional information.
     * @param grantType client_credentials
     * @param clientAssertionType urn:ietf:params:oauth:client-assertion-type:jwt-bearer
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-channel-access-token-v2-1"> Documentation</a>
     */
    issueChannelTokenByJWTWithHttpInfo(grantType: string, clientAssertionType: string, clientAssertion: string): Promise<Types.ApiResponseType<IssueChannelAccessTokenResponse>>;
    /**
     * Issues a new stateless channel access token, which doesn\'t have max active token limit unlike the other token types. The newly issued token is only valid for 15 minutes but can not be revoked until it naturally expires.
     * @param grantType `client_credentials`
     * @param clientAssertionType URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-stateless-channel-access-token"> Documentation</a>
     */
    issueStatelessChannelToken(grantType?: string, clientAssertionType?: string, clientAssertion?: string, clientId?: string, clientSecret?: string): Promise<IssueStatelessChannelAccessTokenResponse>;
    /**
     * Issues a new stateless channel access token, which doesn\'t have max active token limit unlike the other token types. The newly issued token is only valid for 15 minutes but can not be revoked until it naturally expires. .
     * This method includes HttpInfo object to return additional information.
     * @param grantType `client_credentials`
     * @param clientAssertionType URL-encoded value of `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`
     * @param clientAssertion A JSON Web Token the client needs to create and sign with the private key of the Assertion Signing Key.
     * @param clientId Channel ID.
     * @param clientSecret Channel secret.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-stateless-channel-access-token"> Documentation</a>
     */
    issueStatelessChannelTokenWithHttpInfo(grantType?: string, clientAssertionType?: string, clientAssertion?: string, clientId?: string, clientSecret?: string): Promise<Types.ApiResponseType<IssueStatelessChannelAccessTokenResponse>>;
    /**
     * Revoke short-lived or long-lived channel access token
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-longlived-or-shortlived-channel-access-token"> Documentation</a>
     */
    revokeChannelToken(accessToken: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Revoke short-lived or long-lived channel access token.
     * This method includes HttpInfo object to return additional information.
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-longlived-or-shortlived-channel-access-token"> Documentation</a>
     */
    revokeChannelTokenWithHttpInfo(accessToken: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Revoke channel access token v2.1
     * @param clientId Channel ID
     * @param clientSecret Channel Secret
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-channel-access-token-v2-1"> Documentation</a>
     */
    revokeChannelTokenByJWT(clientId: string, clientSecret: string, accessToken: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Revoke channel access token v2.1.
     * This method includes HttpInfo object to return additional information.
     * @param clientId Channel ID
     * @param clientSecret Channel Secret
     * @param accessToken Channel access token
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#revoke-channel-access-token-v2-1"> Documentation</a>
     */
    revokeChannelTokenByJWTWithHttpInfo(clientId: string, clientSecret: string, accessToken: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Verify the validity of short-lived and long-lived channel access tokens
     * @param accessToken A short-lived or long-lived channel access token.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token"> Documentation</a>
     */
    verifyChannelToken(accessToken: string): Promise<VerifyChannelAccessTokenResponse>;
    /**
     * Verify the validity of short-lived and long-lived channel access tokens.
     * This method includes HttpInfo object to return additional information.
     * @param accessToken A short-lived or long-lived channel access token.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token"> Documentation</a>
     */
    verifyChannelTokenWithHttpInfo(accessToken: string): Promise<Types.ApiResponseType<VerifyChannelAccessTokenResponse>>;
    /**
     * You can verify whether a Channel access token with a user-specified expiration (Channel Access Token v2.1) is valid.
     * @param accessToken Channel access token with a user-specified expiration (Channel Access Token v2.1).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token-v2-1"> Documentation</a>
     */
    verifyChannelTokenByJWT(accessToken: string): Promise<VerifyChannelAccessTokenResponse>;
    /**
     * You can verify whether a Channel access token with a user-specified expiration (Channel Access Token v2.1) is valid..
     * This method includes HttpInfo object to return additional information.
     * @param accessToken Channel access token with a user-specified expiration (Channel Access Token v2.1).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-channel-access-token-v2-1"> Documentation</a>
     */
    verifyChannelTokenByJWTWithHttpInfo(accessToken: string): Promise<Types.ApiResponseType<VerifyChannelAccessTokenResponse>>;
}
export {};
//# sourceMappingURL=channelAccessTokenClient.d.ts.map