"use strict";
/**
 * LINE Messaging API(Insight)
 * This document describes LINE Messaging API(Insight).
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsightClient = void 0;
const http_fetch_js_1 = require("../../http-fetch.js");
class InsightClient {
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = (0, http_fetch_js_1.mergeHeaders)(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new http_fetch_js_1.default({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Retrieves the demographic attributes for a LINE Official Account\'s friends.You can only retrieve information about friends for LINE Official Accounts created by users in Japan (JP), Thailand (TH), Taiwan (TW) and Indonesia (ID).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-demographic"> Documentation</a>
     */
    async getFriendsDemographics() {
        return (await this.getFriendsDemographicsWithHttpInfo()).body;
    }
    /**
     * Retrieves the demographic attributes for a LINE Official Account\'s friends.You can only retrieve information about friends for LINE Official Accounts created by users in Japan (JP), Thailand (TH), Taiwan (TW) and Indonesia (ID). .
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-demographic"> Documentation</a>
     */
    async getFriendsDemographicsWithHttpInfo() {
        const res = await this.httpClient.get("/v2/bot/insight/demographic");
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Returns statistics about how users interact with narrowcast messages or broadcast messages sent from your LINE Official Account.
     * @summary Get user interaction statistics
     * @param requestId Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-message-event">Get user interaction statistics Documentation</a>
     */
    async getMessageEvent(requestId) {
        return (await this.getMessageEventWithHttpInfo(requestId)).body;
    }
    /**
     * Returns statistics about how users interact with narrowcast messages or broadcast messages sent from your LINE Official Account. .
     * This method includes HttpInfo object to return additional information.
     * @summary Get user interaction statistics
     * @param requestId Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-message-event">Get user interaction statistics Documentation</a>
     */
    async getMessageEventWithHttpInfo(requestId) {
        const queryParams = {
            requestId: requestId,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/insight/message/event", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Returns the number of users who have added the LINE Official Account on or before a specified date.
     * @summary Get number of followers
     * @param date Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-followers">Get number of followers Documentation</a>
     */
    async getNumberOfFollowers(date) {
        return (await this.getNumberOfFollowersWithHttpInfo(date)).body;
    }
    /**
     * Returns the number of users who have added the LINE Official Account on or before a specified date. .
     * This method includes HttpInfo object to return additional information.
     * @summary Get number of followers
     * @param date Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-followers">Get number of followers Documentation</a>
     */
    async getNumberOfFollowersWithHttpInfo(date) {
        const queryParams = {
            date: date,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/insight/followers", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Returns the number of messages sent from LINE Official Account on a specified day.
     * @summary Get number of message deliveries
     * @param date Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-delivery-messages">Get number of message deliveries Documentation</a>
     */
    async getNumberOfMessageDeliveries(date) {
        return (await this.getNumberOfMessageDeliveriesWithHttpInfo(date)).body;
    }
    /**
     * Returns the number of messages sent from LINE Official Account on a specified day. .
     * This method includes HttpInfo object to return additional information.
     * @summary Get number of message deliveries
     * @param date Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-delivery-messages">Get number of message deliveries Documentation</a>
     */
    async getNumberOfMessageDeliveriesWithHttpInfo(date) {
        const queryParams = {
            date: date,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/insight/message/delivery", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * You can check the per-unit statistics of how users interact with push messages and multicast messages sent from your LINE Official Account.
     * @param customAggregationUnit Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names.
     * @param from Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     * @param to End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-statistics-per-unit"> Documentation</a>
     */
    async getStatisticsPerUnit(customAggregationUnit, from, to) {
        return (await this.getStatisticsPerUnitWithHttpInfo(customAggregationUnit, from, to)).body;
    }
    /**
     * You can check the per-unit statistics of how users interact with push messages and multicast messages sent from your LINE Official Account. .
     * This method includes HttpInfo object to return additional information.
     * @param customAggregationUnit Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names.
     * @param from Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     * @param to End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-statistics-per-unit"> Documentation</a>
     */
    async getStatisticsPerUnitWithHttpInfo(customAggregationUnit, from, to) {
        const queryParams = {
            customAggregationUnit: customAggregationUnit,
            from: from,
            to: to,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/insight/message/event/aggregation", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
exports.InsightClient = InsightClient;
//# sourceMappingURL=insightClient.js.map