/**
 * LIFF server API
 * LIFF Server API.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { AddLiffAppRequest } from "../model/addLiffAppRequest.js";
import { AddLiffAppResponse } from "../model/addLiffAppResponse.js";
import { GetAllLiffAppsResponse } from "../model/getAllLiffAppsResponse.js";
import { UpdateLiffAppRequest } from "../model/updateLiffAppRequest.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class LiffClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Adding the LIFF app to a channel
     * @summary Create LIFF app
     * @param addLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#add-liff-app">Create LIFF app Documentation</a>
     */
    addLIFFApp(addLiffAppRequest: AddLiffAppRequest): Promise<AddLiffAppResponse>;
    /**
     * Adding the LIFF app to a channel.
     * This method includes HttpInfo object to return additional information.
     * @summary Create LIFF app
     * @param addLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#add-liff-app">Create LIFF app Documentation</a>
     */
    addLIFFAppWithHttpInfo(addLiffAppRequest: AddLiffAppRequest): Promise<Types.ApiResponseType<AddLiffAppResponse>>;
    /**
     * Deletes a LIFF app from a channel.
     * @summary Delete LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#delete-liff-app">Delete LIFF app from a channel Documentation</a>
     */
    deleteLIFFApp(liffId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Deletes a LIFF app from a channel. .
     * This method includes HttpInfo object to return additional information.
     * @summary Delete LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#delete-liff-app">Delete LIFF app from a channel Documentation</a>
     */
    deleteLIFFAppWithHttpInfo(liffId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Gets information on all the LIFF apps added to the channel.
     * @summary Get all LIFF apps
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#get-all-liff-apps">Get all LIFF apps Documentation</a>
     */
    getAllLIFFApps(): Promise<GetAllLiffAppsResponse>;
    /**
     * Gets information on all the LIFF apps added to the channel..
     * This method includes HttpInfo object to return additional information.
     * @summary Get all LIFF apps
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#get-all-liff-apps">Get all LIFF apps Documentation</a>
     */
    getAllLIFFAppsWithHttpInfo(): Promise<Types.ApiResponseType<GetAllLiffAppsResponse>>;
    /**
     * Update LIFF app settings
     * @summary Update LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     * @param updateLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#update-liff-app">Update LIFF app from a channel Documentation</a>
     */
    updateLIFFApp(liffId: string, updateLiffAppRequest: UpdateLiffAppRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Update LIFF app settings.
     * This method includes HttpInfo object to return additional information.
     * @summary Update LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     * @param updateLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#update-liff-app">Update LIFF app from a channel Documentation</a>
     */
    updateLIFFAppWithHttpInfo(liffId: string, updateLiffAppRequest: UpdateLiffAppRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
}
export {};
//# sourceMappingURL=liffClient.d.ts.map