/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { CreateAudienceGroupResponse } from "../model/createAudienceGroupResponse.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class ManageAudienceBlobClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by file).
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param audienceGroupId The audience ID.
     * @param uploadDescription The description to register with the job
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group-by-file"> Documentation</a>
     */
    addUserIdsToAudience(file: Blob, audienceGroupId?: number, uploadDescription?: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by file)..
     * This method includes HttpInfo object to return additional information.
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param audienceGroupId The audience ID.
     * @param uploadDescription The description to register with the job
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group-by-file"> Documentation</a>
     */
    addUserIdsToAudienceWithHttpInfo(file: Blob, audienceGroupId?: number, uploadDescription?: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Create audience for uploading user IDs (by file).
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param description The audience\\\'s name. This is case-insensitive, meaning AUDIENCE and audience are considered identical. Max character limit: 120
     * @param isIfaAudience To specify recipients by IFAs: set `true`. To specify recipients by user IDs: set `false` or omit isIfaAudience property.
     * @param uploadDescription The description to register for the job (in `jobs[].description`).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group-by-file"> Documentation</a>
     */
    createAudienceForUploadingUserIds(file: Blob, description?: string, isIfaAudience?: boolean, uploadDescription?: string): Promise<CreateAudienceGroupResponse>;
    /**
     * Create audience for uploading user IDs (by file)..
     * This method includes HttpInfo object to return additional information.
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param description The audience\\\'s name. This is case-insensitive, meaning AUDIENCE and audience are considered identical. Max character limit: 120
     * @param isIfaAudience To specify recipients by IFAs: set `true`. To specify recipients by user IDs: set `false` or omit isIfaAudience property.
     * @param uploadDescription The description to register for the job (in `jobs[].description`).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group-by-file"> Documentation</a>
     */
    createAudienceForUploadingUserIdsWithHttpInfo(file: Blob, description?: string, isIfaAudience?: boolean, uploadDescription?: string): Promise<Types.ApiResponseType<CreateAudienceGroupResponse>>;
}
export {};
//# sourceMappingURL=manageAudienceBlobClient.d.ts.map