"use strict";
/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingApiBlobClient = void 0;
const http_fetch_js_1 = require("../../http-fetch.js");
class MessagingApiBlobClient {
    constructor(config) {
        const baseURL = config.baseURL || "https://api-data.line.me";
        const defaultHeaders = (0, http_fetch_js_1.mergeHeaders)(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new http_fetch_js_1.default({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Download image, video, and audio data sent from users.
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-content"> Documentation</a>
     */
    async getMessageContent(messageId) {
        return (await this.getMessageContentWithHttpInfo(messageId)).body;
    }
    /**
     * Download image, video, and audio data sent from users..
     * This method includes HttpInfo object to return additional information.
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-content"> Documentation</a>
     */
    async getMessageContentWithHttpInfo(messageId) {
        const response = await this.httpClient.get("/v2/bot/message/{messageId}/content".replace("{" + "messageId" + "}", String(messageId)));
        return {
            httpResponse: response,
            body: (0, http_fetch_js_1.convertResponseToReadable)(response),
        };
    }
    /**
     * Get a preview image of the image or video
     * @param messageId Message ID of image or video
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-image-or-video-preview"> Documentation</a>
     */
    async getMessageContentPreview(messageId) {
        return (await this.getMessageContentPreviewWithHttpInfo(messageId)).body;
    }
    /**
     * Get a preview image of the image or video.
     * This method includes HttpInfo object to return additional information.
     * @param messageId Message ID of image or video
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-image-or-video-preview"> Documentation</a>
     */
    async getMessageContentPreviewWithHttpInfo(messageId) {
        const response = await this.httpClient.get("/v2/bot/message/{messageId}/content/preview".replace("{" + "messageId" + "}", String(messageId)));
        return {
            httpResponse: response,
            body: (0, http_fetch_js_1.convertResponseToReadable)(response),
        };
    }
    /**
     * Verify the preparation status of a video or audio for getting
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-video-or-audio-preparation-status"> Documentation</a>
     */
    async getMessageContentTranscodingByMessageId(messageId) {
        return (await this.getMessageContentTranscodingByMessageIdWithHttpInfo(messageId)).body;
    }
    /**
     * Verify the preparation status of a video or audio for getting.
     * This method includes HttpInfo object to return additional information.
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-video-or-audio-preparation-status"> Documentation</a>
     */
    async getMessageContentTranscodingByMessageIdWithHttpInfo(messageId) {
        const res = await this.httpClient.get("/v2/bot/message/{messageId}/content/transcoding".replace("{messageId}", String(messageId)));
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Download rich menu image.
     * @param richMenuId ID of the rich menu with the image to be downloaded
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#download-rich-menu-image"> Documentation</a>
     */
    async getRichMenuImage(richMenuId) {
        return (await this.getRichMenuImageWithHttpInfo(richMenuId)).body;
    }
    /**
     * Download rich menu image..
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId ID of the rich menu with the image to be downloaded
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#download-rich-menu-image"> Documentation</a>
     */
    async getRichMenuImageWithHttpInfo(richMenuId) {
        const response = await this.httpClient.get("/v2/bot/richmenu/{richMenuId}/content".replace("{" + "richMenuId" + "}", String(richMenuId)));
        return {
            httpResponse: response,
            body: (0, http_fetch_js_1.convertResponseToReadable)(response),
        };
    }
    /**
     * Upload rich menu image
     * @param richMenuId The ID of the rich menu to attach the image to
     * @param body
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#upload-rich-menu-image"> Documentation</a>
     */
    async setRichMenuImage(richMenuId, body) {
        return (await this.setRichMenuImageWithHttpInfo(richMenuId, body)).body;
    }
    /**
     * Upload rich menu image.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId The ID of the rich menu to attach the image to
     * @param body
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#upload-rich-menu-image"> Documentation</a>
     */
    async setRichMenuImageWithHttpInfo(richMenuId, body) {
        const params = body;
        const res = await this.httpClient.postBinaryContent("/v2/bot/richmenu/{richMenuId}/content".replace("{richMenuId}", String(richMenuId)), params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
exports.MessagingApiBlobClient = MessagingApiBlobClient;
//# sourceMappingURL=messagingApiBlobClient.js.map