/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { AcquisitionConditionRequest } from "./acquisitionConditionRequest.js";
import { CouponRewardRequest } from "./couponRewardRequest.js";
/**
 * Request object for creating a coupon. Contains all configurable coupon properties.
 */
export type CouponCreateRequest = {
    /**
     */
    acquisitionCondition: AcquisitionConditionRequest;
    /**
     * URL of the barcode image associated with the coupon. Used for in-store redemption.
     */
    barcodeImageUrl?: string;
    /**
     * Unique code to be presented by the user to redeem the coupon. Optional.
     */
    couponCode?: string;
    /**
     * Detailed description of the coupon. Displayed to users.
     */
    description?: string;
    /**
     * Coupon expiration time (epoch seconds). Coupon cannot be used after this time.
     */
    endTimestamp: number;
    /**
     * URL of the main image representing the coupon. Displayed in the coupon list.
     */
    imageUrl?: string;
    /**
     * Maximum number of times a single coupon ticket can be used. Use -1 to indicate no limit.
     */
    maxUseCountPerTicket: number;
    /**
     * Coupon start time (epoch seconds). Coupon can be used from this time.
     */
    startTimestamp: number;
    /**
     * Title of the coupon. Displayed in the coupon list.
     */
    title: string;
    /**
     * Conditions for using the coupon. Shown to users.
     */
    usageCondition?: string;
    /**
     */
    reward?: CouponRewardRequest;
    /**
     * Visibility of the coupon. Determines who can see or acquire the coupon.
     */
    visibility: CouponCreateRequest.VisibilityEnum;
    /**
     * Timezone for interpreting start and end timestamps.
     */
    timezone: CouponCreateRequest.TimezoneEnum;
};
export declare namespace CouponCreateRequest {
    type VisibilityEnum = "UNLISTED" | "PUBLIC";
    type TimezoneEnum = "ETC_GMT_MINUS_12" | "ETC_GMT_MINUS_11" | "PACIFIC_HONOLULU" | "AMERICA_ANCHORAGE" | "AMERICA_LOS_ANGELES" | "AMERICA_PHOENIX" | "AMERICA_CHICAGO" | "AMERICA_NEW_YORK" | "AMERICA_CARACAS" | "AMERICA_SANTIAGO" | "AMERICA_ST_JOHNS" | "AMERICA_SAO_PAULO" | "ETC_GMT_MINUS_2" | "ATLANTIC_CAPE_VERDE" | "EUROPE_LONDON" | "EUROPE_PARIS" | "EUROPE_ISTANBUL" | "EUROPE_MOSCOW" | "ASIA_TEHRAN" | "ASIA_TBILISI" | "ASIA_KABUL" | "ASIA_TASHKENT" | "ASIA_COLOMBO" | "ASIA_KATHMANDU" | "ASIA_ALMATY" | "ASIA_RANGOON" | "ASIA_BANGKOK" | "ASIA_TAIPEI" | "ASIA_TOKYO" | "AUSTRALIA_DARWIN" | "AUSTRALIA_SYDNEY" | "ASIA_VLADIVOSTOK" | "ETC_GMT_PLUS_12" | "PACIFIC_TONGATAPU";
}
//# sourceMappingURL=couponCreateRequest.d.ts.map