"use strict";
/**
 * Mission Stickers API
 * This document describes LINE Mission Stickers API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShopClient = void 0;
const http_fetch_js_1 = require("../../http-fetch.js");
class ShopClient {
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = (0, http_fetch_js_1.mergeHeaders)(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new http_fetch_js_1.default({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Sends a mission sticker.
     * @param missionStickerRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3"> Documentation</a>
     */
    async missionStickerV3(missionStickerRequest) {
        return (await this.missionStickerV3WithHttpInfo(missionStickerRequest))
            .body;
    }
    /**
     * Sends a mission sticker..
     * This method includes HttpInfo object to return additional information.
     * @param missionStickerRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-mission-stickers-v3"> Documentation</a>
     */
    async missionStickerV3WithHttpInfo(missionStickerRequest) {
        const params = missionStickerRequest;
        const res = await this.httpClient.post("/shop/v3/mission", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
exports.ShopClient = ShopClient;
//# sourceMappingURL=shopClient.js.map