/**
 * LINE Messaging API(Insight)
 * This document describes LINE Messaging API(Insight).
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { GetFriendsDemographicsResponse } from "../model/getFriendsDemographicsResponse.js";
import { GetMessageEventResponse } from "../model/getMessageEventResponse.js";
import { GetNumberOfFollowersResponse } from "../model/getNumberOfFollowersResponse.js";
import { GetNumberOfMessageDeliveriesResponse } from "../model/getNumberOfMessageDeliveriesResponse.js";
import { GetStatisticsPerUnitResponse } from "../model/getStatisticsPerUnitResponse.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class InsightClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Retrieves the demographic attributes for a LINE Official Account\'s friends.You can only retrieve information about friends for LINE Official Accounts created by users in Japan (JP), Thailand (TH), Taiwan (TW) and Indonesia (ID).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-demographic"> Documentation</a>
     */
    getFriendsDemographics(): Promise<GetFriendsDemographicsResponse>;
    /**
     * Retrieves the demographic attributes for a LINE Official Account\'s friends.You can only retrieve information about friends for LINE Official Accounts created by users in Japan (JP), Thailand (TH), Taiwan (TW) and Indonesia (ID). .
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-demographic"> Documentation</a>
     */
    getFriendsDemographicsWithHttpInfo(): Promise<Types.ApiResponseType<GetFriendsDemographicsResponse>>;
    /**
     * Returns statistics about how users interact with narrowcast messages or broadcast messages sent from your LINE Official Account.
     * @summary Get user interaction statistics
     * @param requestId Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-message-event">Get user interaction statistics Documentation</a>
     */
    getMessageEvent(requestId: string): Promise<GetMessageEventResponse>;
    /**
     * Returns statistics about how users interact with narrowcast messages or broadcast messages sent from your LINE Official Account. .
     * This method includes HttpInfo object to return additional information.
     * @summary Get user interaction statistics
     * @param requestId Request ID of a narrowcast message or broadcast message. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-message-event">Get user interaction statistics Documentation</a>
     */
    getMessageEventWithHttpInfo(requestId: string): Promise<Types.ApiResponseType<GetMessageEventResponse>>;
    /**
     * Returns the number of users who have added the LINE Official Account on or before a specified date.
     * @summary Get number of followers
     * @param date Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-followers">Get number of followers Documentation</a>
     */
    getNumberOfFollowers(date?: string): Promise<GetNumberOfFollowersResponse>;
    /**
     * Returns the number of users who have added the LINE Official Account on or before a specified date. .
     * This method includes HttpInfo object to return additional information.
     * @summary Get number of followers
     * @param date Date for which to retrieve the number of followers.  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-followers">Get number of followers Documentation</a>
     */
    getNumberOfFollowersWithHttpInfo(date?: string): Promise<Types.ApiResponseType<GetNumberOfFollowersResponse>>;
    /**
     * Returns the number of messages sent from LINE Official Account on a specified day.
     * @summary Get number of message deliveries
     * @param date Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-delivery-messages">Get number of message deliveries Documentation</a>
     */
    getNumberOfMessageDeliveries(date: string): Promise<GetNumberOfMessageDeliveriesResponse>;
    /**
     * Returns the number of messages sent from LINE Official Account on a specified day. .
     * This method includes HttpInfo object to return additional information.
     * @summary Get number of message deliveries
     * @param date Date for which to retrieve number of sent messages. - Format: yyyyMMdd (e.g. 20191231) - Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-delivery-messages">Get number of message deliveries Documentation</a>
     */
    getNumberOfMessageDeliveriesWithHttpInfo(date: string): Promise<Types.ApiResponseType<GetNumberOfMessageDeliveriesResponse>>;
    /**
     * You can check the per-unit statistics of how users interact with push messages and multicast messages sent from your LINE Official Account.
     * @param customAggregationUnit Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names.
     * @param from Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     * @param to End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-statistics-per-unit"> Documentation</a>
     */
    getStatisticsPerUnit(customAggregationUnit: string, from: string, to: string): Promise<GetStatisticsPerUnitResponse>;
    /**
     * You can check the per-unit statistics of how users interact with push messages and multicast messages sent from your LINE Official Account. .
     * This method includes HttpInfo object to return additional information.
     * @param customAggregationUnit Name of aggregation unit specified when sending the message. Case-sensitive. For example, `Promotion_a` and `Promotion_A` are regarded as different unit names.
     * @param from Start date of aggregation period.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     * @param to End date of aggregation period. The end date can be specified for up to 30 days later. For example, if the start date is 20210301, the latest end date is 20210331.  Format: yyyyMMdd (e.g. 20210301) Time zone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-statistics-per-unit"> Documentation</a>
     */
    getStatisticsPerUnitWithHttpInfo(customAggregationUnit: string, from: string, to: string): Promise<Types.ApiResponseType<GetStatisticsPerUnitResponse>>;
}
export {};
//# sourceMappingURL=insightClient.d.ts.map