/**
 * LIFF server API
 * LIFF Server API.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import HTTPFetchClient, { mergeHeaders, } from "../../http-fetch.js";
export class LiffClient {
    httpClient;
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = mergeHeaders(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new HTTPFetchClient({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Adding the LIFF app to a channel
     * @summary Create LIFF app
     * @param addLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#add-liff-app">Create LIFF app Documentation</a>
     */
    async addLIFFApp(addLiffAppRequest) {
        return (await this.addLIFFAppWithHttpInfo(addLiffAppRequest)).body;
    }
    /**
     * Adding the LIFF app to a channel.
     * This method includes HttpInfo object to return additional information.
     * @summary Create LIFF app
     * @param addLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#add-liff-app">Create LIFF app Documentation</a>
     */
    async addLIFFAppWithHttpInfo(addLiffAppRequest) {
        const params = addLiffAppRequest;
        const res = await this.httpClient.post("/liff/v1/apps", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Deletes a LIFF app from a channel.
     * @summary Delete LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#delete-liff-app">Delete LIFF app from a channel Documentation</a>
     */
    async deleteLIFFApp(liffId) {
        return (await this.deleteLIFFAppWithHttpInfo(liffId)).body;
    }
    /**
     * Deletes a LIFF app from a channel. .
     * This method includes HttpInfo object to return additional information.
     * @summary Delete LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#delete-liff-app">Delete LIFF app from a channel Documentation</a>
     */
    async deleteLIFFAppWithHttpInfo(liffId) {
        const res = await this.httpClient.delete("/liff/v1/apps/{liffId}".replace("{liffId}", String(liffId)));
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Gets information on all the LIFF apps added to the channel.
     * @summary Get all LIFF apps
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#get-all-liff-apps">Get all LIFF apps Documentation</a>
     */
    async getAllLIFFApps() {
        return (await this.getAllLIFFAppsWithHttpInfo()).body;
    }
    /**
     * Gets information on all the LIFF apps added to the channel..
     * This method includes HttpInfo object to return additional information.
     * @summary Get all LIFF apps
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#get-all-liff-apps">Get all LIFF apps Documentation</a>
     */
    async getAllLIFFAppsWithHttpInfo() {
        const res = await this.httpClient.get("/liff/v1/apps");
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Update LIFF app settings
     * @summary Update LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     * @param updateLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#update-liff-app">Update LIFF app from a channel Documentation</a>
     */
    async updateLIFFApp(liffId, updateLiffAppRequest) {
        return (await this.updateLIFFAppWithHttpInfo(liffId, updateLiffAppRequest))
            .body;
    }
    /**
     * Update LIFF app settings.
     * This method includes HttpInfo object to return additional information.
     * @summary Update LIFF app from a channel
     * @param liffId ID of the LIFF app to be updated
     * @param updateLiffAppRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/liff-server/#update-liff-app">Update LIFF app from a channel Documentation</a>
     */
    async updateLIFFAppWithHttpInfo(liffId, updateLiffAppRequest) {
        const params = updateLiffAppRequest;
        const res = await this.httpClient.put("/liff/v1/apps/{liffId}".replace("{liffId}", String(liffId)), params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
//# sourceMappingURL=liffClient.js.map