/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import HTTPFetchClient, { mergeHeaders, } from "../../http-fetch.js";
export class ManageAudienceBlobClient {
    httpClient;
    constructor(config) {
        const baseURL = config.baseURL || "https://api-data.line.me";
        const defaultHeaders = mergeHeaders(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new HTTPFetchClient({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by file).
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param audienceGroupId The audience ID.
     * @param uploadDescription The description to register with the job
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group-by-file"> Documentation</a>
     */
    async addUserIdsToAudience(file, audienceGroupId, uploadDescription) {
        return (await this.addUserIdsToAudienceWithHttpInfo(file, audienceGroupId, uploadDescription)).body;
    }
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by file)..
     * This method includes HttpInfo object to return additional information.
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param audienceGroupId The audience ID.
     * @param uploadDescription The description to register with the job
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group-by-file"> Documentation</a>
     */
    async addUserIdsToAudienceWithHttpInfo(file, audienceGroupId, uploadDescription) {
        const form = new FormData();
        form.append("audienceGroupId", String(audienceGroupId));
        form.append("uploadDescription", String(uploadDescription));
        form.append("file", file); // file
        const res = await this.httpClient.putFormMultipart("/v2/bot/audienceGroup/upload/byFile", form);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Create audience for uploading user IDs (by file).
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param description The audience\\\'s name. This is case-insensitive, meaning AUDIENCE and audience are considered identical. Max character limit: 120
     * @param isIfaAudience To specify recipients by IFAs: set `true`. To specify recipients by user IDs: set `false` or omit isIfaAudience property.
     * @param uploadDescription The description to register for the job (in `jobs[].description`).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group-by-file"> Documentation</a>
     */
    async createAudienceForUploadingUserIds(file, description, isIfaAudience, uploadDescription) {
        return (await this.createAudienceForUploadingUserIdsWithHttpInfo(file, description, isIfaAudience, uploadDescription)).body;
    }
    /**
     * Create audience for uploading user IDs (by file)..
     * This method includes HttpInfo object to return additional information.
     * @param file A text file with one user ID or IFA entered per line. Specify text/plain as Content-Type. Max file number: 1 Max number: 1,500,000
     * @param description The audience\\\'s name. This is case-insensitive, meaning AUDIENCE and audience are considered identical. Max character limit: 120
     * @param isIfaAudience To specify recipients by IFAs: set `true`. To specify recipients by user IDs: set `false` or omit isIfaAudience property.
     * @param uploadDescription The description to register for the job (in `jobs[].description`).
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group-by-file"> Documentation</a>
     */
    async createAudienceForUploadingUserIdsWithHttpInfo(file, description, isIfaAudience, uploadDescription) {
        const form = new FormData();
        form.append("description", String(description));
        form.append("isIfaAudience", String(isIfaAudience));
        form.append("uploadDescription", String(uploadDescription));
        form.append("file", file); // file
        const res = await this.httpClient.postFormMultipart("/v2/bot/audienceGroup/upload/byFile", form);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
//# sourceMappingURL=manageAudienceBlobClient.js.map