/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { AddAudienceToAudienceGroupRequest } from "../model/addAudienceToAudienceGroupRequest.js";
import { AudienceGroupCreateRoute } from "../model/audienceGroupCreateRoute.js";
import { AudienceGroupStatus } from "../model/audienceGroupStatus.js";
import { CreateAudienceGroupRequest } from "../model/createAudienceGroupRequest.js";
import { CreateAudienceGroupResponse } from "../model/createAudienceGroupResponse.js";
import { CreateClickBasedAudienceGroupRequest } from "../model/createClickBasedAudienceGroupRequest.js";
import { CreateClickBasedAudienceGroupResponse } from "../model/createClickBasedAudienceGroupResponse.js";
import { CreateImpBasedAudienceGroupRequest } from "../model/createImpBasedAudienceGroupRequest.js";
import { CreateImpBasedAudienceGroupResponse } from "../model/createImpBasedAudienceGroupResponse.js";
import { GetAudienceDataResponse } from "../model/getAudienceDataResponse.js";
import { GetAudienceGroupsResponse } from "../model/getAudienceGroupsResponse.js";
import { GetSharedAudienceDataResponse } from "../model/getSharedAudienceDataResponse.js";
import { GetSharedAudienceGroupsResponse } from "../model/getSharedAudienceGroupsResponse.js";
import { UpdateAudienceGroupDescriptionRequest } from "../model/updateAudienceGroupDescriptionRequest.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class ManageAudienceClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by JSON)
     * @param addAudienceToAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group"> Documentation</a>
     */
    addAudienceToAudienceGroup(addAudienceToAudienceGroupRequest: AddAudienceToAudienceGroupRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by JSON).
     * This method includes HttpInfo object to return additional information.
     * @param addAudienceToAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group"> Documentation</a>
     */
    addAudienceToAudienceGroupWithHttpInfo(addAudienceToAudienceGroupRequest: AddAudienceToAudienceGroupRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Create audience for uploading user IDs (by JSON)
     * @param createAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group"> Documentation</a>
     */
    createAudienceGroup(createAudienceGroupRequest: CreateAudienceGroupRequest): Promise<CreateAudienceGroupResponse>;
    /**
     * Create audience for uploading user IDs (by JSON).
     * This method includes HttpInfo object to return additional information.
     * @param createAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group"> Documentation</a>
     */
    createAudienceGroupWithHttpInfo(createAudienceGroupRequest: CreateAudienceGroupRequest): Promise<Types.ApiResponseType<CreateAudienceGroupResponse>>;
    /**
     * Create audience for click-based retargeting
     * @param createClickBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-click-audience-group"> Documentation</a>
     */
    createClickBasedAudienceGroup(createClickBasedAudienceGroupRequest: CreateClickBasedAudienceGroupRequest): Promise<CreateClickBasedAudienceGroupResponse>;
    /**
     * Create audience for click-based retargeting.
     * This method includes HttpInfo object to return additional information.
     * @param createClickBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-click-audience-group"> Documentation</a>
     */
    createClickBasedAudienceGroupWithHttpInfo(createClickBasedAudienceGroupRequest: CreateClickBasedAudienceGroupRequest): Promise<Types.ApiResponseType<CreateClickBasedAudienceGroupResponse>>;
    /**
     * Create audience for impression-based retargeting
     * @param createImpBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-imp-audience-group"> Documentation</a>
     */
    createImpBasedAudienceGroup(createImpBasedAudienceGroupRequest: CreateImpBasedAudienceGroupRequest): Promise<CreateImpBasedAudienceGroupResponse>;
    /**
     * Create audience for impression-based retargeting.
     * This method includes HttpInfo object to return additional information.
     * @param createImpBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-imp-audience-group"> Documentation</a>
     */
    createImpBasedAudienceGroupWithHttpInfo(createImpBasedAudienceGroupRequest: CreateImpBasedAudienceGroupRequest): Promise<Types.ApiResponseType<CreateImpBasedAudienceGroupResponse>>;
    /**
     * Delete audience
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-audience-group"> Documentation</a>
     */
    deleteAudienceGroup(audienceGroupId: number): Promise<Types.MessageAPIResponseBase>;
    /**
     * Delete audience.
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-audience-group"> Documentation</a>
     */
    deleteAudienceGroupWithHttpInfo(audienceGroupId: number): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Gets audience data.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-group"> Documentation</a>
     */
    getAudienceData(audienceGroupId: number): Promise<GetAudienceDataResponse>;
    /**
     * Gets audience data..
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-group"> Documentation</a>
     */
    getAudienceDataWithHttpInfo(audienceGroupId: number): Promise<Types.ApiResponseType<GetAudienceDataResponse>>;
    /**
     * Gets data for more than one audience.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param includesExternalPublicGroups true (default): Get public audiences created in all channels linked to the same bot. false: Get audiences created in the same channel.
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-groups"> Documentation</a>
     */
    getAudienceGroups(page: number, description?: string, status?: AudienceGroupStatus, size?: number, includesExternalPublicGroups?: boolean, createRoute?: AudienceGroupCreateRoute): Promise<GetAudienceGroupsResponse>;
    /**
     * Gets data for more than one audience..
     * This method includes HttpInfo object to return additional information.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param includesExternalPublicGroups true (default): Get public audiences created in all channels linked to the same bot. false: Get audiences created in the same channel.
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-groups"> Documentation</a>
     */
    getAudienceGroupsWithHttpInfo(page: number, description?: string, status?: AudienceGroupStatus, size?: number, includesExternalPublicGroups?: boolean, createRoute?: AudienceGroupCreateRoute): Promise<Types.ApiResponseType<GetAudienceGroupsResponse>>;
    /**
     * Gets audience data.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience"> Documentation</a>
     */
    getSharedAudienceData(audienceGroupId: number): Promise<GetSharedAudienceDataResponse>;
    /**
     * Gets audience data..
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience"> Documentation</a>
     */
    getSharedAudienceDataWithHttpInfo(audienceGroupId: number): Promise<Types.ApiResponseType<GetSharedAudienceDataResponse>>;
    /**
     * Gets data for more than one audience, including those shared by the Business Manager.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     * @param includesOwnedAudienceGroups true: Include audienceGroups owned by LINE Official Account Manager false: Respond only audienceGroups shared by Business Manager
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience-list"> Documentation</a>
     */
    getSharedAudienceGroups(page: number, description?: string, status?: AudienceGroupStatus, size?: number, createRoute?: AudienceGroupCreateRoute, includesOwnedAudienceGroups?: boolean): Promise<GetSharedAudienceGroupsResponse>;
    /**
     * Gets data for more than one audience, including those shared by the Business Manager..
     * This method includes HttpInfo object to return additional information.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     * @param includesOwnedAudienceGroups true: Include audienceGroups owned by LINE Official Account Manager false: Respond only audienceGroups shared by Business Manager
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience-list"> Documentation</a>
     */
    getSharedAudienceGroupsWithHttpInfo(page: number, description?: string, status?: AudienceGroupStatus, size?: number, createRoute?: AudienceGroupCreateRoute, includesOwnedAudienceGroups?: boolean): Promise<Types.ApiResponseType<GetSharedAudienceGroupsResponse>>;
    /**
     * Renames an existing audience.
     * @param audienceGroupId The audience ID.
     * @param updateAudienceGroupDescriptionRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-description-audience-group"> Documentation</a>
     */
    updateAudienceGroupDescription(audienceGroupId: number, updateAudienceGroupDescriptionRequest: UpdateAudienceGroupDescriptionRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Renames an existing audience..
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     * @param updateAudienceGroupDescriptionRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-description-audience-group"> Documentation</a>
     */
    updateAudienceGroupDescriptionWithHttpInfo(audienceGroupId: number, updateAudienceGroupDescriptionRequest: UpdateAudienceGroupDescriptionRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
}
export {};
//# sourceMappingURL=manageAudienceClient.d.ts.map