/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import HTTPFetchClient, { mergeHeaders, } from "../../http-fetch.js";
export class ManageAudienceClient {
    httpClient;
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = mergeHeaders(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new HTTPFetchClient({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by JSON)
     * @param addAudienceToAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group"> Documentation</a>
     */
    async addAudienceToAudienceGroup(addAudienceToAudienceGroupRequest) {
        return (await this.addAudienceToAudienceGroupWithHttpInfo(addAudienceToAudienceGroupRequest)).body;
    }
    /**
     * Add user IDs or Identifiers for Advertisers (IFAs) to an audience for uploading user IDs (by JSON).
     * This method includes HttpInfo object to return additional information.
     * @param addAudienceToAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-upload-audience-group"> Documentation</a>
     */
    async addAudienceToAudienceGroupWithHttpInfo(addAudienceToAudienceGroupRequest) {
        const params = addAudienceToAudienceGroupRequest;
        const res = await this.httpClient.put("/v2/bot/audienceGroup/upload", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Create audience for uploading user IDs (by JSON)
     * @param createAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group"> Documentation</a>
     */
    async createAudienceGroup(createAudienceGroupRequest) {
        return (await this.createAudienceGroupWithHttpInfo(createAudienceGroupRequest)).body;
    }
    /**
     * Create audience for uploading user IDs (by JSON).
     * This method includes HttpInfo object to return additional information.
     * @param createAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-upload-audience-group"> Documentation</a>
     */
    async createAudienceGroupWithHttpInfo(createAudienceGroupRequest) {
        const params = createAudienceGroupRequest;
        const res = await this.httpClient.post("/v2/bot/audienceGroup/upload", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Create audience for click-based retargeting
     * @param createClickBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-click-audience-group"> Documentation</a>
     */
    async createClickBasedAudienceGroup(createClickBasedAudienceGroupRequest) {
        return (await this.createClickBasedAudienceGroupWithHttpInfo(createClickBasedAudienceGroupRequest)).body;
    }
    /**
     * Create audience for click-based retargeting.
     * This method includes HttpInfo object to return additional information.
     * @param createClickBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-click-audience-group"> Documentation</a>
     */
    async createClickBasedAudienceGroupWithHttpInfo(createClickBasedAudienceGroupRequest) {
        const params = createClickBasedAudienceGroupRequest;
        const res = await this.httpClient.post("/v2/bot/audienceGroup/click", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Create audience for impression-based retargeting
     * @param createImpBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-imp-audience-group"> Documentation</a>
     */
    async createImpBasedAudienceGroup(createImpBasedAudienceGroupRequest) {
        return (await this.createImpBasedAudienceGroupWithHttpInfo(createImpBasedAudienceGroupRequest)).body;
    }
    /**
     * Create audience for impression-based retargeting.
     * This method includes HttpInfo object to return additional information.
     * @param createImpBasedAudienceGroupRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-imp-audience-group"> Documentation</a>
     */
    async createImpBasedAudienceGroupWithHttpInfo(createImpBasedAudienceGroupRequest) {
        const params = createImpBasedAudienceGroupRequest;
        const res = await this.httpClient.post("/v2/bot/audienceGroup/imp", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Delete audience
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-audience-group"> Documentation</a>
     */
    async deleteAudienceGroup(audienceGroupId) {
        return (await this.deleteAudienceGroupWithHttpInfo(audienceGroupId)).body;
    }
    /**
     * Delete audience.
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-audience-group"> Documentation</a>
     */
    async deleteAudienceGroupWithHttpInfo(audienceGroupId) {
        const res = await this.httpClient.delete("/v2/bot/audienceGroup/{audienceGroupId}".replace("{audienceGroupId}", String(audienceGroupId)));
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Gets audience data.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-group"> Documentation</a>
     */
    async getAudienceData(audienceGroupId) {
        return (await this.getAudienceDataWithHttpInfo(audienceGroupId)).body;
    }
    /**
     * Gets audience data..
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-group"> Documentation</a>
     */
    async getAudienceDataWithHttpInfo(audienceGroupId) {
        const res = await this.httpClient.get("/v2/bot/audienceGroup/{audienceGroupId}".replace("{audienceGroupId}", String(audienceGroupId)));
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Gets data for more than one audience.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param includesExternalPublicGroups true (default): Get public audiences created in all channels linked to the same bot. false: Get audiences created in the same channel.
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-groups"> Documentation</a>
     */
    async getAudienceGroups(page, description, status, size, includesExternalPublicGroups, createRoute) {
        return (await this.getAudienceGroupsWithHttpInfo(page, description, status, size, includesExternalPublicGroups, createRoute)).body;
    }
    /**
     * Gets data for more than one audience..
     * This method includes HttpInfo object to return additional information.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param includesExternalPublicGroups true (default): Get public audiences created in all channels linked to the same bot. false: Get audiences created in the same channel.
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-audience-groups"> Documentation</a>
     */
    async getAudienceGroupsWithHttpInfo(page, description, status, size, includesExternalPublicGroups, createRoute) {
        const queryParams = {
            page: page,
            description: description,
            status: status,
            size: size,
            includesExternalPublicGroups: includesExternalPublicGroups,
            createRoute: createRoute,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/audienceGroup/list", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Gets audience data.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience"> Documentation</a>
     */
    async getSharedAudienceData(audienceGroupId) {
        return (await this.getSharedAudienceDataWithHttpInfo(audienceGroupId)).body;
    }
    /**
     * Gets audience data..
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience"> Documentation</a>
     */
    async getSharedAudienceDataWithHttpInfo(audienceGroupId) {
        const res = await this.httpClient.get("/v2/bot/audienceGroup/shared/{audienceGroupId}".replace("{audienceGroupId}", String(audienceGroupId)));
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Gets data for more than one audience, including those shared by the Business Manager.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     * @param includesOwnedAudienceGroups true: Include audienceGroups owned by LINE Official Account Manager false: Respond only audienceGroups shared by Business Manager
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience-list"> Documentation</a>
     */
    async getSharedAudienceGroups(page, description, status, size, createRoute, includesOwnedAudienceGroups) {
        return (await this.getSharedAudienceGroupsWithHttpInfo(page, description, status, size, createRoute, includesOwnedAudienceGroups)).body;
    }
    /**
     * Gets data for more than one audience, including those shared by the Business Manager..
     * This method includes HttpInfo object to return additional information.
     * @param page The page to return when getting (paginated) results. Must be 1 or higher.
     * @param description The name of the audience(s) to return. You can search for partial matches. This is case-insensitive, meaning AUDIENCE and audience are considered identical. If omitted, the name of the audience(s) will not be used as a search criterion.
     * @param status The status of the audience(s) to return. If omitted, the status of the audience(s) will not be used as a search criterion.
     * @param size The number of audiences per page. Default: 20 Max: 40
     * @param createRoute How the audience was created. If omitted, all audiences are included.  `OA_MANAGER`: Return only audiences created with LINE Official Account Manager (opens new window). `MESSAGING_API`: Return only audiences created with Messaging API.
     * @param includesOwnedAudienceGroups true: Include audienceGroups owned by LINE Official Account Manager false: Respond only audienceGroups shared by Business Manager
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-shared-audience-list"> Documentation</a>
     */
    async getSharedAudienceGroupsWithHttpInfo(page, description, status, size, createRoute, includesOwnedAudienceGroups) {
        const queryParams = {
            page: page,
            description: description,
            status: status,
            size: size,
            createRoute: createRoute,
            includesOwnedAudienceGroups: includesOwnedAudienceGroups,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/audienceGroup/shared/list", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Renames an existing audience.
     * @param audienceGroupId The audience ID.
     * @param updateAudienceGroupDescriptionRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-description-audience-group"> Documentation</a>
     */
    async updateAudienceGroupDescription(audienceGroupId, updateAudienceGroupDescriptionRequest) {
        return (await this.updateAudienceGroupDescriptionWithHttpInfo(audienceGroupId, updateAudienceGroupDescriptionRequest)).body;
    }
    /**
     * Renames an existing audience..
     * This method includes HttpInfo object to return additional information.
     * @param audienceGroupId The audience ID.
     * @param updateAudienceGroupDescriptionRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-description-audience-group"> Documentation</a>
     */
    async updateAudienceGroupDescriptionWithHttpInfo(audienceGroupId, updateAudienceGroupDescriptionRequest) {
        const params = updateAudienceGroupDescriptionRequest;
        const res = await this.httpClient.put("/v2/bot/audienceGroup/{audienceGroupId}/updateDescription".replace("{audienceGroupId}", String(audienceGroupId)), params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
//# sourceMappingURL=manageAudienceClient.js.map