/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { GetMessageContentTranscodingResponse } from "../model/getMessageContentTranscodingResponse.js";
import * as Types from "../../types.js";
import { Readable } from "node:stream";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class MessagingApiBlobClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Download image, video, and audio data sent from users.
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-content"> Documentation</a>
     */
    getMessageContent(messageId: string): Promise<Readable>;
    /**
     * Download image, video, and audio data sent from users..
     * This method includes HttpInfo object to return additional information.
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-content"> Documentation</a>
     */
    getMessageContentWithHttpInfo(messageId: string): Promise<Types.ApiResponseType<Readable>>;
    /**
     * Get a preview image of the image or video
     * @param messageId Message ID of image or video
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-image-or-video-preview"> Documentation</a>
     */
    getMessageContentPreview(messageId: string): Promise<Readable>;
    /**
     * Get a preview image of the image or video.
     * This method includes HttpInfo object to return additional information.
     * @param messageId Message ID of image or video
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-image-or-video-preview"> Documentation</a>
     */
    getMessageContentPreviewWithHttpInfo(messageId: string): Promise<Types.ApiResponseType<Readable>>;
    /**
     * Verify the preparation status of a video or audio for getting
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-video-or-audio-preparation-status"> Documentation</a>
     */
    getMessageContentTranscodingByMessageId(messageId: string): Promise<GetMessageContentTranscodingResponse>;
    /**
     * Verify the preparation status of a video or audio for getting.
     * This method includes HttpInfo object to return additional information.
     * @param messageId Message ID of video or audio
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#verify-video-or-audio-preparation-status"> Documentation</a>
     */
    getMessageContentTranscodingByMessageIdWithHttpInfo(messageId: string): Promise<Types.ApiResponseType<GetMessageContentTranscodingResponse>>;
    /**
     * Download rich menu image.
     * @param richMenuId ID of the rich menu with the image to be downloaded
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#download-rich-menu-image"> Documentation</a>
     */
    getRichMenuImage(richMenuId: string): Promise<Readable>;
    /**
     * Download rich menu image..
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId ID of the rich menu with the image to be downloaded
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#download-rich-menu-image"> Documentation</a>
     */
    getRichMenuImageWithHttpInfo(richMenuId: string): Promise<Types.ApiResponseType<Readable>>;
    /**
     * Upload rich menu image
     * @param richMenuId The ID of the rich menu to attach the image to
     * @param body
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#upload-rich-menu-image"> Documentation</a>
     */
    setRichMenuImage(richMenuId: string, body?: Blob): Promise<Types.MessageAPIResponseBase>;
    /**
     * Upload rich menu image.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId The ID of the rich menu to attach the image to
     * @param body
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#upload-rich-menu-image"> Documentation</a>
     */
    setRichMenuImageWithHttpInfo(richMenuId: string, body?: Blob): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
}
export {};
//# sourceMappingURL=messagingApiBlobClient.d.ts.map