/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { BotInfoResponse } from "../model/botInfoResponse.js";
import { BroadcastRequest } from "../model/broadcastRequest.js";
import { CouponCreateRequest } from "../model/couponCreateRequest.js";
import { CouponCreateResponse } from "../model/couponCreateResponse.js";
import { CouponResponse } from "../model/couponResponse.js";
import { CreateRichMenuAliasRequest } from "../model/createRichMenuAliasRequest.js";
import { GetAggregationUnitNameListResponse } from "../model/getAggregationUnitNameListResponse.js";
import { GetAggregationUnitUsageResponse } from "../model/getAggregationUnitUsageResponse.js";
import { GetFollowersResponse } from "../model/getFollowersResponse.js";
import { GetJoinedMembershipUsersResponse } from "../model/getJoinedMembershipUsersResponse.js";
import { GetMembershipSubscriptionResponse } from "../model/getMembershipSubscriptionResponse.js";
import { GetWebhookEndpointResponse } from "../model/getWebhookEndpointResponse.js";
import { GroupMemberCountResponse } from "../model/groupMemberCountResponse.js";
import { GroupSummaryResponse } from "../model/groupSummaryResponse.js";
import { GroupUserProfileResponse } from "../model/groupUserProfileResponse.js";
import { IssueLinkTokenResponse } from "../model/issueLinkTokenResponse.js";
import { MarkMessagesAsReadByTokenRequest } from "../model/markMessagesAsReadByTokenRequest.js";
import { MarkMessagesAsReadRequest } from "../model/markMessagesAsReadRequest.js";
import { MembersIdsResponse } from "../model/membersIdsResponse.js";
import { MembershipListResponse } from "../model/membershipListResponse.js";
import { MessageQuotaResponse } from "../model/messageQuotaResponse.js";
import { MessagingApiPagerCouponListResponse } from "../model/messagingApiPagerCouponListResponse.js";
import { MulticastRequest } from "../model/multicastRequest.js";
import { NarrowcastProgressResponse } from "../model/narrowcastProgressResponse.js";
import { NarrowcastRequest } from "../model/narrowcastRequest.js";
import { NumberOfMessagesResponse } from "../model/numberOfMessagesResponse.js";
import { PnpMessagesRequest } from "../model/pnpMessagesRequest.js";
import { PushMessageRequest } from "../model/pushMessageRequest.js";
import { PushMessageResponse } from "../model/pushMessageResponse.js";
import { QuotaConsumptionResponse } from "../model/quotaConsumptionResponse.js";
import { ReplyMessageRequest } from "../model/replyMessageRequest.js";
import { ReplyMessageResponse } from "../model/replyMessageResponse.js";
import { RichMenuAliasListResponse } from "../model/richMenuAliasListResponse.js";
import { RichMenuAliasResponse } from "../model/richMenuAliasResponse.js";
import { RichMenuBatchProgressResponse } from "../model/richMenuBatchProgressResponse.js";
import { RichMenuBatchRequest } from "../model/richMenuBatchRequest.js";
import { RichMenuBulkLinkRequest } from "../model/richMenuBulkLinkRequest.js";
import { RichMenuBulkUnlinkRequest } from "../model/richMenuBulkUnlinkRequest.js";
import { RichMenuIdResponse } from "../model/richMenuIdResponse.js";
import { RichMenuListResponse } from "../model/richMenuListResponse.js";
import { RichMenuRequest } from "../model/richMenuRequest.js";
import { RichMenuResponse } from "../model/richMenuResponse.js";
import { RoomMemberCountResponse } from "../model/roomMemberCountResponse.js";
import { RoomUserProfileResponse } from "../model/roomUserProfileResponse.js";
import { SetWebhookEndpointRequest } from "../model/setWebhookEndpointRequest.js";
import { ShowLoadingAnimationRequest } from "../model/showLoadingAnimationRequest.js";
import { TestWebhookEndpointRequest } from "../model/testWebhookEndpointRequest.js";
import { TestWebhookEndpointResponse } from "../model/testWebhookEndpointResponse.js";
import { UpdateRichMenuAliasRequest } from "../model/updateRichMenuAliasRequest.js";
import { UserProfileResponse } from "../model/userProfileResponse.js";
import { ValidateMessageRequest } from "../model/validateMessageRequest.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class MessagingApiClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * Sends a message to multiple users at any time.
     * @param broadcastRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-broadcast-message"> Documentation</a>
     */
    broadcast(broadcastRequest: BroadcastRequest, xLineRetryKey?: string): Promise<object>;
    /**
     * Sends a message to multiple users at any time..
     * This method includes HttpInfo object to return additional information.
     * @param broadcastRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-broadcast-message"> Documentation</a>
     */
    broadcastWithHttpInfo(broadcastRequest: BroadcastRequest, xLineRetryKey?: string): Promise<Types.ApiResponseType<object>>;
    /**
     * Cancel default rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#cancel-default-rich-menu"> Documentation</a>
     */
    cancelDefaultRichMenu(): Promise<Types.MessageAPIResponseBase>;
    /**
     * Cancel default rich menu.
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#cancel-default-rich-menu"> Documentation</a>
     */
    cancelDefaultRichMenuWithHttpInfo(): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Close coupon
     * @param couponId
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#discontinue-coupon"> Documentation</a>
     */
    closeCoupon(couponId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Close coupon.
     * This method includes HttpInfo object to return additional information.
     * @param couponId
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#discontinue-coupon"> Documentation</a>
     */
    closeCouponWithHttpInfo(couponId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Create a new coupon. Define coupon details such as type, title, and validity period.
     * @param couponCreateRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-coupon"> Documentation</a>
     */
    createCoupon(couponCreateRequest?: CouponCreateRequest): Promise<CouponCreateResponse>;
    /**
     * Create a new coupon. Define coupon details such as type, title, and validity period..
     * This method includes HttpInfo object to return additional information.
     * @param couponCreateRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-coupon"> Documentation</a>
     */
    createCouponWithHttpInfo(couponCreateRequest?: CouponCreateRequest): Promise<Types.ApiResponseType<CouponCreateResponse>>;
    /**
     * Create rich menu
     * @param richMenuRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu"> Documentation</a>
     */
    createRichMenu(richMenuRequest: RichMenuRequest): Promise<RichMenuIdResponse>;
    /**
     * Create rich menu.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu"> Documentation</a>
     */
    createRichMenuWithHttpInfo(richMenuRequest: RichMenuRequest): Promise<Types.ApiResponseType<RichMenuIdResponse>>;
    /**
     * Create rich menu alias
     * @param createRichMenuAliasRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu-alias"> Documentation</a>
     */
    createRichMenuAlias(createRichMenuAliasRequest: CreateRichMenuAliasRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Create rich menu alias.
     * This method includes HttpInfo object to return additional information.
     * @param createRichMenuAliasRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#create-rich-menu-alias"> Documentation</a>
     */
    createRichMenuAliasWithHttpInfo(createRichMenuAliasRequest: CreateRichMenuAliasRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Deletes a rich menu.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu"> Documentation</a>
     */
    deleteRichMenu(richMenuId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Deletes a rich menu..
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu"> Documentation</a>
     */
    deleteRichMenuWithHttpInfo(richMenuId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Delete rich menu alias
     * @param richMenuAliasId Rich menu alias ID that you want to delete.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu-alias"> Documentation</a>
     */
    deleteRichMenuAlias(richMenuAliasId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Delete rich menu alias.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuAliasId Rich menu alias ID that you want to delete.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#delete-rich-menu-alias"> Documentation</a>
     */
    deleteRichMenuAliasWithHttpInfo(richMenuAliasId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Get name list of units used this month
     * @param limit The maximum number of aggregation units you can get per request.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all the aggregation units in one request, include this parameter to get the remaining array.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-name-list-of-units-used-this-month"> Documentation</a>
     */
    getAggregationUnitNameList(limit?: string, start?: string): Promise<GetAggregationUnitNameListResponse>;
    /**
     * Get name list of units used this month.
     * This method includes HttpInfo object to return additional information.
     * @param limit The maximum number of aggregation units you can get per request.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all the aggregation units in one request, include this parameter to get the remaining array.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-name-list-of-units-used-this-month"> Documentation</a>
     */
    getAggregationUnitNameListWithHttpInfo(limit?: string, start?: string): Promise<Types.ApiResponseType<GetAggregationUnitNameListResponse>>;
    /**
     * Get number of units used this month
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-units-used-this-month"> Documentation</a>
     */
    getAggregationUnitUsage(): Promise<GetAggregationUnitUsageResponse>;
    /**
     * Get number of units used this month.
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-units-used-this-month"> Documentation</a>
     */
    getAggregationUnitUsageWithHttpInfo(): Promise<Types.ApiResponseType<GetAggregationUnitUsageResponse>>;
    /**
     * Get bot info
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-bot-info"> Documentation</a>
     */
    getBotInfo(): Promise<BotInfoResponse>;
    /**
     * Get bot info.
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-bot-info"> Documentation</a>
     */
    getBotInfoWithHttpInfo(): Promise<Types.ApiResponseType<BotInfoResponse>>;
    /**
     * Get coupon detail
     * @param couponId
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupon"> Documentation</a>
     */
    getCouponDetail(couponId: string): Promise<CouponResponse>;
    /**
     * Get coupon detail.
     * This method includes HttpInfo object to return additional information.
     * @param couponId
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupon"> Documentation</a>
     */
    getCouponDetailWithHttpInfo(couponId: string): Promise<Types.ApiResponseType<CouponResponse>>;
    /**
     * Gets the ID of the default rich menu set with the Messaging API.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-default-rich-menu-id"> Documentation</a>
     */
    getDefaultRichMenuId(): Promise<RichMenuIdResponse>;
    /**
     * Gets the ID of the default rich menu set with the Messaging API..
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-default-rich-menu-id"> Documentation</a>
     */
    getDefaultRichMenuIdWithHttpInfo(): Promise<Types.ApiResponseType<RichMenuIdResponse>>;
    /**
     * Get a list of users who added your LINE Official Account as a friend
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. Include this parameter to get the next array of user IDs.
     * @param limit The maximum number of user IDs to retrieve in a single request.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-follower-ids"> Documentation</a>
     */
    getFollowers(start?: string, limit?: number): Promise<GetFollowersResponse>;
    /**
     * Get a list of users who added your LINE Official Account as a friend.
     * This method includes HttpInfo object to return additional information.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. Include this parameter to get the next array of user IDs.
     * @param limit The maximum number of user IDs to retrieve in a single request.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-follower-ids"> Documentation</a>
     */
    getFollowersWithHttpInfo(start?: string, limit?: number): Promise<Types.ApiResponseType<GetFollowersResponse>>;
    /**
     * Get number of users in a group chat
     * @param groupId Group ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-group-count"> Documentation</a>
     */
    getGroupMemberCount(groupId: string): Promise<GroupMemberCountResponse>;
    /**
     * Get number of users in a group chat.
     * This method includes HttpInfo object to return additional information.
     * @param groupId Group ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-group-count"> Documentation</a>
     */
    getGroupMemberCountWithHttpInfo(groupId: string): Promise<Types.ApiResponseType<GroupMemberCountResponse>>;
    /**
     * Get group chat member profile
     * @param groupId Group ID
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-profile"> Documentation</a>
     */
    getGroupMemberProfile(groupId: string, userId: string): Promise<GroupUserProfileResponse>;
    /**
     * Get group chat member profile.
     * This method includes HttpInfo object to return additional information.
     * @param groupId Group ID
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-profile"> Documentation</a>
     */
    getGroupMemberProfileWithHttpInfo(groupId: string, userId: string): Promise<Types.ApiResponseType<GroupUserProfileResponse>>;
    /**
     * Get group chat member user IDs
     * @param groupId Group ID
     * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-user-ids"> Documentation</a>
     */
    getGroupMembersIds(groupId: string, start?: string): Promise<MembersIdsResponse>;
    /**
     * Get group chat member user IDs.
     * This method includes HttpInfo object to return additional information.
     * @param groupId Group ID
     * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-member-user-ids"> Documentation</a>
     */
    getGroupMembersIdsWithHttpInfo(groupId: string, start?: string): Promise<Types.ApiResponseType<MembersIdsResponse>>;
    /**
     * Get group chat summary
     * @param groupId Group ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-summary"> Documentation</a>
     */
    getGroupSummary(groupId: string): Promise<GroupSummaryResponse>;
    /**
     * Get group chat summary.
     * This method includes HttpInfo object to return additional information.
     * @param groupId Group ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-group-summary"> Documentation</a>
     */
    getGroupSummaryWithHttpInfo(groupId: string): Promise<Types.ApiResponseType<GroupSummaryResponse>>;
    /**
     * Get a list of user IDs who joined the membership.
     * @param membershipId Membership plan ID.
     * @param start A continuation token to get next remaining membership user IDs. Returned only when there are remaining user IDs that weren\'t returned in the userIds property in the previous request. The continuation token expires in 24 hours (86,400 seconds).
     * @param limit The max number of items to return for this API call. The value is set to 300 by default, but the max acceptable value is 1000.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-user-ids"> Documentation</a>
     */
    getJoinedMembershipUsers(membershipId: number, start?: string, limit?: number): Promise<GetJoinedMembershipUsersResponse>;
    /**
     * Get a list of user IDs who joined the membership..
     * This method includes HttpInfo object to return additional information.
     * @param membershipId Membership plan ID.
     * @param start A continuation token to get next remaining membership user IDs. Returned only when there are remaining user IDs that weren\'t returned in the userIds property in the previous request. The continuation token expires in 24 hours (86,400 seconds).
     * @param limit The max number of items to return for this API call. The value is set to 300 by default, but the max acceptable value is 1000.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-user-ids"> Documentation</a>
     */
    getJoinedMembershipUsersWithHttpInfo(membershipId: number, start?: string, limit?: number): Promise<Types.ApiResponseType<GetJoinedMembershipUsersResponse>>;
    /**
     * Get a list of memberships.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-plans"> Documentation</a>
     */
    getMembershipList(): Promise<MembershipListResponse>;
    /**
     * Get a list of memberships..
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-membership-plans"> Documentation</a>
     */
    getMembershipListWithHttpInfo(): Promise<Types.ApiResponseType<MembershipListResponse>>;
    /**
     * Get a user\'s membership subscription.
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-a-users-membership-subscription-status"> Documentation</a>
     */
    getMembershipSubscription(userId: string): Promise<GetMembershipSubscriptionResponse>;
    /**
     * Get a user\'s membership subscription..
     * This method includes HttpInfo object to return additional information.
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-a-users-membership-subscription-status"> Documentation</a>
     */
    getMembershipSubscriptionWithHttpInfo(userId: string): Promise<Types.ApiResponseType<GetMembershipSubscriptionResponse>>;
    /**
     * Gets the target limit for sending messages in the current month. The total number of the free messages and the additional messages is returned.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-quota"> Documentation</a>
     */
    getMessageQuota(): Promise<MessageQuotaResponse>;
    /**
     * Gets the target limit for sending messages in the current month. The total number of the free messages and the additional messages is returned..
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-quota"> Documentation</a>
     */
    getMessageQuotaWithHttpInfo(): Promise<Types.ApiResponseType<MessageQuotaResponse>>;
    /**
     * Gets the number of messages sent in the current month.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-consumption"> Documentation</a>
     */
    getMessageQuotaConsumption(): Promise<QuotaConsumptionResponse>;
    /**
     * Gets the number of messages sent in the current month..
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-consumption"> Documentation</a>
     */
    getMessageQuotaConsumptionWithHttpInfo(): Promise<Types.ApiResponseType<QuotaConsumptionResponse>>;
    /**
     * Gets the status of a narrowcast message.
     * @param requestId The narrowcast message\'s request ID. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-narrowcast-progress-status"> Documentation</a>
     */
    getNarrowcastProgress(requestId: string): Promise<NarrowcastProgressResponse>;
    /**
     * Gets the status of a narrowcast message..
     * This method includes HttpInfo object to return additional information.
     * @param requestId The narrowcast message\'s request ID. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-narrowcast-progress-status"> Documentation</a>
     */
    getNarrowcastProgressWithHttpInfo(requestId: string): Promise<Types.ApiResponseType<NarrowcastProgressResponse>>;
    /**
     * Get number of sent broadcast messages
     * @param date Date the messages were sent  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-broadcast-messages"> Documentation</a>
     */
    getNumberOfSentBroadcastMessages(date: string): Promise<NumberOfMessagesResponse>;
    /**
     * Get number of sent broadcast messages.
     * This method includes HttpInfo object to return additional information.
     * @param date Date the messages were sent  Format: yyyyMMdd (e.g. 20191231) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-broadcast-messages"> Documentation</a>
     */
    getNumberOfSentBroadcastMessagesWithHttpInfo(date: string): Promise<Types.ApiResponseType<NumberOfMessagesResponse>>;
    /**
     * Get number of sent multicast messages
     * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-multicast-messages"> Documentation</a>
     */
    getNumberOfSentMulticastMessages(date: string): Promise<NumberOfMessagesResponse>;
    /**
     * Get number of sent multicast messages.
     * This method includes HttpInfo object to return additional information.
     * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-multicast-messages"> Documentation</a>
     */
    getNumberOfSentMulticastMessagesWithHttpInfo(date: string): Promise<Types.ApiResponseType<NumberOfMessagesResponse>>;
    /**
     * Get number of sent push messages
     * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-push-messages"> Documentation</a>
     */
    getNumberOfSentPushMessages(date: string): Promise<NumberOfMessagesResponse>;
    /**
     * Get number of sent push messages.
     * This method includes HttpInfo object to return additional information.
     * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-push-messages"> Documentation</a>
     */
    getNumberOfSentPushMessagesWithHttpInfo(date: string): Promise<Types.ApiResponseType<NumberOfMessagesResponse>>;
    /**
     * Get number of sent reply messages
     * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-reply-messages"> Documentation</a>
     */
    getNumberOfSentReplyMessages(date: string): Promise<NumberOfMessagesResponse>;
    /**
     * Get number of sent reply messages.
     * This method includes HttpInfo object to return additional information.
     * @param date Date the messages were sent  Format: `yyyyMMdd` (e.g. `20191231`) Timezone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-number-of-reply-messages"> Documentation</a>
     */
    getNumberOfSentReplyMessagesWithHttpInfo(date: string): Promise<Types.ApiResponseType<NumberOfMessagesResponse>>;
    /**
     * Get number of sent LINE notification messages
     * @param date Date the message was sent  Format: `yyyyMMdd` (Example:`20211231`) Time zone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-number-of-sent-line-notification-messages"> Documentation</a>
     */
    getPNPMessageStatistics(date: string): Promise<NumberOfMessagesResponse>;
    /**
     * Get number of sent LINE notification messages　.
     * This method includes HttpInfo object to return additional information.
     * @param date Date the message was sent  Format: `yyyyMMdd` (Example:`20211231`) Time zone: UTC+9
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-number-of-sent-line-notification-messages"> Documentation</a>
     */
    getPNPMessageStatisticsWithHttpInfo(date: string): Promise<Types.ApiResponseType<NumberOfMessagesResponse>>;
    /**
     * Get profile
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-profile"> Documentation</a>
     */
    getProfile(userId: string): Promise<UserProfileResponse>;
    /**
     * Get profile.
     * This method includes HttpInfo object to return additional information.
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-profile"> Documentation</a>
     */
    getProfileWithHttpInfo(userId: string): Promise<Types.ApiResponseType<UserProfileResponse>>;
    /**
     * Gets a rich menu via a rich menu ID.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu"> Documentation</a>
     */
    getRichMenu(richMenuId: string): Promise<RichMenuResponse>;
    /**
     * Gets a rich menu via a rich menu ID..
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu"> Documentation</a>
     */
    getRichMenuWithHttpInfo(richMenuId: string): Promise<Types.ApiResponseType<RichMenuResponse>>;
    /**
     * Get rich menu alias information
     * @param richMenuAliasId The rich menu alias ID whose information you want to obtain.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-by-id"> Documentation</a>
     */
    getRichMenuAlias(richMenuAliasId: string): Promise<RichMenuAliasResponse>;
    /**
     * Get rich menu alias information.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuAliasId The rich menu alias ID whose information you want to obtain.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-by-id"> Documentation</a>
     */
    getRichMenuAliasWithHttpInfo(richMenuAliasId: string): Promise<Types.ApiResponseType<RichMenuAliasResponse>>;
    /**
     * Get list of rich menu alias
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-list"> Documentation</a>
     */
    getRichMenuAliasList(): Promise<RichMenuAliasListResponse>;
    /**
     * Get list of rich menu alias.
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-alias-list"> Documentation</a>
     */
    getRichMenuAliasListWithHttpInfo(): Promise<Types.ApiResponseType<RichMenuAliasListResponse>>;
    /**
     * Get the status of Replace or unlink a linked rich menus in batches.
     * @param requestId A request ID used to batch control the rich menu linked to the user. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-batch-control-rich-menus-progress-status"> Documentation</a>
     */
    getRichMenuBatchProgress(requestId: string): Promise<RichMenuBatchProgressResponse>;
    /**
     * Get the status of Replace or unlink a linked rich menus in batches..
     * This method includes HttpInfo object to return additional information.
     * @param requestId A request ID used to batch control the rich menu linked to the user. Each Messaging API request has a request ID.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-batch-control-rich-menus-progress-status"> Documentation</a>
     */
    getRichMenuBatchProgressWithHttpInfo(requestId: string): Promise<Types.ApiResponseType<RichMenuBatchProgressResponse>>;
    /**
     * Get rich menu ID of user
     * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-id-of-user"> Documentation</a>
     */
    getRichMenuIdOfUser(userId: string): Promise<RichMenuIdResponse>;
    /**
     * Get rich menu ID of user.
     * This method includes HttpInfo object to return additional information.
     * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-id-of-user"> Documentation</a>
     */
    getRichMenuIdOfUserWithHttpInfo(userId: string): Promise<Types.ApiResponseType<RichMenuIdResponse>>;
    /**
     * Get rich menu list
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-list"> Documentation</a>
     */
    getRichMenuList(): Promise<RichMenuListResponse>;
    /**
     * Get rich menu list.
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-rich-menu-list"> Documentation</a>
     */
    getRichMenuListWithHttpInfo(): Promise<Types.ApiResponseType<RichMenuListResponse>>;
    /**
     * Get number of users in a multi-person chat
     * @param roomId Room ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-room-count"> Documentation</a>
     */
    getRoomMemberCount(roomId: string): Promise<RoomMemberCountResponse>;
    /**
     * Get number of users in a multi-person chat.
     * This method includes HttpInfo object to return additional information.
     * @param roomId Room ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-members-room-count"> Documentation</a>
     */
    getRoomMemberCountWithHttpInfo(roomId: string): Promise<Types.ApiResponseType<RoomMemberCountResponse>>;
    /**
     * Get multi-person chat member profile
     * @param roomId Room ID
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-profile"> Documentation</a>
     */
    getRoomMemberProfile(roomId: string, userId: string): Promise<RoomUserProfileResponse>;
    /**
     * Get multi-person chat member profile.
     * This method includes HttpInfo object to return additional information.
     * @param roomId Room ID
     * @param userId User ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-profile"> Documentation</a>
     */
    getRoomMemberProfileWithHttpInfo(roomId: string, userId: string): Promise<Types.ApiResponseType<RoomUserProfileResponse>>;
    /**
     * Get multi-person chat member user IDs
     * @param roomId Room ID
     * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-user-ids"> Documentation</a>
     */
    getRoomMembersIds(roomId: string, start?: string): Promise<MembersIdsResponse>;
    /**
     * Get multi-person chat member user IDs.
     * This method includes HttpInfo object to return additional information.
     * @param roomId Room ID
     * @param start Value of the continuation token found in the `next` property of the JSON object returned in the response. Include this parameter to get the next array of user IDs for the members of the group.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-room-member-user-ids"> Documentation</a>
     */
    getRoomMembersIdsWithHttpInfo(roomId: string, start?: string): Promise<Types.ApiResponseType<MembersIdsResponse>>;
    /**
     * Get webhook endpoint information
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-webhook-endpoint-information"> Documentation</a>
     */
    getWebhookEndpoint(): Promise<GetWebhookEndpointResponse>;
    /**
     * Get webhook endpoint information.
     * This method includes HttpInfo object to return additional information.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-webhook-endpoint-information"> Documentation</a>
     */
    getWebhookEndpointWithHttpInfo(): Promise<Types.ApiResponseType<GetWebhookEndpointResponse>>;
    /**
     * Issue link token
     * @param userId User ID for the LINE account to be linked. Found in the `source` object of account link event objects. Do not use the LINE ID used in LINE.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-link-token"> Documentation</a>
     */
    issueLinkToken(userId: string): Promise<IssueLinkTokenResponse>;
    /**
     * Issue link token.
     * This method includes HttpInfo object to return additional information.
     * @param userId User ID for the LINE account to be linked. Found in the `source` object of account link event objects. Do not use the LINE ID used in LINE.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#issue-link-token"> Documentation</a>
     */
    issueLinkTokenWithHttpInfo(userId: string): Promise<Types.ApiResponseType<IssueLinkTokenResponse>>;
    /**
     * Leave group chat
     * @param groupId Group ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-group"> Documentation</a>
     */
    leaveGroup(groupId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Leave group chat.
     * This method includes HttpInfo object to return additional information.
     * @param groupId Group ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-group"> Documentation</a>
     */
    leaveGroupWithHttpInfo(groupId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Leave multi-person chat
     * @param roomId Room ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-room"> Documentation</a>
     */
    leaveRoom(roomId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Leave multi-person chat.
     * This method includes HttpInfo object to return additional information.
     * @param roomId Room ID
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#leave-room"> Documentation</a>
     */
    leaveRoomWithHttpInfo(roomId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Link rich menu to user.
     * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-user"> Documentation</a>
     */
    linkRichMenuIdToUser(userId: string, richMenuId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Link rich menu to user..
     * This method includes HttpInfo object to return additional information.
     * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-user"> Documentation</a>
     */
    linkRichMenuIdToUserWithHttpInfo(userId: string, richMenuId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Link rich menu to multiple users
     * @param richMenuBulkLinkRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-users"> Documentation</a>
     */
    linkRichMenuIdToUsers(richMenuBulkLinkRequest: RichMenuBulkLinkRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Link rich menu to multiple users.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuBulkLinkRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#link-rich-menu-to-users"> Documentation</a>
     */
    linkRichMenuIdToUsersWithHttpInfo(richMenuBulkLinkRequest: RichMenuBulkLinkRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Get a paginated list of coupons.
     * @param status Filter coupons by their status.
     * @param start Pagination token to retrieve the next page of results.
     * @param limit Maximum number of coupons to return per request.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupons-list"> Documentation</a>
     */
    listCoupon(status?: Set<"DRAFT" | "RUNNING" | "CLOSED">, start?: string, limit?: number): Promise<MessagingApiPagerCouponListResponse>;
    /**
     * Get a paginated list of coupons..
     * This method includes HttpInfo object to return additional information.
     * @param status Filter coupons by their status.
     * @param start Pagination token to retrieve the next page of results.
     * @param limit Maximum number of coupons to return per request.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#get-coupons-list"> Documentation</a>
     */
    listCouponWithHttpInfo(status?: Set<"DRAFT" | "RUNNING" | "CLOSED">, start?: string, limit?: number): Promise<Types.ApiResponseType<MessagingApiPagerCouponListResponse>>;
    /**
     * Mark messages from users as read
     * @param markMessagesAsReadRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#mark-messages-from-users-as-read"> Documentation</a>
     */
    markMessagesAsRead(markMessagesAsReadRequest: MarkMessagesAsReadRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Mark messages from users as read.
     * This method includes HttpInfo object to return additional information.
     * @param markMessagesAsReadRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#mark-messages-from-users-as-read"> Documentation</a>
     */
    markMessagesAsReadWithHttpInfo(markMessagesAsReadRequest: MarkMessagesAsReadRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Mark messages from users as read by token
     * @param markMessagesAsReadByTokenRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#mark-as-read"> Documentation</a>
     */
    markMessagesAsReadByToken(markMessagesAsReadByTokenRequest: MarkMessagesAsReadByTokenRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Mark messages from users as read by token.
     * This method includes HttpInfo object to return additional information.
     * @param markMessagesAsReadByTokenRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#mark-as-read"> Documentation</a>
     */
    markMessagesAsReadByTokenWithHttpInfo(markMessagesAsReadByTokenRequest: MarkMessagesAsReadByTokenRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * An API that efficiently sends the same message to multiple user IDs. You can\'t send messages to group chats or multi-person chats.
     * @param multicastRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-multicast-message"> Documentation</a>
     */
    multicast(multicastRequest: MulticastRequest, xLineRetryKey?: string): Promise<object>;
    /**
     * An API that efficiently sends the same message to multiple user IDs. You can\'t send messages to group chats or multi-person chats..
     * This method includes HttpInfo object to return additional information.
     * @param multicastRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-multicast-message"> Documentation</a>
     */
    multicastWithHttpInfo(multicastRequest: MulticastRequest, xLineRetryKey?: string): Promise<Types.ApiResponseType<object>>;
    /**
     * Send narrowcast message
     * @param narrowcastRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-narrowcast-message"> Documentation</a>
     */
    narrowcast(narrowcastRequest: NarrowcastRequest, xLineRetryKey?: string): Promise<object>;
    /**
     * Send narrowcast message.
     * This method includes HttpInfo object to return additional information.
     * @param narrowcastRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-narrowcast-message"> Documentation</a>
     */
    narrowcastWithHttpInfo(narrowcastRequest: NarrowcastRequest, xLineRetryKey?: string): Promise<Types.ApiResponseType<object>>;
    /**
     * Sends a message to a user, group chat, or multi-person chat at any time.
     * @param pushMessageRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-push-message"> Documentation</a>
     */
    pushMessage(pushMessageRequest: PushMessageRequest, xLineRetryKey?: string): Promise<PushMessageResponse>;
    /**
     * Sends a message to a user, group chat, or multi-person chat at any time..
     * This method includes HttpInfo object to return additional information.
     * @param pushMessageRequest
     * @param xLineRetryKey Retry key. Specifies the UUID in hexadecimal format (e.g., `123e4567-e89b-12d3-a456-426614174000`) generated by any method. The retry key isn\'t generated by LINE. Each developer must generate their own retry key.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-push-message"> Documentation</a>
     */
    pushMessageWithHttpInfo(pushMessageRequest: PushMessageRequest, xLineRetryKey?: string): Promise<Types.ApiResponseType<PushMessageResponse>>;
    /**
     * Send LINE notification message
     * @param pnpMessagesRequest
     * @param xLineDeliveryTag String returned in the delivery.data property of the delivery completion event via Webhook.
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-line-notification-message"> Documentation</a>
     */
    pushMessagesByPhone(pnpMessagesRequest: PnpMessagesRequest, xLineDeliveryTag?: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Send LINE notification message.
     * This method includes HttpInfo object to return additional information.
     * @param pnpMessagesRequest
     * @param xLineDeliveryTag String returned in the delivery.data property of the delivery completion event via Webhook.
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#send-line-notification-message"> Documentation</a>
     */
    pushMessagesByPhoneWithHttpInfo(pnpMessagesRequest: PnpMessagesRequest, xLineDeliveryTag?: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Send reply message
     * @param replyMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-reply-message"> Documentation</a>
     */
    replyMessage(replyMessageRequest: ReplyMessageRequest): Promise<ReplyMessageResponse>;
    /**
     * Send reply message.
     * This method includes HttpInfo object to return additional information.
     * @param replyMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#send-reply-message"> Documentation</a>
     */
    replyMessageWithHttpInfo(replyMessageRequest: ReplyMessageRequest): Promise<Types.ApiResponseType<ReplyMessageResponse>>;
    /**
     * You can use this endpoint to batch control the rich menu linked to the users using the endpoint such as Link rich menu to user. The following operations are available:  1. Replace a rich menu with another rich menu for all users linked to a specific rich menu 2. Unlink a rich menu for all users linked to a specific rich menu 3. Unlink a rich menu for all users linked the rich menu
     * @param richMenuBatchRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#batch-control-rich-menus-of-users"> Documentation</a>
     */
    richMenuBatch(richMenuBatchRequest: RichMenuBatchRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * You can use this endpoint to batch control the rich menu linked to the users using the endpoint such as Link rich menu to user. The following operations are available:  1. Replace a rich menu with another rich menu for all users linked to a specific rich menu 2. Unlink a rich menu for all users linked to a specific rich menu 3. Unlink a rich menu for all users linked the rich menu .
     * This method includes HttpInfo object to return additional information.
     * @param richMenuBatchRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#batch-control-rich-menus-of-users"> Documentation</a>
     */
    richMenuBatchWithHttpInfo(richMenuBatchRequest: RichMenuBatchRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Set default rich menu
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-default-rich-menu"> Documentation</a>
     */
    setDefaultRichMenu(richMenuId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Set default rich menu.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuId ID of a rich menu
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-default-rich-menu"> Documentation</a>
     */
    setDefaultRichMenuWithHttpInfo(richMenuId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Set webhook endpoint URL
     * @param setWebhookEndpointRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-webhook-endpoint-url"> Documentation</a>
     */
    setWebhookEndpoint(setWebhookEndpointRequest: SetWebhookEndpointRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Set webhook endpoint URL.
     * This method includes HttpInfo object to return additional information.
     * @param setWebhookEndpointRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#set-webhook-endpoint-url"> Documentation</a>
     */
    setWebhookEndpointWithHttpInfo(setWebhookEndpointRequest: SetWebhookEndpointRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Display a loading animation in one-on-one chats between users and LINE Official Accounts.
     * @param showLoadingAnimationRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#display-a-loading-indicator"> Documentation</a>
     */
    showLoadingAnimation(showLoadingAnimationRequest: ShowLoadingAnimationRequest): Promise<object>;
    /**
     * Display a loading animation in one-on-one chats between users and LINE Official Accounts..
     * This method includes HttpInfo object to return additional information.
     * @param showLoadingAnimationRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#display-a-loading-indicator"> Documentation</a>
     */
    showLoadingAnimationWithHttpInfo(showLoadingAnimationRequest: ShowLoadingAnimationRequest): Promise<Types.ApiResponseType<object>>;
    /**
     * Test webhook endpoint
     * @param testWebhookEndpointRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#test-webhook-endpoint"> Documentation</a>
     */
    testWebhookEndpoint(testWebhookEndpointRequest?: TestWebhookEndpointRequest): Promise<TestWebhookEndpointResponse>;
    /**
     * Test webhook endpoint.
     * This method includes HttpInfo object to return additional information.
     * @param testWebhookEndpointRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#test-webhook-endpoint"> Documentation</a>
     */
    testWebhookEndpointWithHttpInfo(testWebhookEndpointRequest?: TestWebhookEndpointRequest): Promise<Types.ApiResponseType<TestWebhookEndpointResponse>>;
    /**
     * Unlink rich menu from user
     * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-user"> Documentation</a>
     */
    unlinkRichMenuIdFromUser(userId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * Unlink rich menu from user.
     * This method includes HttpInfo object to return additional information.
     * @param userId User ID. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-user"> Documentation</a>
     */
    unlinkRichMenuIdFromUserWithHttpInfo(userId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Unlink rich menus from multiple users
     * @param richMenuBulkUnlinkRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-users"> Documentation</a>
     */
    unlinkRichMenuIdFromUsers(richMenuBulkUnlinkRequest: RichMenuBulkUnlinkRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Unlink rich menus from multiple users.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuBulkUnlinkRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-users"> Documentation</a>
     */
    unlinkRichMenuIdFromUsersWithHttpInfo(richMenuBulkUnlinkRequest: RichMenuBulkUnlinkRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Update rich menu alias
     * @param richMenuAliasId The rich menu alias ID you want to update.
     * @param updateRichMenuAliasRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-rich-menu-alias"> Documentation</a>
     */
    updateRichMenuAlias(richMenuAliasId: string, updateRichMenuAliasRequest: UpdateRichMenuAliasRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Update rich menu alias.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuAliasId The rich menu alias ID you want to update.
     * @param updateRichMenuAliasRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#update-rich-menu-alias"> Documentation</a>
     */
    updateRichMenuAliasWithHttpInfo(richMenuAliasId: string, updateRichMenuAliasRequest: UpdateRichMenuAliasRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate message objects of a broadcast message
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-broadcast-message"> Documentation</a>
     */
    validateBroadcast(validateMessageRequest: ValidateMessageRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate message objects of a broadcast message.
     * This method includes HttpInfo object to return additional information.
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-broadcast-message"> Documentation</a>
     */
    validateBroadcastWithHttpInfo(validateMessageRequest: ValidateMessageRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate message objects of a multicast message
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-multicast-message"> Documentation</a>
     */
    validateMulticast(validateMessageRequest: ValidateMessageRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate message objects of a multicast message.
     * This method includes HttpInfo object to return additional information.
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-multicast-message"> Documentation</a>
     */
    validateMulticastWithHttpInfo(validateMessageRequest: ValidateMessageRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate message objects of a narrowcast message
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-narrowcast-message"> Documentation</a>
     */
    validateNarrowcast(validateMessageRequest: ValidateMessageRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate message objects of a narrowcast message.
     * This method includes HttpInfo object to return additional information.
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-narrowcast-message"> Documentation</a>
     */
    validateNarrowcastWithHttpInfo(validateMessageRequest: ValidateMessageRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate message objects of a push message
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-push-message"> Documentation</a>
     */
    validatePush(validateMessageRequest: ValidateMessageRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate message objects of a push message.
     * This method includes HttpInfo object to return additional information.
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-push-message"> Documentation</a>
     */
    validatePushWithHttpInfo(validateMessageRequest: ValidateMessageRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate message objects of a reply message
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-reply-message"> Documentation</a>
     */
    validateReply(validateMessageRequest: ValidateMessageRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate message objects of a reply message.
     * This method includes HttpInfo object to return additional information.
     * @param validateMessageRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-message-objects-of-reply-message"> Documentation</a>
     */
    validateReplyWithHttpInfo(validateMessageRequest: ValidateMessageRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate a request body of the Replace or unlink the linked rich menus in batches endpoint.
     * @param richMenuBatchRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-batch-control-rich-menus-request"> Documentation</a>
     */
    validateRichMenuBatchRequest(richMenuBatchRequest: RichMenuBatchRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate a request body of the Replace or unlink the linked rich menus in batches endpoint..
     * This method includes HttpInfo object to return additional information.
     * @param richMenuBatchRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-batch-control-rich-menus-request"> Documentation</a>
     */
    validateRichMenuBatchRequestWithHttpInfo(richMenuBatchRequest: RichMenuBatchRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Validate rich menu object
     * @param richMenuRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-rich-menu-object"> Documentation</a>
     */
    validateRichMenuObject(richMenuRequest: RichMenuRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * Validate rich menu object.
     * This method includes HttpInfo object to return additional information.
     * @param richMenuRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/messaging-api/#validate-rich-menu-object"> Documentation</a>
     */
    validateRichMenuObjectWithHttpInfo(richMenuRequest: RichMenuRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
}
export {};
//# sourceMappingURL=messagingApiClient.d.ts.map