/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { AcquireChatControlRequest } from "../model/acquireChatControlRequest.js";
import { DetachModuleRequest } from "../model/detachModuleRequest.js";
import { GetModulesResponse } from "../model/getModulesResponse.js";
import * as Types from "../../types.js";
interface httpClientConfig {
    baseURL?: string;
    channelAccessToken: string;
    defaultHeaders?: Record<string, string>;
}
export declare class LineModuleClient {
    private httpClient;
    constructor(config: httpClientConfig);
    /**
     * If the Standby Channel wants to take the initiative (Chat Control), it calls the Acquire Control API. The channel that was previously an Active Channel will automatically switch to a Standby Channel.
     * @param chatId The `userId`, `roomId`, or `groupId`
     * @param acquireChatControlRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#acquire-control-api"> Documentation</a>
     */
    acquireChatControl(chatId: string, acquireChatControlRequest?: AcquireChatControlRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * If the Standby Channel wants to take the initiative (Chat Control), it calls the Acquire Control API. The channel that was previously an Active Channel will automatically switch to a Standby Channel. .
     * This method includes HttpInfo object to return additional information.
     * @param chatId The `userId`, `roomId`, or `groupId`
     * @param acquireChatControlRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#acquire-control-api"> Documentation</a>
     */
    acquireChatControlWithHttpInfo(chatId: string, acquireChatControlRequest?: AcquireChatControlRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * The module channel admin calls the Detach API to detach the module channel from a LINE Official Account.
     * @param detachModuleRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#unlink-detach-module-channel-by-operation-mc-admin"> Documentation</a>
     */
    detachModule(detachModuleRequest?: DetachModuleRequest): Promise<Types.MessageAPIResponseBase>;
    /**
     * The module channel admin calls the Detach API to detach the module channel from a LINE Official Account..
     * This method includes HttpInfo object to return additional information.
     * @param detachModuleRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#unlink-detach-module-channel-by-operation-mc-admin"> Documentation</a>
     */
    detachModuleWithHttpInfo(detachModuleRequest?: DetachModuleRequest): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
    /**
     * Gets a list of basic information about the bots of multiple LINE Official Accounts that have attached module channels.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all basic information about the bots in one request, include this parameter to get the remaining array.
     * @param limit Specify the maximum number of bots that you get basic information from. The default value is 100. Max value: 100
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-multiple-bot-info-api"> Documentation</a>
     */
    getModules(start?: string, limit?: number): Promise<GetModulesResponse>;
    /**
     * Gets a list of basic information about the bots of multiple LINE Official Accounts that have attached module channels..
     * This method includes HttpInfo object to return additional information.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all basic information about the bots in one request, include this parameter to get the remaining array.
     * @param limit Specify the maximum number of bots that you get basic information from. The default value is 100. Max value: 100
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-multiple-bot-info-api"> Documentation</a>
     */
    getModulesWithHttpInfo(start?: string, limit?: number): Promise<Types.ApiResponseType<GetModulesResponse>>;
    /**
     * To return the initiative (Chat Control) of Active Channel to Primary Channel, call the Release Control API.
     * @param chatId The `userId`, `roomId`, or `groupId`
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#release-control-api"> Documentation</a>
     */
    releaseChatControl(chatId: string): Promise<Types.MessageAPIResponseBase>;
    /**
     * To return the initiative (Chat Control) of Active Channel to Primary Channel, call the Release Control API. .
     * This method includes HttpInfo object to return additional information.
     * @param chatId The `userId`, `roomId`, or `groupId`
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#release-control-api"> Documentation</a>
     */
    releaseChatControlWithHttpInfo(chatId: string): Promise<Types.ApiResponseType<Types.MessageAPIResponseBase>>;
}
export {};
//# sourceMappingURL=lineModuleClient.d.ts.map