/**
 * LINE Messaging API
 * This document describes LINE Messaging API.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import HTTPFetchClient, { mergeHeaders, } from "../../http-fetch.js";
export class LineModuleClient {
    httpClient;
    constructor(config) {
        const baseURL = config.baseURL || "https://api.line.me";
        const defaultHeaders = mergeHeaders(config.defaultHeaders, {
            Authorization: "Bearer " + config.channelAccessToken,
        });
        this.httpClient = new HTTPFetchClient({
            defaultHeaders: defaultHeaders,
            baseURL: baseURL,
        });
    }
    /**
     * If the Standby Channel wants to take the initiative (Chat Control), it calls the Acquire Control API. The channel that was previously an Active Channel will automatically switch to a Standby Channel.
     * @param chatId The `userId`, `roomId`, or `groupId`
     * @param acquireChatControlRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#acquire-control-api"> Documentation</a>
     */
    async acquireChatControl(chatId, acquireChatControlRequest) {
        return (await this.acquireChatControlWithHttpInfo(chatId, acquireChatControlRequest)).body;
    }
    /**
     * If the Standby Channel wants to take the initiative (Chat Control), it calls the Acquire Control API. The channel that was previously an Active Channel will automatically switch to a Standby Channel. .
     * This method includes HttpInfo object to return additional information.
     * @param chatId The `userId`, `roomId`, or `groupId`
     * @param acquireChatControlRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#acquire-control-api"> Documentation</a>
     */
    async acquireChatControlWithHttpInfo(chatId, acquireChatControlRequest) {
        const params = acquireChatControlRequest;
        const res = await this.httpClient.post("/v2/bot/chat/{chatId}/control/acquire".replace("{chatId}", String(chatId)), params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * The module channel admin calls the Detach API to detach the module channel from a LINE Official Account.
     * @param detachModuleRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#unlink-detach-module-channel-by-operation-mc-admin"> Documentation</a>
     */
    async detachModule(detachModuleRequest) {
        return (await this.detachModuleWithHttpInfo(detachModuleRequest)).body;
    }
    /**
     * The module channel admin calls the Detach API to detach the module channel from a LINE Official Account..
     * This method includes HttpInfo object to return additional information.
     * @param detachModuleRequest
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#unlink-detach-module-channel-by-operation-mc-admin"> Documentation</a>
     */
    async detachModuleWithHttpInfo(detachModuleRequest) {
        const params = detachModuleRequest;
        const res = await this.httpClient.post("/v2/bot/channel/detach", params);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * Gets a list of basic information about the bots of multiple LINE Official Accounts that have attached module channels.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all basic information about the bots in one request, include this parameter to get the remaining array.
     * @param limit Specify the maximum number of bots that you get basic information from. The default value is 100. Max value: 100
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-multiple-bot-info-api"> Documentation</a>
     */
    async getModules(start, limit) {
        return (await this.getModulesWithHttpInfo(start, limit)).body;
    }
    /**
     * Gets a list of basic information about the bots of multiple LINE Official Accounts that have attached module channels..
     * This method includes HttpInfo object to return additional information.
     * @param start Value of the continuation token found in the next property of the JSON object returned in the response. If you can\'t get all basic information about the bots in one request, include this parameter to get the remaining array.
     * @param limit Specify the maximum number of bots that you get basic information from. The default value is 100. Max value: 100
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#get-multiple-bot-info-api"> Documentation</a>
     */
    async getModulesWithHttpInfo(start, limit) {
        const queryParams = {
            start: start,
            limit: limit,
        };
        Object.keys(queryParams).forEach((key) => {
            if (queryParams[key] === undefined) {
                delete queryParams[key];
            }
        });
        const res = await this.httpClient.get("/v2/bot/list", queryParams);
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
    /**
     * To return the initiative (Chat Control) of Active Channel to Primary Channel, call the Release Control API.
     * @param chatId The `userId`, `roomId`, or `groupId`
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#release-control-api"> Documentation</a>
     */
    async releaseChatControl(chatId) {
        return (await this.releaseChatControlWithHttpInfo(chatId)).body;
    }
    /**
     * To return the initiative (Chat Control) of Active Channel to Primary Channel, call the Release Control API. .
     * This method includes HttpInfo object to return additional information.
     * @param chatId The `userId`, `roomId`, or `groupId`
     *
     * @see <a href="https://developers.line.biz/en/reference/partner-docs/#release-control-api"> Documentation</a>
     */
    async releaseChatControlWithHttpInfo(chatId) {
        const res = await this.httpClient.post("/v2/bot/chat/{chatId}/control/release".replace("{chatId}", String(chatId)));
        const text = await res.text();
        const parsedBody = text ? JSON.parse(text) : null;
        return { httpResponse: res, body: parsedBody };
    }
}
//# sourceMappingURL=lineModuleClient.js.map